/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.RepositoryProviderMap;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.internal.ui.Messages;
import org.eclipse.oomph.targlets.internal.ui.TargletsUIPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class ManifestDiscoveryDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.oomph.targlets.ui.PluginSelectionDialog";
    private final ILabelProvider labelProvider;
    private final String namespace;
    private final List<ITargletContainer> targletContainers;

    public ManifestDiscoveryDialog(Shell parentShell, String namespace, List<ITargletContainer> targletContainers, boolean multipleSelection) {
        super(parentShell, multipleSelection);
        this.namespace = namespace;
        this.targletContainers = targletContainers;
        if ("org.eclipse.update.feature".equals(namespace)) {
            this.setTitle(Messages.ManifestDiscoveryDialog_title_featureDiscovery);
            this.setMessage(PDEUIMessages.FeatureBlock_SelectFeatures);
        } else if ("java.package".equals(namespace)) {
            this.setTitle(Messages.ManifestDiscoveryDialog_title_packageDiscovery);
            this.setMessage(PDEUIMessages.ImportPackageSection_exported);
        } else {
            this.setTitle(Messages.ManifestDiscoveryDialog_title_pluginDiscovery);
            this.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        }
        this.labelProvider = new ManifestDiscoveryLabelProvider(namespace);
        this.setListLabelProvider(this.labelProvider);
    }

    public boolean close() {
        this.labelProvider.dispose();
        return super.close();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ManifestDiscoveryItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        IMetadataRepositoryManager repositoryManager = agent.getMetadataRepositoryManager();
        RepositoryProviderMap.Metadata repositoryProviderMap = new RepositoryProviderMap.Metadata(repositoryManager);
        try {
            HashSet<String> urls = new HashSet<String>();
            for (ITargletContainer targletContainer : this.targletContainers) {
                for (Targlet targlet : targletContainer.getTarglets()) {
                    RepositoryList activeRepositoryList = targlet.getActiveRepositoryList();
                    if (activeRepositoryList == null) continue;
                    for (Repository repository : activeRepositoryList.getRepositories()) {
                        try {
                            String url = repository.getURL();
                            urls.add(url);
                        }
                        catch (Exception ex) {
                            TargletsUIPlugin.INSTANCE.log(ex, 2);
                        }
                    }
                }
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * urls.size() + 1));
            ArrayList<IMetadataRepository> queryables = new ArrayList<IMetadataRepository>();
            for (String url : urls) {
                try {
                    IMetadataRepository queryable = (IMetadataRepository)repositoryProviderMap.getRepository(new URI(url), (IProgressMonitor)progress.newChild(10));
                    queryables.add(queryable);
                }
                catch (Exception ex) {
                    TargletsUIPlugin.INSTANCE.log(ex, 2);
                }
            }
            for (ITargletContainer targletContainer : this.targletContainers) {
                for (Targlet targlet : targletContainer.getTarglets()) {
                    RepositoryList activeRepositoryList = targlet.getActiveRepositoryList();
                    if (activeRepositoryList == null) continue;
                    for (Repository repository : activeRepositoryList.getRepositories()) {
                        String url = repository.getURL();
                        if (!urls.add(url)) continue;
                        try {
                            IMetadataRepository queryable = (IMetadataRepository)repositoryProviderMap.getRepository(new URI(url));
                            queryables.add(queryable);
                        }
                        catch (URISyntaxException ex) {
                            TargletsUIPlugin.INSTANCE.log(ex, 2);
                        }
                    }
                }
            }
            IQueryable[] array = queryables.toArray(new IQueryable[queryables.size()]);
            CompoundQueryable compoundQueryable = new CompoundQueryable(array);
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)compoundQueryable.query(QueryUtil.createLatestIUQuery(), (IProgressMonitor)progress.newChild(1)))) {
                if (iu.getId().endsWith(".source")) continue;
                for (IProvidedCapability capability : iu.getProvidedCapabilities()) {
                    if (!this.namespace.equals(capability.getNamespace())) continue;
                    String name = capability.getName();
                    VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(capability.getVersion(), VersionSegment.QUALIFIER, false);
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                    requirement.setNamespace(this.namespace);
                    requirement.setName(name);
                    requirement.setVersionRange(versionRange);
                    contentProvider.add((Object)requirement, itemsFilter);
                }
            }
        }
        finally {
            repositoryProviderMap.dispose();
            monitor.done();
        }
    }

    protected IDialogSettings getDialogSettings() {
        return TargletsUIPlugin.INSTANCE.getDialogSettings(DIALOG_SETTINGS);
    }

    public String getElementName(Object item) {
        return ((Requirement)item).getName();
    }

    protected Comparator<?> getItemsComparator() {
        return new ManifestDiscoveryComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.pde.ui", 0, "", null);
    }

    private static final class ManifestDiscoveryComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            return ((Requirement)o1).getName().compareTo(((Requirement)o2).getName());
        }
    }

    private final class ManifestDiscoveryItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public ManifestDiscoveryItemsFilter() {
            super((FilteredItemsSelectionDialog)ManifestDiscoveryDialog.this);
            Object pattern = this.patternMatcher.getPattern();
            if (((String)pattern).indexOf("*") != 0 && ((String)pattern).indexOf("?") != 0 && ((String)pattern).indexOf(".") != 0) {
                pattern = "*" + (String)pattern;
                this.patternMatcher.setPattern((String)pattern);
            }
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            return this.matches(((Requirement)item).getName());
        }
    }

    private static final class ManifestDiscoveryLabelProvider
    extends LabelProvider {
        private static final Image FEATURE_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactFeature");
        private static final Image PLUGIN_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactPlugin");
        private static final Image PACKAGE_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("full/obj16/Requirement_Package");
        private final String namespace;

        public ManifestDiscoveryLabelProvider(String namespace) {
            this.namespace = namespace;
        }

        public Image getImage(Object element) {
            if ("osgi.bundle".equals(this.namespace)) {
                return PLUGIN_IMAGE;
            }
            if ("org.eclipse.update.feature".equals(this.namespace)) {
                return FEATURE_IMAGE;
            }
            if ("java.package".equals(this.namespace)) {
                return PACKAGE_IMAGE;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof Requirement) {
                Requirement requirement = (Requirement)element;
                Object text = requirement.getName();
                Version version = requirement.getVersionRange().getMinimum();
                if (version != null && !version.equals(Version.emptyVersion)) {
                    text = (String)text + " (" + String.valueOf(version) + ")";
                }
                return text;
            }
            return super.getText(element);
        }
    }
}

