/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.junit.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.oomph.junit.JUnitDocumentRoot;
import org.eclipse.oomph.junit.JUnitPackage;
import org.eclipse.oomph.junit.ProblemType;
import org.eclipse.oomph.junit.PropertiesType;
import org.eclipse.oomph.junit.PropertyType;
import org.eclipse.oomph.junit.TestCaseType;
import org.eclipse.oomph.junit.TestSuite;
import org.eclipse.oomph.junit.TestSuiteType;
import org.eclipse.oomph.junit.TestSuitesType;

public class JUnitValidator
extends EObjectValidator {
    public static final JUnitValidator INSTANCE = new JUnitValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.oomph.junit";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return JUnitPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateJUnitDocumentRoot((JUnitDocumentRoot)((Object)value), diagnostics, context);
            }
            case 1: {
                return this.validateTestSuitesType((TestSuitesType)((Object)value), diagnostics, context);
            }
            case 2: {
                return this.validateTestSuite((TestSuite)((Object)value), diagnostics, context);
            }
            case 3: {
                return this.validateTestSuiteType((TestSuiteType)((Object)value), diagnostics, context);
            }
            case 4: {
                return this.validateTestCaseType((TestCaseType)((Object)value), diagnostics, context);
            }
            case 5: {
                return this.validateProblemType((ProblemType)((Object)value), diagnostics, context);
            }
            case 6: {
                return this.validatePropertiesType((PropertiesType)((Object)value), diagnostics, context);
            }
            case 7: {
                return this.validatePropertyType((PropertyType)((Object)value), diagnostics, context);
            }
            case 8: {
                return this.validateISO8601DateTime((Long)value, diagnostics, context);
            }
            case 9: {
                return this.validateNameType((String)value, diagnostics, context);
            }
            case 10: {
                return this.validateTime((Double)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateJUnitDocumentRoot(JUnitDocumentRoot jUnitDocumentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)jUnitDocumentRoot, diagnostics, context);
    }

    public boolean validateTestSuitesType(TestSuitesType testSuitesType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)testSuitesType, diagnostics, context);
    }

    public boolean validateTestSuite(TestSuite testSuite, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)testSuite, diagnostics, context);
    }

    public boolean validateTestSuiteType(TestSuiteType testSuiteType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)testSuiteType, diagnostics, context);
    }

    public boolean validateTestCaseType(TestCaseType testCaseType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)testCaseType, diagnostics, context);
    }

    public boolean validatePropertiesType(PropertiesType propertiesType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)propertiesType, diagnostics, context);
    }

    public boolean validatePropertyType(PropertyType propertyType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)propertyType, diagnostics, context);
    }

    public boolean validateProblemType(ProblemType problemType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)problemType, diagnostics, context);
    }

    public boolean validateISO8601DateTime(long iso8601DateTime, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateNameType(String nameType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateNameType_MinLength(nameType, diagnostics, context);
        return result;
    }

    public boolean validateNameType_MinLength(String nameType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = nameType.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(JUnitPackage.Literals.NAME_TYPE, nameType, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateTime(double time, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

