/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.eclipse.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.paho.client.eclipse.view.Messages;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class MqttClientView
extends ViewPart
implements MqttCallback {
    private Display display;
    private Composite parent;
    private static MqttClient mqttClient = null;
    private static MqttConnectOptions connOpts = null;
    private static String connectAddress = "";
    private static int connectPort = 1883;
    private static String clientId = "";
    private static short keepAlive = (short)30;
    private static boolean cleanStart = true;
    private static boolean firstConnect = true;
    private static Boolean connected = new Boolean(false);
    private static String tmpMsg = null;
    private static String willTopic = "";
    private static String willMessage = "";
    private static int willQos = 0;
    private static boolean willRetain = false;
    private static String username = "";
    private static String password = "";
    private String publishTopic = null;
    private int publishQos = 0;
    private boolean retain = false;
    private byte[] payload = null;
    private boolean useWill = false;
    private String subscribeTopic = null;
    private int subscribeQos = 0;
    private Text subscribeTopicValue;
    private Text publishTopicValue;
    private Text publishPayloadValue;
    private Text publishFileName;
    private Text brokerAddressValue;
    private Text brokerPortValue;
    private Text clientIdValue;
    private Text keepAliveValue;
    private Text messageLog;
    private Text willTopicValue;
    private Text willMessageValue;
    private Text usernameValue;
    private Text passwordValue;
    private Button willCheckBox;
    private Button willRetainCheckBox;
    private Button cleanStartCheckBox;
    private Button connectButton;
    private Button disconnectButton;
    private Button publishRetainCheckBox;
    private Group connectionGroup;
    private Group publishGroup;
    private Group subscribeGroup;
    private Combo subscribeQosDrop;
    private Combo publishQosDrop;
    private Combo willQosDrop;
    private SelectionListener willListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            MqttClientView.this.useWill = MqttClientView.this.willCheckBox.getSelection();
            MqttClientView.this.willTopicValue.setEnabled(MqttClientView.this.useWill);
            MqttClientView.this.willMessageValue.setEnabled(MqttClientView.this.useWill);
            MqttClientView.this.willQosDrop.setEnabled(MqttClientView.this.useWill);
            MqttClientView.this.willRetainCheckBox.setEnabled(MqttClientView.this.useWill);
        }
    };
    private SelectionListener selectListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            cleanStart = MqttClientView.this.cleanStartCheckBox.getSelection();
            MqttClientView.this.updateInfo();
        }
    };
    private SelectionListener connectListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == MqttClientView.this.connectButton) {
                MqttClientView.this.connect();
            } else if (e.getSource() == MqttClientView.this.disconnectButton) {
                MqttClientView.this.disconnect();
            }
        }
    };
    private SelectionListener publishListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            MqttClientView.this.publishTopic = MqttClientView.this.publishTopicValue.getText();
            MqttClientView.this.publishQos = Integer.parseInt(MqttClientView.this.publishQosDrop.getText());
            MqttClientView.this.retain = MqttClientView.this.publishRetainCheckBox.getSelection();
            MqttClientView.this.payload = MqttClientView.this.publishPayloadValue.getText().getBytes();
            MqttClientView.this.publish();
        }
    };
    private SelectionListener publishFileListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            MqttClientView.this.publishTopic = MqttClientView.this.publishTopicValue.getText();
            MqttClientView.this.publishQos = Integer.parseInt(MqttClientView.this.publishQosDrop.getText());
            MqttClientView.this.retain = MqttClientView.this.publishRetainCheckBox.getSelection();
            String filename = MqttClientView.this.publishFileName.getText();
            try {
                MqttClientView.this.payload = MqttClientView.getBytesFromFile(new File(filename));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            MqttClientView.this.publish();
        }
    };
    private SelectionListener subscribeListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            MqttClientView.this.subscribeTopic = MqttClientView.this.subscribeTopicValue.getText();
            MqttClientView.this.subscribeQos = Integer.parseInt(MqttClientView.this.subscribeQosDrop.getText());
            MqttClientView.this.subscribe();
            MqttClientView.this.publishTopicValue.setText(MqttClientView.this.subscribeTopic);
        }
    };
    private SelectionListener unsubscribeListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            MqttClientView.this.subscribeTopic = MqttClientView.this.subscribeTopicValue.getText();
            MqttClientView.this.unsubscribe();
        }
    };

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.display = parent.getDisplay();
        FillLayout masterLayout = new FillLayout();
        parent.setLayout((Layout)masterLayout);
        SashForm sashform = new SashForm(parent, 512);
        TabFolder tabFolder = new TabFolder((Composite)sashform, 768);
        TabItem one = new TabItem(tabFolder, 0);
        one.setText(Messages.MqttClientView_6);
        one.setToolTipText(Messages.MqttClientView_7);
        one.setControl(this.getConnectionControl(tabFolder));
        TabItem two = new TabItem(tabFolder, 0);
        two.setText(Messages.MqttClientView_8);
        two.setToolTipText(Messages.MqttClientView_9);
        two.setControl(this.getPublishControl(tabFolder));
        TabItem three = new TabItem(tabFolder, 0);
        three.setText(Messages.MqttClientView_10);
        three.setToolTipText(Messages.MqttClientView_11);
        three.setControl(this.getSubscribeControl(tabFolder));
        this.messageLog = new Text((Composite)sashform, 2816);
        this.messageLog.setFont(new Font((Device)this.display, new FontData("Courier New", 10, 0)));
        sashform.setWeights(new int[]{2, 1});
    }

    public void valueChanged(Text text) {
        this.updateInfo();
    }

    private void addressValueChanged(Text text) {
        this.updateInfo();
        firstConnect = true;
    }

    private void updateInfo() {
        connectAddress = this.brokerAddressValue.getText();
        willTopic = this.willTopicValue.getText();
        willMessage = this.willMessageValue.getText();
        clientId = this.clientIdValue.getText();
        willQos = Integer.parseInt(this.willQosDrop.getText());
        willRetain = this.willRetainCheckBox.getSelection();
        username = this.usernameValue.getText();
        password = this.passwordValue.getText();
        try {
            connectPort = Integer.parseInt(this.brokerPortValue.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            keepAlive = Short.parseShort(this.keepAliveValue.getText());
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void connect() {
        if (!connected.booleanValue()) {
            this.updateInfo();
            String connectString = "tcp://" + connectAddress + ":" + connectPort;
            if (clientId == null || clientId.length() < 1) {
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_15 + connectString + Messages.MqttClientView_16);
                return;
            }
            try {
                if (firstConnect) {
                    mqttClient = new MqttClient(connectString, clientId);
                    mqttClient.setCallback((MqttCallback)this);
                    firstConnect = false;
                }
            }
            catch (MqttException e) {
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_17 + e.getMessage());
                e.printStackTrace();
            }
            connOpts = new MqttConnectOptions();
            connOpts.setCleanSession(cleanStart);
            connOpts.setConnectionTimeout(30);
            connOpts.setKeepAliveInterval((int)keepAlive);
            if (username.length() > 0 && password.length() > 0) {
                connOpts.setPassword(password.toCharArray());
                connOpts.setUserName(username);
            }
            if (this.useWill) {
                if (willTopic == null || willTopic.equals("")) {
                    this.out(Messages.MqttClientView_19);
                    return;
                }
                connOpts.setWill(mqttClient.getTopic(willTopic), willMessage.getBytes(), willQos, willRetain);
            }
            try {
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_20 + connectString);
                mqttClient.connect(connOpts);
                connected = true;
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_21 + clientId);
            }
            catch (MqttException e) {
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_22 + e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.out(Messages.MqttClientView_23);
        }
    }

    private void disconnect() {
        try {
            if (connected.booleanValue()) {
                mqttClient.disconnect();
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_24);
            } else {
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_25);
            }
        }
        catch (MqttException e) {
            this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_26 + e.getMessage());
        }
        connected = false;
    }

    private void publish() {
        if (mqttClient != null) {
            if (this.publishTopic == null || this.publishTopic.equals("")) {
                this.out(Messages.MqttClientView_28);
                return;
            }
            try {
                MqttTopic topic = mqttClient.getTopic(this.publishTopic);
                topic.publish(this.payload, this.publishQos, this.retain);
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_29);
                this.out(String.valueOf(Messages.MqttClientView_30) + this.publishTopic + "\"\n" + Messages.MqttClientView_32 + this.publishQos + "\n" + Messages.MqttClientView_34 + this.retain + "\n" + Messages.MqttClientView_36 + new String(this.payload) + "\"");
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.out(Messages.MqttClientView_12);
            }
        }
    }

    private void subscribe() {
        if (mqttClient != null) {
            try {
                String[] topicArray = new String[]{this.subscribeTopic};
                int[] qosArray = new int[]{this.subscribeQos};
                mqttClient.subscribe(topicArray, qosArray);
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_38);
                this.out(String.valueOf(Messages.MqttClientView_39) + this.subscribeTopic + "\"\n" + Messages.MqttClientView_41 + this.subscribeQos);
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }
    }

    private void unsubscribe() {
        if (mqttClient != null) {
            try {
                String[] topicArray = new String[]{this.subscribeTopic};
                mqttClient.unsubscribe(topicArray);
                this.out(String.valueOf(this.getDate()) + Messages.MqttClientView_42);
                this.out(String.valueOf(Messages.MqttClientView_43) + this.subscribeTopic + "\"");
            }
            catch (MqttPersistenceException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }
    }

    public void connectionLost(Throwable cause) {
        connected = false;
        this.syncOut(String.valueOf(this.getDate()) + Messages.MqttClientView_45);
        String connectString = String.valueOf(connectAddress) + ":" + connectPort;
        this.syncOut(String.valueOf(this.getDate()) + Messages.MqttClientView_47 + connectString);
        try {
            mqttClient.connect(connOpts);
        }
        catch (Exception exception) {
            this.syncOut(String.valueOf(this.getDate()) + Messages.MqttClientView_48);
            this.syncOut(String.valueOf(this.getDate()) + Messages.MqttClientView_49);
        }
        connected = true;
        this.syncOut(String.valueOf(this.getDate()) + Messages.MqttClientView_50 + clientId);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        this.syncOut(String.valueOf(this.getDate()) + Messages.MqttClientView_51);
        this.syncOut(String.valueOf(Messages.MqttClientView_52) + topic + "\"");
        this.syncOut(String.valueOf(Messages.MqttClientView_54) + new String(message.getPayload()) + "\"");
    }

    public void deliveryComplete(MqttDeliveryToken token) {
        this.syncOut(String.valueOf(this.getDate()) + Messages.MqttClientView_56);
    }

    private void syncOut(String msg) {
        tmpMsg = msg;
        this.parent.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MqttClientView.this.out(tmpMsg);
            }
        });
    }

    public static String getHexString(byte[] b) {
        String result = "";
        int i = 0;
        while (i < b.length) {
            result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            ++i;
        }
        return result;
    }

    private void out(String message) {
        this.messageLog.append(String.valueOf(message) + "\n");
    }

    private String getDate() {
        System.currentTimeMillis();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SS");
        Date currentTime_1 = new Date();
        String dateString = formatter.format(currentTime_1);
        return "[" + dateString + "] ";
    }

    private Control getConnectionControl(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout(512));
        this.connectionGroup = new Group(composite, 0);
        this.connectionGroup.setLayout((Layout)new GridLayout(2, false));
        this.connectionGroup.setLayoutData((Object)new GridData(272));
        this.connectionGroup.setText(Messages.MqttClientView_62);
        Label brokerAddressLabel = new Label((Composite)this.connectionGroup, 0);
        brokerAddressLabel.setText(Messages.MqttClientView_63);
        this.brokerAddressValue = new Text((Composite)this.connectionGroup, 2052);
        this.brokerAddressValue.setLayoutData((Object)new GridData(120, 13));
        this.brokerAddressValue.setText(connectAddress);
        this.brokerAddressValue.setToolTipText(Messages.MqttClientView_64);
        Label brokerPortLabel = new Label((Composite)this.connectionGroup, 0);
        brokerPortLabel.setText(Messages.MqttClientView_65);
        this.brokerPortValue = new Text((Composite)this.connectionGroup, 2052);
        this.brokerPortValue.setLayoutData((Object)new GridData(30, 13));
        this.brokerPortValue.setText(Integer.toString(connectPort));
        this.brokerPortValue.setToolTipText(Messages.MqttClientView_66);
        Label clientIdLabel = new Label((Composite)this.connectionGroup, 0);
        clientIdLabel.setText(Messages.MqttClientView_67);
        this.clientIdValue = new Text((Composite)this.connectionGroup, 2052);
        this.clientIdValue.setLayoutData((Object)new GridData(272));
        this.clientIdValue.setText(clientId);
        this.clientIdValue.setToolTipText(Messages.MqttClientView_68);
        Label usernameLabel = new Label((Composite)this.connectionGroup, 0);
        usernameLabel.setText(Messages.MqttClientView_69);
        this.usernameValue = new Text((Composite)this.connectionGroup, 2052);
        this.usernameValue.setLayoutData((Object)new GridData(272));
        this.usernameValue.setText(username);
        this.usernameValue.setToolTipText(Messages.MqttClientView_70);
        Label passwordLabel = new Label((Composite)this.connectionGroup, 0);
        passwordLabel.setText(Messages.MqttClientView_71);
        this.passwordValue = new Text((Composite)this.connectionGroup, 2052);
        this.passwordValue.setLayoutData((Object)new GridData(272));
        this.passwordValue.setText(password);
        this.passwordValue.setToolTipText(Messages.MqttClientView_72);
        Label keepAliveLabel = new Label((Composite)this.connectionGroup, 0);
        keepAliveLabel.setText(Messages.MqttClientView_73);
        this.keepAliveValue = new Text((Composite)this.connectionGroup, 2052);
        this.keepAliveValue.setLayoutData((Object)new GridData(30, 13));
        this.keepAliveValue.setText(Short.toString(keepAlive));
        this.keepAliveValue.setToolTipText(Messages.MqttClientView_74);
        Label cleanStartLabel = new Label((Composite)this.connectionGroup, 0);
        cleanStartLabel.setText(Messages.MqttClientView_75);
        this.cleanStartCheckBox = new Button((Composite)this.connectionGroup, 32);
        this.cleanStartCheckBox.setSelection(cleanStart);
        this.cleanStartCheckBox.setToolTipText(Messages.MqttClientView_76);
        Label useWillLabel = new Label((Composite)this.connectionGroup, 0);
        useWillLabel.setText(Messages.MqttClientView_77);
        this.willCheckBox = new Button((Composite)this.connectionGroup, 32);
        this.willCheckBox.setSelection(false);
        this.willCheckBox.setToolTipText(Messages.MqttClientView_78);
        Label willTopicLabel = new Label((Composite)this.connectionGroup, 0);
        willTopicLabel.setText(Messages.MqttClientView_79);
        this.willTopicValue = new Text((Composite)this.connectionGroup, 2052);
        this.willTopicValue.setLayoutData((Object)new GridData(784));
        this.willTopicValue.setText(willTopic);
        this.willTopicValue.setEnabled(this.useWill);
        this.willTopicValue.setToolTipText(Messages.MqttClientView_80);
        Label willMessageLabel = new Label((Composite)this.connectionGroup, 0);
        willMessageLabel.setText(Messages.MqttClientView_81);
        this.willMessageValue = new Text((Composite)this.connectionGroup, 2052);
        this.willMessageValue.setLayoutData((Object)new GridData(784));
        this.willMessageValue.setText(willMessage);
        this.willMessageValue.setEnabled(this.useWill);
        this.willMessageValue.setToolTipText(Messages.MqttClientView_82);
        Label willQosLabel = new Label((Composite)this.connectionGroup, 0);
        willQosLabel.setText(Messages.MqttClientView_83);
        this.willQosDrop = new Combo((Composite)this.connectionGroup, 2052);
        this.willQosDrop.add("0");
        this.willQosDrop.add("1");
        this.willQosDrop.add("2");
        this.willQosDrop.select(0);
        Label willRetainedLabel = new Label((Composite)this.connectionGroup, 0);
        willRetainedLabel.setText(Messages.MqttClientView_87);
        this.willRetainCheckBox = new Button((Composite)this.connectionGroup, 32);
        this.willRetainCheckBox.setSelection(false);
        this.willRetainCheckBox.setToolTipText(Messages.MqttClientView_88);
        this.connectButton = new Button((Composite)this.connectionGroup, 8);
        this.connectButton.setLayoutData((Object)new GridData(120, 25));
        this.connectButton.setText(Messages.MqttClientView_89);
        this.connectButton.setToolTipText(Messages.MqttClientView_90);
        this.disconnectButton = new Button((Composite)this.connectionGroup, 8);
        this.disconnectButton.setLayoutData((Object)new GridData(120, 25));
        this.disconnectButton.setText(Messages.MqttClientView_91);
        this.disconnectButton.setToolTipText(Messages.MqttClientView_92);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MqttClientView.this.valueChanged((Text)e.widget);
            }
        };
        ModifyListener addressListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MqttClientView.this.addressValueChanged((Text)e.widget);
            }
        };
        this.brokerAddressValue.addModifyListener(addressListener);
        this.brokerPortValue.addModifyListener(addressListener);
        this.clientIdValue.addModifyListener(listener);
        this.usernameValue.addModifyListener(listener);
        this.passwordValue.addModifyListener(listener);
        this.keepAliveValue.addModifyListener(listener);
        this.cleanStartCheckBox.addSelectionListener(this.selectListener);
        this.connectButton.addSelectionListener(this.connectListener);
        this.disconnectButton.addSelectionListener(this.connectListener);
        this.willCheckBox.addSelectionListener(this.willListener);
        this.willTopicValue.addModifyListener(listener);
        this.willMessageValue.addModifyListener(listener);
        return composite;
    }

    private Control getPublishControl(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout(512));
        this.publishGroup = new Group(composite, 0);
        this.publishGroup.setLayout((Layout)new GridLayout(3, false));
        this.publishGroup.setLayoutData((Object)new GridData(272));
        this.publishGroup.setText(Messages.MqttClientView_93);
        Label publishTopicLabel = new Label((Composite)this.publishGroup, 0);
        publishTopicLabel.setText(Messages.MqttClientView_94);
        this.publishTopicValue = new Text((Composite)this.publishGroup, 2052);
        this.publishTopicValue.setLayoutData((Object)new GridData(784));
        this.publishTopicValue.setSize(110, 1);
        new Label((Composite)this.publishGroup, 0);
        Label publishQosLabel = new Label((Composite)this.publishGroup, 0);
        publishQosLabel.setText(Messages.MqttClientView_95);
        this.publishQosDrop = new Combo((Composite)this.publishGroup, 2052);
        this.publishQosDrop.add("0");
        this.publishQosDrop.add("1");
        this.publishQosDrop.add("2");
        this.publishQosDrop.select(0);
        new Label((Composite)this.publishGroup, 0);
        Label publishRetainedLabel = new Label((Composite)this.publishGroup, 0);
        publishRetainedLabel.setText(Messages.MqttClientView_96);
        this.publishRetainCheckBox = new Button((Composite)this.publishGroup, 32);
        this.publishRetainCheckBox.setSelection(false);
        this.publishRetainCheckBox.setToolTipText(Messages.MqttClientView_97);
        new Label((Composite)this.publishGroup, 0);
        Label publishPayloadLabel = new Label((Composite)this.publishGroup, 0);
        publishPayloadLabel.setText(Messages.MqttClientView_99);
        this.publishPayloadValue = new Text((Composite)this.publishGroup, 2052);
        this.publishPayloadValue.setLayoutData((Object)new GridData(784));
        this.publishPayloadValue.setSize(110, 1);
        new Label((Composite)this.publishGroup, 0);
        new Label((Composite)this.publishGroup, 0);
        Button publishPayloadButton = new Button((Composite)this.publishGroup, 8);
        publishPayloadButton.setLayoutData((Object)new GridData(120, 25));
        publishPayloadButton.setText(Messages.MqttClientView_100);
        new Label((Composite)this.publishGroup, 0);
        Label publishFileLabel = new Label((Composite)this.publishGroup, 0);
        publishFileLabel.setText(Messages.MqttClientView_101);
        this.publishFileName = new Text((Composite)this.publishGroup, 2052);
        this.publishFileName.setLayoutData((Object)new GridData(784));
        this.publishFileName.setSize(100, 1);
        Button browseButton = new Button((Composite)this.publishGroup, 8);
        browseButton.setText(Messages.MqttClientView_102);
        new Label((Composite)this.publishGroup, 0);
        Button publishFileButton = new Button((Composite)this.publishGroup, 8);
        publishFileButton.setLayoutData((Object)new GridData(120, 25));
        publishFileButton.setText(Messages.MqttClientView_103);
        publishPayloadButton.addSelectionListener(this.publishListener);
        publishFileButton.addSelectionListener(this.publishFileListener);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(new Shell(), 0);
                String path = dialog.open();
                if (path != null) {
                    File file = new File(path);
                    if (file.isFile()) {
                        MqttClientView.this.displayFiles(new String[]{file.toString()});
                    } else {
                        MqttClientView.this.displayFiles(file.list());
                    }
                }
            }
        });
        return composite;
    }

    private void displayFiles(String[] files) {
        int i = 0;
        while (files != null && i < files.length) {
            this.publishFileName.setText(files[i]);
            this.publishFileName.setEditable(true);
            ++i;
        }
    }

    private Control getSubscribeControl(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout(512));
        this.subscribeGroup = new Group(composite, 0);
        this.subscribeGroup.setLayout((Layout)new GridLayout(2, false));
        this.subscribeGroup.setLayoutData((Object)new GridData(784));
        this.subscribeGroup.setText(Messages.MqttClientView_104);
        Label subscribeTopicLabel = new Label((Composite)this.subscribeGroup, 0);
        subscribeTopicLabel.setText(Messages.MqttClientView_105);
        this.subscribeTopicValue = new Text((Composite)this.subscribeGroup, 2052);
        this.subscribeTopicValue.setLayoutData((Object)new GridData(784));
        this.subscribeTopicValue.setSize(80, 1);
        Label subscribeQosLabel = new Label((Composite)this.subscribeGroup, 0);
        subscribeQosLabel.setText(Messages.MqttClientView_106);
        this.subscribeQosDrop = new Combo((Composite)this.subscribeGroup, 2052);
        this.subscribeQosDrop.add("0");
        this.subscribeQosDrop.add("1");
        this.subscribeQosDrop.add("2");
        this.subscribeQosDrop.select(0);
        Button subscribeButton = new Button((Composite)this.subscribeGroup, 8);
        subscribeButton.setLayoutData((Object)new GridData(120, 25));
        subscribeButton.setText(Messages.MqttClientView_110);
        Button unsubscribeButton = new Button((Composite)this.subscribeGroup, 8);
        unsubscribeButton.setLayoutData((Object)new GridData(120, 25));
        unsubscribeButton.setText(Messages.MqttClientView_111);
        subscribeButton.addSelectionListener(this.subscribeListener);
        unsubscribeButton.addSelectionListener(this.unsubscribeListener);
        return composite;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        ((InputStream)is).close();
        return bytes;
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
    }
}

