/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.features.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.passage.lic.features.model.meta.FeaturesPackage;
import org.eclipse.passage.loc.internal.emf.SelectionCommandAdvisor;
import org.eclipse.passage.loc.internal.features.FeatureRegistry;
import org.eclipse.passage.loc.internal.features.core.i18n.FeaturesCoreMessages;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=features"})
public class FeaturesSelectionCommandAdvisor
implements SelectionCommandAdvisor {
    private final List<FeatureRegistry> features = new ArrayList<FeatureRegistry>();

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void bindFeatures(FeatureRegistry registry) {
        this.features.add(registry);
    }

    public void unbindFeatures(FeatureRegistry registry) {
        this.features.remove(registry);
    }

    public String getSelectionTitle(String classifier) {
        if (FeaturesPackage.eINSTANCE.getFeatureSet().getName().equals(classifier)) {
            return FeaturesCoreMessages.FeaturesSelectionCommandAdvisor_select_feature_set;
        }
        if (FeaturesPackage.eINSTANCE.getFeature().getName().equals(classifier)) {
            return FeaturesCoreMessages.FeaturesSelectionCommandAdvisor_select_feature;
        }
        if (FeaturesPackage.eINSTANCE.getFeatureVersion().getName().equals(classifier)) {
            return FeaturesCoreMessages.FeaturesSelectionCommandAdvisor_select_feature_version;
        }
        return null;
    }

    public Iterable<?> getSelectionInput(String classifier) {
        if (FeaturesPackage.eINSTANCE.getFeatureSet().getName().equals(classifier)) {
            return this.features().featureSets();
        }
        if (FeaturesPackage.eINSTANCE.getFeature().getName().equals(classifier)) {
            return this.features().features();
        }
        if (FeaturesPackage.eINSTANCE.getFeatureVersion().getName().equals(classifier)) {
            return this.features().featureVersions();
        }
        return Collections.emptyList();
    }

    private FeatureRegistry features() {
        return (FeatureRegistry)this.features.stream().findAny().get();
    }
}

