/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core.request;

import java.time.LocalDate;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;
import org.eclipse.passage.loc.internal.licenses.core.request.GeneralLicenseData;

public final class PersonalLicenseData
extends GeneralLicenseData
implements PersonalLicenseRequest {
    private final Supplier<User> user;

    public PersonalLicenseData(Supplier<User> user, Supplier<LicensePlan> plan, Supplier<ProductVersion> product, Supplier<LocalDate> from, Supplier<LocalDate> until) {
        super(plan, product, from, until);
        this.user = Objects.requireNonNull(user);
    }

    public String user() {
        return this.user.get().getContact().getEmail();
    }

    public String userFullName() {
        return this.user.get().getContact().getName();
    }

    public String conditionType() {
        return this.user.get().getPreferredEvaluationType();
    }

    public String conditionExpression() {
        return this.user.get().getPreferredEvaluationExpression();
    }
}

