/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.user;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.licenses.model.api.LicenseRequisites;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.lic.users.model.api.UserOrigin;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.eclipse.passage.loc.report.internal.core.user.CustomerStorage;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class Customers
implements CustomerStorage {
    private UserRegistry users;
    private LicenseRegistry licenses;

    @Override
    public Set<User> personsUsedProducts(Set<String> products) {
        return this.licenses.plans().stream().map(plan -> this.licenses((Collection)plan.getPersonal(), products, (Function)PersonalLicensePack::getLicense)).flatMap(Collection::stream).map(this::user).distinct().map(arg_0 -> ((UserRegistry)this.users).user(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Override
    public Set<UserOrigin> companiesUsedProducts(Set<String> products) {
        return this.licenses.plans().stream().map(plan -> this.licenses((Collection)plan.getFloating(), products, (Function)FloatingLicensePack::getLicense)).flatMap(Collection::stream).map(this::company).distinct().map(arg_0 -> ((UserRegistry)this.users).userOrigin(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Override
    public Set<String> products() {
        return this.licenses.plans().stream().map(LicensePlan::getPersonal).flatMap(Collection::stream).map(this::product).collect(Collectors.toSet());
    }

    @Reference
    public void installUserRegistry(UserRegistry registry) {
        this.users = registry;
    }

    @Reference
    public void installLicensesRegistry(LicenseRegistry registry) {
        this.licenses = registry;
    }

    private <T> Set<T> licenses(Collection<T> packs, Set<String> products, Function<T, LicenseRequisites> license) {
        return packs.stream().filter(pack -> this.forProduct((LicenseRequisites)license.apply(pack), products)).collect(Collectors.toSet());
    }

    private boolean forProduct(LicenseRequisites lic, Set<String> products) {
        return products.contains(lic.getProduct().getIdentifier());
    }

    private String user(PersonalLicensePack pack) {
        return pack.getLicense().getUser().getIdentifier();
    }

    private String company(FloatingLicensePack pack) {
        return pack.getLicense().getCompany().getIdentifier();
    }

    private String product(PersonalLicensePack pack) {
        return pack.getLicense().getProduct().getIdentifier();
    }
}

