/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.osgi.service.prefs.BackingStoreException;

public class RepositoryUtil {
    @Deprecated
    public static final String PREFS_DIRECTORIES = "GitRepositoriesView.GitDirectories";
    public static final String PREFS_DIRECTORIES_REL = "GitRepositoriesView.GitDirectories.relative";
    private final Map<String, Map<String, String>> commitMappingCache = new HashMap<String, Map<String, String>>();
    private final Map<String, String> repositoryNameCache = new HashMap<String, String>();
    private final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
    private final java.nio.file.Path workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toPath();

    RepositoryUtil() {
    }

    void dispose() {
        this.commitMappingCache.clear();
        this.repositoryNameCache.clear();
    }

    @NonNull
    public static String getDefaultRepositoryDir() {
        String result;
        String key = "core_defaultRepositoryDir";
        String dir = RepositoryUtil.migrateRepoRootPreference();
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
        if (dir == null) {
            dir = Platform.getPreferencesService().getString(Activator.getPluginId(), key, RepositoryUtil.getDefaultDefaultRepositoryDir(), null);
        } else {
            p.put(key, dir);
        }
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            result = manager.performStringSubstitution(dir);
        }
        catch (CoreException e) {
            result = "";
        }
        if (result == null || result.isEmpty()) {
            result = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toOSString();
        }
        return FileUtils.canonicalize((File)new File(result)).toString();
    }

    @NonNull
    static String getDefaultDefaultRepositoryDir() {
        return new File(FS.DETECTED.userHome(), "git").getPath();
    }

    @Nullable
    private static String migrateRepoRootPreference() {
        String deprecatedUiKey;
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode("org.eclipse.egit.ui");
        String value = p.get(deprecatedUiKey = "default_repository_dir", null);
        if (value != null && value.isEmpty()) {
            value = null;
        }
        if (value != null) {
            p.remove(deprecatedUiKey);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String mapCommitToRef(Repository repository, String commitId, boolean refresh) {
        Map<String, Map<String, String>> map = this.commitMappingCache;
        synchronized (map) {
            ObjectId objectId;
            TreeSet<String> branchNames;
            block44: {
                if (ObjectId.isId((String)commitId)) break block44;
                return null;
            }
            try {
                ReflogReader reflogReader = repository.getReflogReader("HEAD");
                if (reflogReader != null) {
                    List lastEntry = reflogReader.getReverseEntries();
                    for (Object entry : lastEntry) {
                        ObjectId id;
                        CheckoutEntry checkoutEntry;
                        if (!entry.getNewId().name().equals(commitId) || (checkoutEntry = entry.parseCheckout()) == null) continue;
                        Ref ref = repository.findRef(checkoutEntry.getToBranch());
                        if (ref != null) {
                            ObjectId objectId2 = ref.getObjectId();
                            if (objectId2 != null && objectId2.getName().equals(commitId)) {
                                return checkoutEntry.getToBranch();
                            }
                            ref = repository.peel(ref);
                        }
                        if (ref == null || (id = ref.getPeeledObjectId()) == null || !id.getName().equals(commitId)) continue;
                        return checkoutEntry.getToBranch();
                    }
                }
            }
            catch (IOException reflogReader) {
                // empty catch block
            }
            Map<String, String> cacheEntry = this.commitMappingCache.get(repository.getDirectory().toString());
            if (!refresh && cacheEntry != null && cacheEntry.containsKey(commitId)) {
                return cacheEntry.get(commitId);
            }
            if (cacheEntry == null) {
                cacheEntry = new HashMap<String, String>();
                this.commitMappingCache.put(repository.getDirectory().getPath(), cacheEntry);
            } else {
                cacheEntry.clear();
            }
            HashMap<String, Date> tagMap = new HashMap<String, Date>();
            try {
                Object entry;
                entry = null;
                Iterator iterator = null;
                try (RevWalk revWalk = new RevWalk(repository);){
                    List tags = repository.getRefDatabase().getRefsByPrefix("refs/tags/");
                    Iterator iterator2 = tags.iterator();
                    while (iterator2.hasNext()) {
                        RevCommit commit;
                        Ref tagRef = (Ref)iterator2.next();
                        RevObject any = revWalk.parseAny((AnyObjectId)repository.resolve(tagRef.getName()));
                        if (any instanceof RevTag) {
                            Date timestamp;
                            RevTag tag = (RevTag)any;
                            if (!tag.getObject().name().equals(commitId)) continue;
                            if (tag.getTaggerIdent() != null) {
                                timestamp = tag.getTaggerIdent().getWhen();
                            } else {
                                try {
                                    RevCommit commit2 = revWalk.parseCommit((AnyObjectId)tag.getObject());
                                    timestamp = commit2.getCommitterIdent().getWhen();
                                }
                                catch (IncorrectObjectTypeException e) {
                                    timestamp = null;
                                }
                            }
                            tagMap.put(tagRef.getName(), timestamp);
                            continue;
                        }
                        if (!(any instanceof RevCommit) || !(commit = (RevCommit)any).name().equals(commitId)) continue;
                        tagMap.put(tagRef.getName(), commit.getCommitterIdent().getWhen());
                    }
                }
                catch (Throwable throwable) {
                    if (entry == null) {
                        entry = throwable;
                    } else if (entry != throwable) {
                        ((Throwable)entry).addSuppressed(throwable);
                    }
                    throw entry;
                }
            }
            catch (IOException entry) {
                // empty catch block
            }
            String cacheValue = null;
            if (!tagMap.isEmpty()) {
                Date compareDate = new Date(0L);
                for (Map.Entry entry : tagMap.entrySet()) {
                    if (entry.getValue() == null || !((Date)entry.getValue()).after(compareDate)) continue;
                    compareDate = (Date)entry.getValue();
                    cacheValue = (String)entry.getKey();
                }
                if (cacheValue == null) {
                    String string = "";
                    for (String tagName : tagMap.keySet()) {
                        void var9_19;
                        if (tagName.compareTo((String)var9_19) < 0) continue;
                        cacheValue = tagName;
                        String string2 = tagName;
                    }
                }
            }
            if (cacheValue == null) {
                branchNames = new TreeSet<String>();
                try {
                    List list = repository.getRefDatabase().getRefsByPrefix("refs/heads/");
                    for (Ref branch : list) {
                        objectId = branch.getObjectId();
                        if (objectId == null || !objectId.name().equals(commitId)) continue;
                        branchNames.add(branch.getName());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!branchNames.isEmpty()) {
                    cacheValue = branchNames.toArray(new String[branchNames.size()])[branchNames.size() - 1];
                }
            }
            if (cacheValue == null) {
                branchNames = new TreeSet();
                try {
                    List list = repository.getRefDatabase().getRefsByPrefix("refs/remotes/");
                    for (Ref branch : list) {
                        objectId = branch.getObjectId();
                        if (objectId == null || !objectId.name().equals(commitId)) continue;
                        branchNames.add(branch.getName());
                    }
                    if (!branchNames.isEmpty()) {
                        cacheValue = branchNames.toArray(new String[branchNames.size()])[branchNames.size() - 1];
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            cacheEntry.put(commitId, cacheValue);
            return cacheValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepositoryName(Repository repository) {
        File dir = !repository.isBare() ? repository.getWorkTree() : repository.getDirectory();
        if (dir == null) {
            return "";
        }
        Map<String, String> map = this.repositoryNameCache;
        synchronized (map) {
            String path = dir.getPath();
            String name = this.repositoryNameCache.get(path);
            if (name != null) {
                return name;
            }
            name = dir.getName();
            this.repositoryNameCache.put(path, name);
            return name;
        }
    }

    public IEclipsePreferences getPreferences() {
        return this.prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Set<String> getRepositories() {
        Set<String> dirs;
        IEclipsePreferences iEclipsePreferences = this.prefs;
        synchronized (iEclipsePreferences) {
            String dirString = this.prefs.get(PREFS_DIRECTORIES_REL, "");
            dirs = dirString.equals("") ? this.migrateAbsolutePaths() : this.toDirSet(dirString);
        }
        return dirs;
    }

    private Set<String> migrateAbsolutePaths() {
        String dirString = this.prefs.get(PREFS_DIRECTORIES, "");
        Set<String> dirs = this.toDirSet(dirString);
        this.saveDirs(dirs);
        return dirs;
    }

    private Set<String> toDirSet(String dirs) {
        if (dirs == null || dirs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> configuredStrings = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(dirs, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            configuredStrings.add(this.workspacePath.resolve(tok.nextToken()).toString());
        }
        return configuredStrings;
    }

    public List<String> getConfiguredRepositories() {
        ArrayList<String> repos = new ArrayList<String>(this.getRepositories());
        Collections.sort(repos);
        return repos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConfiguredRepository(File repositoryDir) throws IllegalArgumentException {
        IEclipsePreferences iEclipsePreferences = this.prefs;
        synchronized (iEclipsePreferences) {
            List<String> dirStrings;
            String dirString;
            block5: {
                if (!RepositoryCache.FileKey.isGitRepository((File)repositoryDir, (FS)FS.DETECTED)) {
                    throw new IllegalArgumentException(MessageFormat.format(CoreText.RepositoryUtil_DirectoryIsNotGitDirectory, repositoryDir));
                }
                dirString = repositoryDir.getAbsolutePath();
                dirStrings = this.getConfiguredRepositories();
                if (!dirStrings.contains(dirString)) break block5;
                return false;
            }
            HashSet<String> dirs = new HashSet<String>();
            dirs.addAll(dirStrings);
            dirs.add(dirString);
            this.saveDirs(dirs);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDir(File file) {
        IEclipsePreferences iEclipsePreferences = this.prefs;
        synchronized (iEclipsePreferences) {
            block4: {
                String dirString = file.getAbsolutePath();
                HashSet<String> dirStrings = new HashSet<String>();
                dirStrings.addAll(this.getConfiguredRepositories());
                if (!dirStrings.remove(dirString)) break block4;
                this.saveDirs(dirStrings);
                return true;
            }
            return false;
        }
    }

    private void saveDirs(Set<String> gitDirStrings) {
        StringBuilder sbRelative = new StringBuilder();
        StringBuilder sbAbsolute = new StringBuilder();
        for (String gitDirString : gitDirStrings) {
            sbRelative.append(this.relativizeToWorkspace(gitDirString));
            sbRelative.append(File.pathSeparatorChar);
            sbAbsolute.append(gitDirString);
            sbAbsolute.append(File.pathSeparatorChar);
        }
        this.prefs.put(PREFS_DIRECTORIES, sbAbsolute.toString());
        this.prefs.put(PREFS_DIRECTORIES_REL, sbRelative.toString());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            Status error = new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)error);
        }
    }

    private String relativizeToWorkspace(String pathString) {
        java.nio.file.Path p = Paths.get(pathString, new String[0]);
        if (p.startsWith(this.workspacePath)) {
            return this.workspacePath.relativize(p).toString();
        }
        return pathString;
    }

    public boolean contains(Repository repository) {
        return this.contains(repository.getDirectory().getAbsolutePath());
    }

    public boolean contains(String repositoryDir) {
        return this.getRepositories().contains(repositoryDir);
    }

    public String getShortBranch(Repository repository) throws IOException {
        Ref head = repository.exactRef("HEAD");
        if (head == null) {
            return CoreText.RepositoryUtil_noHead;
        }
        if (head.isSymbolic()) {
            return repository.getBranch();
        }
        ObjectId objectId = head.getObjectId();
        if (objectId == null) {
            return CoreText.RepositoryUtil_noHead;
        }
        String id = objectId.name();
        String ref = this.mapCommitToRef(repository, id, false);
        if (ref != null) {
            return String.valueOf(Repository.shortenRefName((String)ref)) + ' ' + id.substring(0, 7);
        }
        return id.substring(0, 7);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RevCommit parseHeadCommit(Repository repository) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk walk = new RevWalk(repository);){
                Ref head = repository.exactRef("HEAD");
                if (head == null) return null;
                if (head.getObjectId() != null) RevCommit commit;
                return commit = walk.parseCommit((AnyObjectId)head.getObjectId());
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isIgnored(IPath path) throws IOException {
        mapping = RepositoryMapping.getMapping(path);
        if (mapping == null) {
            return true;
        }
        repository = mapping.getRepository();
        treeIterator = IteratorService.createInitialIterator(repository);
        if (treeIterator == null) {
            return true;
        }
        repoRelativePath = mapping.getRepoRelativePath(path);
        if (repoRelativePath == null || repoRelativePath.isEmpty()) {
            return true;
        }
        var5_5 = null;
        var6_7 = null;
        try {
            walk = new TreeWalk(repository);
            try {
                walk.addTree((AbstractTreeIterator)treeIterator);
                walk.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{repoRelativePath}));
                while (true) {
                    workingTreeIterator = (WorkingTreeIterator)walk.getTree(0, WorkingTreeIterator.class);
                    if (walk.getPathString().equals(repoRelativePath)) {
                        return workingTreeIterator.isEntryIgnored();
                    }
                    if (workingTreeIterator.getEntryFileMode().equals(FileMode.TREE)) {
                        walk.enterSubtree();
                    }
                    break;
                }
            }
            finally {
                if (walk.next()) ** continue;
            }
        }
        catch (Throwable var6_8) {
            if (var5_5 == null) {
                var5_5 = var6_8;
            } else if (var5_5 != var6_8) {
                var5_5.addSuppressed(var6_8);
            }
            throw var5_5;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canBeAutoIgnored(IPath path) throws IOException {
        repository = Activator.getDefault().getRepositoryCache().getRepository(path);
        if (repository == null) return false;
        if (repository.isBare()) {
            return false;
        }
        treeIterator = IteratorService.createInitialIterator(repository);
        if (treeIterator == null) {
            return false;
        }
        repoRelativePath = path.makeRelativeTo((IPath)new Path(repository.getWorkTree().getAbsolutePath())).toString();
        if (repoRelativePath.length() == 0) return false;
        if (repoRelativePath.equals(path.toString())) {
            return false;
        }
        var4_4 = null;
        var5_6 = null;
        try {
            walk = new TreeWalk(repository);
            try {
                walk.addTree((AbstractTreeIterator)treeIterator);
                walk.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{repoRelativePath}));
                while (true) {
                    workingTreeIterator = (WorkingTreeIterator)walk.getTree(0, WorkingTreeIterator.class);
                    if (walk.getPathString().equals(repoRelativePath)) {
                        if (workingTreeIterator.isEntryIgnored()) {
                            v0 = false;
                            return v0;
                        }
                        v0 = true;
                        return v0;
                    }
                    if (workingTreeIterator.getEntryFileMode().equals(FileMode.TREE)) {
                        walk.enterSubtree();
                    }
                    break;
                }
            }
            finally {
                if (walk.next()) ** continue;
                return false;
            }
        }
        catch (Throwable var5_7) {
            if (var4_4 == null) {
                var4_4 = var5_7;
                throw var4_4;
            }
            if (var4_4 == var5_7) throw var4_4;
            var4_4.addSuppressed(var5_7);
            throw var4_4;
        }
    }

    public static boolean isDetachedHead(Repository repository) {
        try {
            return ObjectId.isId((String)repository.getFullBranch());
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            return false;
        }
    }

    public static boolean hasChanges(@NonNull Repository repository) {
        IndexDiffData data;
        IndexDiffCacheEntry entry = Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repository);
        IndexDiffData indexDiffData = data = entry != null ? entry.getIndexDiff() : null;
        return data != null && data.hasChanges();
    }
}

