/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.file.LinkOption;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.DefaultClientIdentitiesWatcher;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientConnectionServiceFactory;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionCreator;
import org.apache.sshd.client.session.ClientUserAuthServiceFactory;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.client.simple.AbstractSimpleClientSessionCreator;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class SshClient
extends AbstractFactoryManager
implements ClientFactoryManager,
ClientSessionCreator,
Closeable {
    public static final Factory<SshClient> DEFAULT_SSH_CLIENT_FACTORY = SshClient::new;
    public static final List<NamedFactory<UserAuth>> DEFAULT_USER_AUTH_FACTORIES = Collections.unmodifiableList(Arrays.asList(UserAuthPublicKeyFactory.INSTANCE, UserAuthKeyboardInteractiveFactory.INSTANCE, UserAuthPasswordFactory.INSTANCE));
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ClientUserAuthServiceFactory.INSTANCE, ClientConnectionServiceFactory.INSTANCE));
    protected IoConnector connector;
    protected SessionFactory sessionFactory;
    protected UserInteraction userInteraction;
    protected List<NamedFactory<UserAuth>> userAuthFactories;
    private ClientProxyConnector proxyConnector;
    private ServerKeyVerifier serverKeyVerifier;
    private HostConfigEntryResolver hostConfigEntryResolver;
    private ClientIdentityLoader clientIdentityLoader;
    private FilePasswordProvider filePasswordProvider;
    private PasswordIdentityProvider passwordIdentityProvider;
    private final List<Object> identities = new CopyOnWriteArrayList<Object>();
    private final AuthenticationIdentitiesProvider identitiesProvider;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public SshClient() {
        this.identitiesProvider = AuthenticationIdentitiesProvider.wrapIdentities(this.identities);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ClientProxyConnector getClientProxyConnector() {
        return this.proxyConnector;
    }

    @Override
    public void setClientProxyConnector(ClientProxyConnector proxyConnector) {
        this.proxyConnector = proxyConnector;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.serverKeyVerifier;
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = Objects.requireNonNull(serverKeyVerifier, "No server key verifier");
    }

    @Override
    public HostConfigEntryResolver getHostConfigEntryResolver() {
        return this.hostConfigEntryResolver;
    }

    @Override
    public void setHostConfigEntryResolver(HostConfigEntryResolver resolver) {
        this.hostConfigEntryResolver = Objects.requireNonNull(resolver, "No host configuration entry resolver");
    }

    @Override
    public FilePasswordProvider getFilePasswordProvider() {
        return this.filePasswordProvider;
    }

    @Override
    public void setFilePasswordProvider(FilePasswordProvider provider) {
        this.filePasswordProvider = Objects.requireNonNull(provider, "No file password provider");
    }

    @Override
    public ClientIdentityLoader getClientIdentityLoader() {
        return this.clientIdentityLoader;
    }

    @Override
    public void setClientIdentityLoader(ClientIdentityLoader loader) {
        this.clientIdentityLoader = Objects.requireNonNull(loader, "No client identity loader");
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    @Override
    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = ValidateUtils.checkNotNullAndNotEmpty(userAuthFactories, "No user auth factories", new Object[0]);
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        return this.passwordIdentityProvider;
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider provider) {
        this.passwordIdentityProvider = provider;
    }

    @Override
    public void addPasswordIdentity(String password) {
        ValidateUtils.checkTrue(password != null && !password.isEmpty(), "No password provided");
        this.identities.add(password);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(password));
        }
    }

    @Override
    public String removePasswordIdentity(String password) {
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.PASSWORD_IDENTITY_COMPARATOR, password);
        if (index >= 0) {
            return (String)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair kp) {
        Objects.requireNonNull(kp, "No key-pair to add");
        Objects.requireNonNull(kp.getPublic(), "No public key");
        Objects.requireNonNull(kp.getPrivate(), "No private key");
        this.identities.add(kp);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPublicKeyIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(kp.getPublic()));
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.KEYPAIR_IDENTITY_COMPARATOR, kp);
        if (index >= 0) {
            return (KeyPair)this.identities.remove(index);
        }
        return null;
    }

    @Override
    protected void checkConfig() {
        SshAgentFactory agentFactory;
        super.checkConfig();
        Objects.requireNonNull(this.getForwarderFactory(), "ForwarderFactory not set");
        Objects.requireNonNull(this.getServerKeyVerifier(), "ServerKeyVerifier not set");
        Objects.requireNonNull(this.getHostConfigEntryResolver(), "HostConfigEntryResolver not set");
        Objects.requireNonNull(this.getClientIdentityLoader(), "ClientIdentityLoader not set");
        Objects.requireNonNull(this.getFilePasswordProvider(), "FilePasswordProvider not set");
        KeyPairProvider defaultIdentities = this.getKeyPairProvider();
        if (defaultIdentities == null) {
            this.setKeyPairProvider(new DefaultClientIdentitiesWatcher(this::getClientIdentityLoader, this::getFilePasswordProvider));
        }
        if ((agentFactory = this.getAgentFactory()) != null) {
            List<NamedFactory<Channel>> forwarders = ValidateUtils.checkNotNullAndNotEmpty(agentFactory.getChannelForwardingFactories(this), "No agent channel forwarding factories for %s", agentFactory);
            List<NamedFactory<Channel>> factories = this.getChannelFactories();
            if (GenericUtils.isEmpty(factories)) {
                factories = forwarders;
            } else {
                ArrayList<NamedFactory<Channel>> factories2 = new ArrayList<NamedFactory<Channel>>(factories.size() + forwarders.size());
                factories2.addAll(factories);
                factories2.addAll(forwarders);
                factories = factories2;
            }
            this.setChannelFactories(factories);
        }
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
        if (GenericUtils.isEmpty(this.getUserAuthFactories())) {
            this.setUserAuthFactories(DEFAULT_USER_AUTH_FACTORIES);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.setupSessionTimeout(this.sessionFactory);
        this.connector = this.createConnector();
        this.started.set(true);
    }

    public void stop() {
        block5: {
            if (!this.started.getAndSet(false)) {
                return;
            }
            try {
                long maxWait = this.getLongProperty("stop-wait-time", DEFAULT_STOP_WAIT_TIME);
                boolean successful = this.close(true).await(maxWait);
                if (!successful) {
                    throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
                }
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(e.getClass().getSimpleName() + " while stopping client: " + e.getMessage());
                }
                if (!this.log.isTraceEnabled()) break block5;
                this.log.trace("Stop exception details", (Throwable)e);
            }
        }
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        String closeId = this.toString();
        return this.builder().run(closeId, () -> this.removeSessionTimeout(this.sessionFactory)).sequential(this.connector, this.ioServiceFactory).run(closeId, () -> {
            this.connector = null;
            this.ioServiceFactory = null;
            if (this.shutdownExecutor && this.executor != null && !this.executor.isShutdown()) {
                try {
                    this.executor.shutdownNow();
                }
                finally {
                    this.executor = null;
                }
            }
        }).build();
    }

    @Override
    public ConnectFuture connect(String username, String host, int port) throws IOException {
        HostConfigEntryResolver resolver = this.getHostConfigEntryResolver();
        HostConfigEntry entry = resolver.resolveEffectiveHost(host, port, username);
        if (entry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}@{}:{}) no overrides", new Object[]{username, host, port});
            }
            entry = SshdSocketAddress.isIPv6Address(host) ? new HostConfigEntry("", host, port, username) : new HostConfigEntry(host, host, port, username);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("connect({}@{}:{}) effective: {}", new Object[]{username, host, port, entry});
        }
        return this.connect(entry);
    }

    @Override
    public ConnectFuture connect(String username, SocketAddress address) throws IOException {
        Objects.requireNonNull(address, "No target address");
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            String host = ValidateUtils.checkNotNullAndNotEmpty(inetAddress.getHostString(), "No host");
            int port = inetAddress.getPort();
            ValidateUtils.checkTrue(port > 0, "Invalid port: %d", port);
            HostConfigEntryResolver resolver = this.getHostConfigEntryResolver();
            HostConfigEntry entry = resolver.resolveEffectiveHost(host, port, username);
            if (entry == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("connect({}@{}:{}) no overrides", new Object[]{username, host, port});
                }
                return this.doConnect(username, address, Collections.emptyList(), true);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}@{}:{}) effective: {}", new Object[]{username, host, port, entry});
            }
            return this.connect(entry);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("connect({}@{}) not an InetSocketAddress: {}", new Object[]{username, address, address.getClass().getName()});
        }
        return this.doConnect(username, address, Collections.emptyList(), true);
    }

    @Override
    public ConnectFuture connect(HostConfigEntry hostConfig) throws IOException {
        Objects.requireNonNull(hostConfig, "No host configuration");
        String host = ValidateUtils.checkNotNullAndNotEmpty(hostConfig.getHostName(), "No target host");
        int port = hostConfig.getPort();
        ValidateUtils.checkTrue(port > 0, "Invalid port: %d", port);
        List<KeyPair> keys = this.loadClientIdentities(hostConfig.getIdentities(), IoUtils.EMPTY_LINK_OPTIONS);
        return this.doConnect(hostConfig.getUsername(), new InetSocketAddress(host, port), keys, !hostConfig.isIdentitiesOnly());
    }

    protected List<KeyPair> loadClientIdentities(Collection<String> locations, LinkOption ... options) throws IOException {
        if (GenericUtils.isEmpty(locations)) {
            return Collections.emptyList();
        }
        ArrayList<KeyPair> ids = new ArrayList<KeyPair>(locations.size());
        boolean ignoreNonExisting = this.getBooleanProperty("ignore-invalid-identities", true);
        ClientIdentityLoader loader = Objects.requireNonNull(this.getClientIdentityLoader(), "No ClientIdentityLoader");
        FilePasswordProvider provider = Objects.requireNonNull(this.getFilePasswordProvider(), "No FilePasswordProvider");
        boolean debugEnabled = this.log.isDebugEnabled();
        for (String l : locations) {
            if (!loader.isValidLocation(l)) {
                if (ignoreNonExisting) {
                    if (!debugEnabled) continue;
                    this.log.debug("loadClientIdentities - skip non-existing identity location: {}", (Object)l);
                    continue;
                }
                throw new FileNotFoundException("Invalid identity location: " + l);
            }
            try {
                KeyPair kp = loader.loadClientIdentity(l, provider);
                if (kp == null) {
                    throw new IOException("No identity loaded from " + l);
                }
                if (debugEnabled) {
                    this.log.debug("loadClientIdentities({}) type={}, fingerprint={}", new Object[]{l, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp.getPublic())});
                }
                ids.add(kp);
            }
            catch (GeneralSecurityException e) {
                throw new StreamCorruptedException("Failed (" + e.getClass().getSimpleName() + ") to load identity from " + l + ": " + e.getMessage());
            }
        }
        return ids;
    }

    protected ConnectFuture doConnect(String username, SocketAddress address, Collection<? extends KeyPair> identities, boolean useDefaultIdentities) throws IOException {
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        DefaultConnectFuture connectFuture = new DefaultConnectFuture(username + "@" + address, null);
        SshFutureListener<IoConnectFuture> listener = this.createConnectCompletionListener(connectFuture, username, address, identities, useDefaultIdentities);
        this.connector.connect(address).addListener(listener);
        return connectFuture;
    }

    protected SshFutureListener<IoConnectFuture> createConnectCompletionListener(final ConnectFuture connectFuture, final String username, final SocketAddress address, final Collection<? extends KeyPair> identities, final boolean useDefaultIdentities) {
        return new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                    return;
                }
                Throwable t = future.getException();
                if (t != null) {
                    if (SshClient.this.log.isDebugEnabled()) {
                        SshClient.this.log.debug("operationComplete({}@{}) failed ({}): {}", new Object[]{username, address, t.getClass().getSimpleName(), t.getMessage()});
                    }
                    connectFuture.setException(t);
                } else {
                    IoSession ioSession = future.getSession();
                    try {
                        SshClient.this.onConnectOperationComplete(ioSession, connectFuture, username, address, identities, useDefaultIdentities);
                    }
                    catch (RuntimeException e) {
                        SshClient.this.log.warn("operationComplete({}@{}) failed ({}) to signal completion of session={}: {}", new Object[]{username, address, e.getClass().getSimpleName(), ioSession, e.getMessage()});
                        if (SshClient.this.log.isDebugEnabled()) {
                            SshClient.this.log.debug("operationComplete(" + username + "@" + address + ") session=" + ioSession + " completion signal failure details", (Throwable)e);
                        }
                        connectFuture.setException(e);
                        ioSession.close(true);
                    }
                }
            }

            public String toString() {
                return "ConnectCompletionListener[" + username + "@" + address + "]";
            }
        };
    }

    protected void onConnectOperationComplete(IoSession ioSession, ConnectFuture connectFuture, String username, SocketAddress address, Collection<? extends KeyPair> identities, boolean useDefaultIdentities) {
        int numIds;
        AbstractClientSession session = (AbstractClientSession)AbstractSession.getSession(ioSession);
        session.setUsername(username);
        session.setConnectAddress(address);
        if (useDefaultIdentities) {
            this.setupDefaultSessionIdentities(session);
        }
        if ((numIds = GenericUtils.size(identities)) > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("onConnectOperationComplete({}) adding {} identities", (Object)session, (Object)numIds);
            }
            boolean traceEnabled = this.log.isTraceEnabled();
            for (KeyPair keyPair : identities) {
                if (traceEnabled) {
                    this.log.trace("onConnectOperationComplete({}) add identity type={}, fingerprint={}", new Object[]{session, KeyUtils.getKeyType(keyPair), KeyUtils.getFingerPrint(keyPair.getPublic())});
                }
                session.addPublicKeyIdentity(keyPair);
            }
        }
        connectFuture.setSession(session);
    }

    protected void setupDefaultSessionIdentities(ClientSession session) {
        KeyPairProvider kpSession = session.getKeyPairProvider();
        KeyPairProvider kpClient = this.getKeyPairProvider();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (kpSession == null) {
            session.setKeyPairProvider(kpClient);
        } else if (kpSession != kpClient && debugEnabled) {
            this.log.debug("setupDefaultSessionIdentities({}) key-pair provider override", (Object)session);
        }
        PasswordIdentityProvider passSession = session.getPasswordIdentityProvider();
        PasswordIdentityProvider passClient = this.getPasswordIdentityProvider();
        if (passSession == null) {
            session.setPasswordIdentityProvider(passClient);
        } else if (passSession != passClient && debugEnabled) {
            this.log.debug("setupDefaultSessionIdentities({}) password provider override", (Object)session);
        }
        AuthenticationIdentitiesProvider idsClient = this.getRegisteredIdentities();
        boolean traceEnabled = this.log.isTraceEnabled();
        Iterator<?> iter = GenericUtils.iteratorOf(idsClient == null ? null : idsClient.loadIdentities());
        while (iter.hasNext()) {
            Object id = iter.next();
            if (id instanceof String) {
                if (traceEnabled) {
                    this.log.trace("setupDefaultSessionIdentities({}) add password fingerprint={}", (Object)session, (Object)KeyUtils.getFingerPrint(id.toString()));
                }
                session.addPasswordIdentity((String)id);
                continue;
            }
            if (id instanceof KeyPair) {
                KeyPair kp = (KeyPair)id;
                if (traceEnabled) {
                    this.log.trace("setupDefaultSessionIdentities({}) add identity type={}, fingerprint={}", new Object[]{session, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp.getPublic())});
                }
                session.addPublicKeyIdentity(kp);
                continue;
            }
            if (!debugEnabled) continue;
            this.log.debug("setupDefaultSessionIdentities({}) ignored identity={}", (Object)session, id);
        }
    }

    protected IoConnector createConnector() {
        return this.getIoServiceFactory().createConnector(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return "SshClient[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SimpleClient setUpDefaultSimpleClient() {
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        return SshClient.wrapAsSimpleClient(client);
    }

    public static SimpleClient wrapAsSimpleClient(final SshClient client) {
        Objects.requireNonNull(client, "No client instance");
        java.nio.channels.Channel channel = new java.nio.channels.Channel(){

            @Override
            public boolean isOpen() {
                return client.isOpen();
            }

            @Override
            public void close() throws IOException {
                Exception err = null;
                try {
                    client.close();
                }
                catch (Exception e) {
                    err = GenericUtils.accumulateException(err, e);
                }
                try {
                    client.stop();
                }
                catch (Exception e) {
                    err = GenericUtils.accumulateException(err, e);
                }
                if (err != null) {
                    if (err instanceof IOException) {
                        throw (IOException)err;
                    }
                    throw new IOException(err);
                }
            }
        };
        return AbstractSimpleClientSessionCreator.wrap(client, channel);
    }

    public static SshClient setUpDefaultClient() {
        return (SshClient)ClientBuilder.builder().build();
    }
}

