/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.sections;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.editor.DSInputContext;
import org.eclipse.pde.internal.ds.ui.editor.DSLabelProvider;
import org.eclipse.pde.internal.ds.ui.editor.DSTypeSelectionExtension;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.editor.dialogs.DSEditProvideDialog;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DSProvideSection
extends TableSection
implements IDoubleClickListener {
    private TableViewer fProvidesTable;
    private Action fRemoveAction;
    private Action fAddAction;
    private Action fEditAction;

    public DSProvideSection(PDEFormPage page, Composite parent) {
        super(page, parent, 130, new String[]{Messages.DSProvideSection_add, Messages.DSProvideSection_remove, Messages.DSProvideSection_edit});
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setDescription(Messages.DSProvideSection_description);
        section.setExpanded(true);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(this.isEditable());
        this.createViewerPartControl(container, 65538, 2, toolkit);
        this.fProvidesTable = tablePart.getTableViewer();
        this.fProvidesTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fProvidesTable.setLabelProvider((IBaseLabelProvider)new DSLabelProvider());
        this.fProvidesTable.setComparator(new ViewerComparator());
        this.fProvidesTable.addDoubleClickListener((IDoubleClickListener)this);
        this.makeActions();
        IDSModel model = this.getDSModel();
        if (model != null) {
            this.fProvidesTable.setInput((Object)model);
            model.addModelChangedListener((IModelChangedListener)this);
        }
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.updateTitle();
    }

    public void dispose() {
        IDSModel model = this.getDSModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
    }

    public void refresh() {
        this.fProvidesTable.refresh();
        this.updateButtons();
        this.updateTitle();
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleEdit();
            }
        }
    }

    private void handleEdit() {
        int selectionIndex = this.fProvidesTable.getTable().getSelectionIndex();
        if (selectionIndex != -1) {
            DSEditProvideDialog dialog = new DSEditProvideDialog(Activator.getActiveWorkbenchShell(), (IDSProvide)this.fProvidesTable.getElementAt(selectionIndex), this);
            dialog.create();
            dialog.getShell().setSize(500, 200);
            dialog.open();
        }
    }

    private void makeActions() {
        this.fAddAction = new Action(Messages.DSProvideSection_add){

            public void run() {
                DSProvideSection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(Messages.DSProvideSection_remove){

            public void run() {
                DSProvideSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
        this.fEditAction = new Action(Messages.DSProvideSection_edit){

            public void run() {
                DSProvideSection.this.handleRemove();
            }
        };
        this.fEditAction.setEnabled(this.isEditable());
    }

    private void updateButtons() {
        Table table = this.fProvidesTable.getTable();
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable() && table.getSelection().length > 0);
        tablePart.setButtonEnabled(2, this.isEditable() && table.getSelection().length == 1);
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fProvidesTable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            Iterator iter = ssel.iterator();
            IDSService service = this.getDSModel().getDSComponent().getService();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof IDSProvide)) continue;
                service.removeProvidedService((IDSProvide)object);
            }
            if (service.getProvidedServices().length == 0) {
                this.getDSModel().getDSComponent().removeService(service);
            }
        }
    }

    private void handleAdd() {
        this.doOpenSelectionDialog(512);
    }

    private void doOpenSelectionDialog(int scopeType) {
        try {
            String filter = "";
            filter = filter.substring(filter.lastIndexOf(".") + 1);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Activator.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)true, (String)filter, (TypeSelectionExtension)new DSTypeSelectionExtension(this.getDSModel()));
            dialog.setTitle(Messages.DSProvideDetails_selectType);
            if (dialog.open() == 0) {
                Object[] result;
                Object[] objectArray = result = dialog.getResult();
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    IType type = (IType)element;
                    String fullyQualifiedName = type.getFullyQualifiedName('$');
                    this.addProvide(fullyQualifiedName);
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void addProvide(String fullyQualifiedName) {
        IDSDocumentFactory factory = this.getDSModel().getFactory();
        IDSComponent component = this.getDSModel().getDSComponent();
        IDSService service = component.getService();
        if (service == null) {
            service = factory.createService();
            component.setService(service);
        }
        IDSProvide provide = factory.createProvide();
        provide.setInterface(fullyQualifiedName);
        service.addProvidedService(provide);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        } else if (e.getChangeType() == 2) {
            Object[] objects;
            Object[] objectArray = objects = e.getChangedObjects();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Table table = this.fProvidesTable.getTable();
                if (object instanceof IDSProvide) {
                    int index = table.getSelectionIndex();
                    this.fProvidesTable.remove(object);
                    if (this.canSelect()) {
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                    }
                }
                ++n2;
            }
            this.updateButtons();
            this.updateTitle();
        } else if (e.getChangeType() == 1) {
            Object[] objects = e.getChangedObjects();
            if (objects.length > 0) {
                this.fProvidesTable.refresh();
                this.fProvidesTable.setSelection((ISelection)new StructuredSelection(objects[objects.length - 1]));
            }
            this.updateButtons();
            this.updateTitle();
        } else {
            this.fProvidesTable.refresh();
            this.updateButtons();
        }
    }

    private DSInputContext getDSContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (DSInputContext)manager.findContext("ds-context");
    }

    private IDSModel getDSModel() {
        DSInputContext context = this.getDSContext();
        return context == null ? null : (IDSModel)context.getModel();
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    private void updateTitle() {
        int itemCount = this.fProvidesTable.getTable().getItemCount();
        this.getSection().setText(NLS.bind((String)Messages.DSProvideSection_title, (Object)itemCount));
    }

    public void doubleClick(DoubleClickEvent event) {
        IDSProvide provide = (IDSProvide)this.fProvidesTable.getStructuredSelection().getFirstElement();
        String value = provide.getInterface();
        IProject project = this.getProject();
        try {
            IJavaProject javaProject;
            IType element;
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature") && (element = (javaProject = JavaCore.create((IProject)project)).findType(value.replace('$', '.'))) != null) {
                JavaUI.openInEditor((IJavaElement)element);
            }
        }
        catch (PartInitException e) {
            Activator.logException(e);
        }
        catch (CoreException e) {
            Activator.logException(e);
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDSService service;
            IDSModel model;
            IDSComponent component;
            if (inputElement instanceof IDSModel && (component = (model = (IDSModel)inputElement).getDSComponent()) != null && (service = component.getService()) != null) {
                return service.getProvidedServices();
            }
            return new Object[0];
        }
    }
}

