/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;

public class Requirement
implements IRequirement,
IMemberProvider {
    public static final String MEMBER_FILTER = "filter";
    public static final String MEMBER_MIN = "min";
    public static final String MEMBER_MAX = "max";
    public static final String MEMBER_GREEDY = "greedy";
    public static final String MEMBER_MATCH = "match";
    protected final IMatchExpression<IInstallableUnit> filter;
    protected final IMatchExpression<IInstallableUnit> matchExpression;
    protected final boolean greedy;
    protected final int min;
    protected final int max;
    protected final String description;

    public Requirement(IMatchExpression<IInstallableUnit> requirement, IMatchExpression<IInstallableUnit> filter, int min, int max, boolean greedy, String description) {
        this.matchExpression = requirement;
        this.filter = filter;
        this.min = min;
        this.max = max;
        this.greedy = greedy;
        this.description = description;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.matchExpression);
        Object[] params = this.matchExpression.getParameters();
        if (params.length > 0) {
            result.append(" (");
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(params[i]);
                ++i;
            }
            result.append(')');
        }
        return result.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + this.matchExpression.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IRequirement)) {
            return false;
        }
        IRequirement other = (IRequirement)obj;
        if (this.filter == null ? other.getFilter() != null : !this.filter.equals(other.getFilter())) {
            return false;
        }
        return this.min == other.getMin() && this.max == other.getMax() && this.greedy == other.isGreedy() && this.matchExpression.equals(other.getMatches());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public boolean isGreedy() {
        return this.greedy;
    }

    @Override
    public IMatchExpression<IInstallableUnit> getFilter() {
        return this.filter;
    }

    @Override
    public IMatchExpression<IInstallableUnit> getMatches() {
        return this.matchExpression;
    }

    @Override
    public boolean isMatch(IInstallableUnit candidate) {
        return this.matchExpression.isMatch(candidate);
    }

    @Override
    public Object getMember(String memberName) {
        switch (memberName) {
            case "filter": {
                return this.filter;
            }
            case "min": {
                return this.min;
            }
            case "max": {
                return this.max;
            }
            case "greedy": {
                return this.greedy;
            }
            case "match": {
                return this.matchExpression;
            }
        }
        throw new IllegalArgumentException("No such member: " + memberName);
    }
}

