/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.util.RepositoryPathChecker;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateRepositoryPage
extends WizardPage {
    private final boolean hideBare;
    private Text directoryText;
    private Text defaultBranchText;
    private Button bareButton;

    public CreateRepositoryPage(boolean hideBareOption) {
        super(CreateRepositoryPage.class.getName());
        this.hideBare = hideBareOption;
        this.setTitle(UIText.CreateRepositoryPage_PageTitle);
        this.setMessage(UIText.CreateRepositoryPage_PageMessage);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        String defaultBranch;
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        Label directoryLabel = new Label(main, 0);
        directoryLabel.setText(UIText.CreateRepositoryPage_DirectoryLabel);
        this.directoryText = new Text(main, 2048);
        String initialDirectory = RepositoryUtil.getDefaultRepositoryDir();
        int cursorPosition = initialDirectory.length();
        if (!initialDirectory.isEmpty()) {
            initialDirectory = String.valueOf(RepositoryUtil.getDefaultRepositoryDir()) + File.separatorChar + UIText.CreateRepositoryPage_DefaultRepositoryName;
            int repoCounter = 2;
            while (Paths.get(initialDirectory, new String[0]).toFile().exists()) {
                initialDirectory = String.valueOf(RepositoryUtil.getDefaultRepositoryDir()) + File.separatorChar + UIText.CreateRepositoryPage_DefaultRepositoryName + repoCounter++;
            }
            ++cursorPosition;
        }
        this.directoryText.setText(initialDirectory);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.directoryText);
        Button browseButton = new Button(main, 8);
        browseButton.setText(UIText.CreateRepositoryPage_BrowseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result;
                String previous = CreateRepositoryPage.this.directoryText.getText();
                File previousFile = new File(previous);
                DirectoryDialog dialog = new DirectoryDialog(CreateRepositoryPage.this.getShell());
                dialog.setMessage(UIText.CreateRepositoryPage_PageMessage);
                if (previousFile.exists() && previousFile.isDirectory()) {
                    dialog.setFilterPath(previousFile.getPath());
                }
                if ((result = dialog.open()) != null) {
                    CreateRepositoryPage.this.directoryText.setText(result);
                }
            }
        });
        Label defaultBranchLabel = new Label(main, 0);
        defaultBranchLabel.setText(UIText.CreateRepositoryPage_DefaultBranchLabel);
        this.defaultBranchText = new Text(main, 2048);
        try {
            defaultBranch = RepositoryUtil.getDefaultBranchName();
            if (StringUtils.isEmptyOrNull((String)defaultBranch)) {
                defaultBranch = "master";
            }
        }
        catch (IOException | ConfigInvalidException e) {
            defaultBranch = "master";
            Activator.handleError(UIText.CreateRepositoryPage_ReadDefaultBranchFailed, e, true);
        }
        this.defaultBranchText.setText(defaultBranch);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.defaultBranchText);
        this.defaultBranchText.addModifyListener(event -> this.checkPage());
        if (!this.hideBare) {
            this.bareButton = new Button(main, 32);
            this.bareButton.setText(UIText.CreateRepositoryPage_BareCheckbox);
            GridDataFactory.fillDefaults().indent(10, 0).span(3, 1).applyTo((Control)this.bareButton);
            this.bareButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CreateRepositoryPage.this.checkPage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    CreateRepositoryPage.this.checkPage();
                }
            });
        }
        this.directoryText.addModifyListener(event -> this.checkPage());
        this.setControl((Control)main);
        this.directoryText.setFocus();
        this.directoryText.setSelection(cursorPosition, this.directoryText.getText().length());
        if (!this.directoryText.getText().isEmpty()) {
            this.checkPage();
        }
    }

    public String getDirectory() {
        Path path = new Path(this.directoryText.getText().trim());
        return path.toOSString();
    }

    public String getDefaultBranch() {
        return this.defaultBranchText.getText().trim();
    }

    public boolean getBare() {
        return this.bareButton != null && this.bareButton.getSelection();
    }

    /*
     * Unable to fully structure code
     */
    void checkPage() {
        block9: {
            block8: {
                block7: {
                    block6: {
                        this.setErrorMessage(null);
                        try {
                            dir = this.directoryText.getText().trim();
                            if (dir.length() != 0) break block6;
                            this.setErrorMessage(UIText.CreateRepositoryPage_PleaseSelectDirectoryMessage);
                        }
                        catch (Throwable var4_4) {
                            this.setPageComplete(this.getErrorMessage() == null);
                            throw var4_4;
                        }
                        this.setPageComplete(this.getErrorMessage() == null);
                        return;
                    }
                    checker = new RepositoryPathChecker();
                    if (checker.check(dir)) break block7;
                    this.setErrorMessage(checker.getErrorMessage());
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                if (!checker.hasContent()) ** GOTO lbl29
                if (!this.getBare()) break block8;
                this.setErrorMessage(NLS.bind((String)UIText.CreateRepositoryPage_NotEmptyMessage, (Object)dir));
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            this.setMessage(NLS.bind((String)UIText.CreateRepositoryPage_NotEmptyMessage, (Object)dir), 1);
            break block9;
lbl29:
            // 1 sources

            this.setMessage(UIText.CreateRepositoryPage_PageMessage);
        }
        defaultBranch = this.getDefaultBranch();
        if (!Repository.isValidRefName((String)("refs/heads/" + defaultBranch))) {
            this.setErrorMessage(MessageFormat.format(UIText.CreateRepositoryPage_InvalidBranchName, new Object[]{defaultBranch}));
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

