/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.workbench.ui.views;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.scenario.FileEditor;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ScenarioFactory;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.core.scenario.WorkbenchContext;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ctx.workbench.ui.views.SelectEditorFileDialog;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.ui.commons.ArrayTransfer;
import org.eclipse.rcptt.ui.commons.EObjectTable;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditorsTable
extends EObjectTable {
    private Button closeEditorsButton;
    private static EditorsTransfer TRANSFER = null;

    public EditorsTable(WorkbenchContext context) {
        super((EObject)context, (EStructuralFeature)ScenarioPackage.Literals.WORKBENCH_CONTEXT__EDITORS);
    }

    public String getName() {
        return "Editors";
    }

    public Image getImage() {
        return null;
    }

    public void createControl(Composite parent) {
        this.closeEditorsButton = new Button(parent, 32);
        this.closeEditorsButton.setText("Close opened editors");
        this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.closeEditorsButton), EMFObservables.observeValue((EObject)this.getContent(), (EStructuralFeature)ScenarioPackage.eINSTANCE.getWorkbenchContext_CloseEditors()));
        super.createControl(parent);
    }

    public WorkbenchContext getContent() {
        return (WorkbenchContext)this.content;
    }

    protected ILabelProvider createLabelProvider() {
        return new EditorsLabelProvider();
    }

    protected Object[] handleAdd() {
        EList content = this.getContents();
        SelectEditorFileDialog dialog = new SelectEditorFileDialog(this.viewer.getControl().getShell(), RcpttCore.create((IProject)Q7Utils.getLocation((NamedElement)this.getContent()).getProject()), (List<Object>)content);
        if (dialog.open() == 0) {
            FileEditor editor = ScenarioFactory.eINSTANCE.createFileEditor();
            editor.setPath(dialog.getPath());
            return new FileEditor[]{editor};
        }
        return null;
    }

    protected Class<?> getContentsType() {
        return FileEditor.class;
    }

    protected Transfer getContentTransfer() {
        if (TRANSFER == null) {
            TRANSFER = new EditorsTransfer();
        }
        return TRANSFER;
    }

    public String getContentName(Object content) {
        return ((FileEditor)content).getPath();
    }

    public void setCloseEditorsControlEnabled(boolean enabled) {
        if (this.closeEditorsButton != null && !this.closeEditorsButton.isDisposed()) {
            this.closeEditorsButton.setEnabled(enabled);
        }
    }

    protected IQ7Element.HandleType getAppropriateHandleType() {
        return null;
    }

    private static class EditorsLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private EditorsLabelProvider() {
        }

        public Image getImage(Object element) {
            return Images.getImage((String)"icons/file.gif");
        }

        public String getText(Object element) {
            FileEditor editor = (FileEditor)element;
            return editor.getPath();
        }
    }

    private class EditorsTransfer
    extends ArrayTransfer {
        private final String TYPE_NAME = "org.eclipse.rcptt.core.scenario.FileEditor";
        private final int TYPE_ID = EditorsTransfer.registerType((String)"org.eclipse.rcptt.core.scenario.FileEditor");

        private EditorsTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{this.TYPE_ID};
        }

        protected String[] getTypeNames() {
            return new String[]{"org.eclipse.rcptt.core.scenario.FileEditor"};
        }

        public void javaToNative(Object object, TransferData transferData) {
            Object[] editors = (Object[])object;
            String[] paths = new String[editors.length];
            int i = 0;
            while (i < editors.length) {
                paths[i] = ((FileEditor)editors[i]).getPath();
                ++i;
            }
            super.javaToNative((Object)paths, transferData);
        }

        public Object nativeToJava(TransferData transferData) {
            Object[] paths = (Object[])super.nativeToJava(transferData);
            FileEditor[] editors = new FileEditor[paths.length];
            int i = 0;
            while (i < paths.length) {
                editors[i] = ScenarioFactory.eINSTANCE.createFileEditor();
                editors[i].setPath((String)paths[i]);
                ++i;
            }
            return editors;
        }
    }
}

