/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.signing;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Date;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.signing.ExternalGpg;
import org.eclipse.egit.core.internal.signing.ExternalProcessRunner;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.lib.AbstractGpgSignatureVerifier;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgSignatureVerifier;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

public class ExternalGpgSignatureVerifier
extends AbstractGpgSignatureVerifier {
    public GpgSignatureVerifier.SignatureVerification verify(byte[] data, byte[] signatureData) throws IOException {
        throw new UnsupportedOperationException("Call verify(GpgConfig, byte[], byte[]) instead.");
    }

    public GpgSignatureVerifier.SignatureVerification verify(@NonNull GpgConfig config, byte[] data, byte[] signatureData) throws IOException {
        String program = config.getProgram();
        if (StringUtils.isEmptyOrNull((String)program) && StringUtils.isEmptyOrNull((String)(program = ExternalGpg.getGpg()))) {
            throw new IOException(CoreText.ExternalGpgSigner_gpgNotFound);
        }
        File signatureFile = null;
        GpgSignatureVerifier.SignatureVerification[] verification = new GpgSignatureVerifier.SignatureVerification[1];
        try {
            signatureFile = File.createTempFile("egit", ".sig");
            Files.write(signatureFile.toPath(), signatureData, new OpenOption[0]);
            ProcessBuilder process = new ProcessBuilder(new String[0]);
            process.command(program, "--status-fd", "1", "--verify", signatureFile.getAbsolutePath(), "-");
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (ByteArrayInputStream dataIn = new ByteArrayInputStream(data);){
                    ExternalProcessRunner.run(process, dataIn, b -> {
                        signatureVerificationArray[0] = this.fromGpg(b);
                    }, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CanceledException canceledException) {}
        }
        finally {
            if (signatureFile != null && !signatureFile.delete()) {
                signatureFile.deleteOnExit();
            }
        }
        return verification[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GpgSignatureVerifier.SignatureVerification fromGpg(TemporaryBuffer buffer) {
        Date createdAt = Date.from(Instant.EPOCH);
        GpgSignatureVerifier.TrustLevel trust = GpgSignatureVerifier.TrustLevel.UNKNOWN;
        String fingerprint = null;
        boolean validates = false;
        boolean expired = false;
        String message = null;
        String keyId = null;
        String userId = null;
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (BufferedReader r = new BufferedReader(new InputStreamReader(buffer.openInputStream(), StandardCharsets.UTF_8));){
                String line;
                block27: while ((line = r.readLine()) != null) {
                    if (!line.startsWith("[GNUPG:]")) continue;
                    if ((line = line.substring(8).trim()).startsWith("TRUST_")) {
                        int i = line.indexOf(32);
                        if (i < 0) {
                            i = line.length();
                        }
                        String level = line.substring(6, i);
                        try {
                            trust = GpgSignatureVerifier.TrustLevel.valueOf((String)level);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        continue;
                    }
                    if (line.startsWith("SIG_ID")) {
                        String[] parts = line.split(" ");
                        if (parts.length <= 3) continue;
                        try {
                            createdAt = Date.from(Instant.ofEpochSecond(Long.parseLong(parts[3].trim())));
                        }
                        catch (NumberFormatException level) {}
                        continue;
                    }
                    if (line.startsWith("VALIDSIG")) {
                        int i = line.indexOf(32);
                        int j = -1;
                        if (i > 0) {
                            j = line.indexOf(32, i + 1);
                        }
                        if (j <= i) continue;
                        fingerprint = line.substring(i + 1, j);
                        continue;
                    }
                    int i = line.indexOf(32);
                    if (i < 0) {
                        i = line.length();
                    }
                    String key = line.substring(0, i);
                    boolean haveUserId = true;
                    switch (key) {
                        case "ERRSIG": {
                            haveUserId = false;
                            message = CoreText.ExternalGpgVerifier_erroneousSignature;
                            break;
                        }
                        case "GOODSIG": {
                            validates = true;
                            break;
                        }
                        case "BADSIG": {
                            message = CoreText.ExternalGpgVerifier_badSignature;
                            break;
                        }
                        case "EXPSIG": {
                            expired = true;
                            message = CoreText.ExternalGpgVerifier_expiredSignature;
                            break;
                        }
                        case "EXPKEYSIG": {
                            expired = true;
                            message = CoreText.ExternalGpgVerifier_expiredKeySignature;
                            break;
                        }
                        case "REVKEYSIG": {
                            message = CoreText.ExternalGpgVerifier_revokedKeySignature;
                            break;
                        }
                        default: {
                            continue block27;
                        }
                    }
                    if (keyId != null) {
                        validates = false;
                        message = CoreText.ExternalGpgVerifier_multipleSignatures;
                        break;
                    }
                    int j = line.indexOf(32, i + 1);
                    if (j <= i) {
                        j = line.length();
                    }
                    keyId = line.substring(i + 1, j);
                    if (haveUserId && j < line.length()) {
                        userId = line.substring(j + 1);
                    }
                    if (message == null) continue;
                    message = MessageFormat.format(message, keyId, userId);
                }
                if (!StringUtils.isEmptyOrNull(fingerprint)) return new VerificationResult(createdAt, userId, fingerprint, userId, validates, expired, trust, message);
                fingerprint = keyId;
                return new VerificationResult(createdAt, userId, fingerprint, userId, validates, expired, trust, message);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            message = MessageFormat.format(CoreText.ExternalGpgVerifier_failure, e.getLocalizedMessage());
            return new VerificationResult(createdAt, userId, fingerprint, userId, false, expired, trust, message);
        }
    }

    public String getName() {
        return "gpg";
    }

    public void clear() {
    }

    private static class VerificationResult
    implements GpgSignatureVerifier.SignatureVerification {
        private final Date creationDate;
        private final String signer;
        private final String keyUser;
        private final String fingerprint;
        private final boolean verified;
        private final boolean expired;
        @NonNull
        private final GpgSignatureVerifier.TrustLevel trustLevel;
        private final String message;

        public VerificationResult(Date creationDate, String signer, String fingerprint, String user, boolean verified, boolean expired, @NonNull GpgSignatureVerifier.TrustLevel trust, String message) {
            this.creationDate = creationDate;
            this.signer = signer;
            this.fingerprint = fingerprint;
            this.keyUser = user;
            this.verified = verified;
            this.expired = expired;
            this.trustLevel = trust;
            this.message = message;
        }

        public Date getCreationDate() {
            return this.creationDate;
        }

        public String getSigner() {
            return this.signer;
        }

        public String getKeyUser() {
            return this.keyUser;
        }

        public String getKeyFingerprint() {
            return this.fingerprint;
        }

        public boolean isExpired() {
            return this.expired;
        }

        public GpgSignatureVerifier.TrustLevel getTrustLevel() {
            return this.trustLevel;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean getVerified() {
            return this.verified;
        }
    }
}

