/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.internal.hosts.GitHosts;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.components.AsynchronousListOperation;
import org.eclipse.egit.ui.internal.dialogs.CancelableFuture;
import org.eclipse.egit.ui.internal.fetch.AbstractFetchFromHostPage;
import org.eclipse.egit.ui.internal.fetch.GitServer;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;

public class FetchChangeFromServerPage
extends AbstractFetchFromHostPage {
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private static final String WILDCARD = ".*";
    private final GitServer server;

    public FetchChangeFromServerPage(GitServer server, Repository repository, String initialText) {
        super(repository, initialText, server.getChangeLabel(), server.getChangeNameSingular(), server.getChangeNamePlural(), false);
        this.server = server;
    }

    @Override
    protected String getSettingsKey() {
        return String.valueOf('.') + this.server.getType().getId();
    }

    @Override
    Set<String> determineUris(Repository repo, String defaultUri) {
        HashSet<String> uris = new HashSet<String>();
        try {
            GitHosts.getServerConfigs((Config)repo.getConfig(), (GitHosts.ServerType)this.server.getType()).forEach(rc -> {
                uris.add(((URIish)rc.getURIs().get(0)).toPrivateString());
                for (URIish u : rc.getPushURIs()) {
                    if (!this.server.getType().uriMatches(u.toPrivateString())) continue;
                    uris.add(u.toPrivateString());
                }
            });
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, false);
            this.setErrorMessage(e.getMessage());
            return Collections.emptySet();
        }
        return uris;
    }

    ChangeList createChangeList(Repository repo, String uri) {
        return new ChangeList(repo, uri, this::changeFromRef);
    }

    @Override
    AbstractFetchFromHostPage.Change changeFromRef(String refName) {
        long changeId = this.server.getType().fromRef(refName);
        if (changeId < 0L) {
            return null;
        }
        return new PullRequest(changeId, this.server);
    }

    @Override
    AbstractFetchFromHostPage.Change changeFromString(String input) {
        long changeId = this.server.getType().fromString(input);
        if (changeId < 0L) {
            return null;
        }
        return new PullRequest(changeId, this.server);
    }

    @Override
    AbstractFetchFromHostPage.Defaults getDefaults(String initialText) {
        if (initialText == null) {
            return null;
        }
        return new AbstractFetchFromHostPage.Defaults(null, null, this.changeFromString(initialText.trim()));
    }

    @Override
    Pattern getProposalPattern(String input) {
        AbstractFetchFromHostPage.Change change = this.changeFromString(input);
        long changeNumber = -1L;
        try {
            if (change == null) {
                Matcher matcher = DIGITS.matcher(input);
                if (matcher.find()) {
                    return Pattern.compile(String.valueOf(this.server.getType().getRefPrefix()) + matcher.group() + WILDCARD);
                }
            } else {
                changeNumber = change.getChangeNumber();
            }
            if (changeNumber > 0L) {
                return Pattern.compile(String.valueOf(this.server.getType().getRefPrefix()) + changeNumber + WILDCARD);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return UIUtils.createProposalPattern(input);
    }

    private static class ChangeList
    extends AsynchronousListOperation<AbstractFetchFromHostPage.Change> {
        private final Function<String, ? extends AbstractFetchFromHostPage.Change> fromRef;

        public ChangeList(Repository repository, String uriText, Function<String, ? extends AbstractFetchFromHostPage.Change> fromRef) {
            super(repository, uriText);
            this.fromRef = fromRef;
        }

        @Override
        protected Collection<AbstractFetchFromHostPage.Change> convert(Collection<Ref> refs) {
            ArrayList<AbstractFetchFromHostPage.Change> changes = new ArrayList<AbstractFetchFromHostPage.Change>();
            for (Ref ref : refs) {
                AbstractFetchFromHostPage.Change change = this.fromRef.apply(ref.getName());
                if (change == null) continue;
                changes.add(change);
            }
            Collections.sort(changes, Collections.reverseOrder());
            return new LinkedHashSet<AbstractFetchFromHostPage.Change>(changes);
        }
    }

    private static class PullRequest
    implements AbstractFetchFromHostPage.Change {
        private final long prNumber;
        private final GitServer server;

        public PullRequest(long prNumber, GitServer server) {
            this.prNumber = prNumber;
            this.server = server;
        }

        @Override
        public String getRefName() {
            return this.toString();
        }

        @Override
        public long getChangeNumber() {
            return this.prNumber;
        }

        public String toString() {
            return this.server.getType().toFetchRef(this.prNumber);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AbstractFetchFromHostPage.Change)) {
                return false;
            }
            return this.compareTo((AbstractFetchFromHostPage.Change)obj) == 0;
        }

        public int hashCode() {
            return Long.hashCode(this.prNumber);
        }

        @Override
        public int compareTo(AbstractFetchFromHostPage.Change o) {
            return Long.compare(this.prNumber, o.getChangeNumber());
        }

        @Override
        public IContentProposal getProposal() {
            String label = MessageFormat.format(this.server.getProposalLabel(), Long.toString(this.getChangeNumber()));
            return new ContentProposal(this.getRefName(), label, null, 0);
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public AbstractFetchFromHostPage.Change complete(CancelableFuture<Collection<AbstractFetchFromHostPage.Change>> list, String uri, IProgressMonitor monitor) {
            return this;
        }

        @Override
        public AbstractFetchFromHostPage.Change complete(Collection<AbstractFetchFromHostPage.Change> changes) {
            return null;
        }

        @Override
        public String getBranchSuggestion() {
            return MessageFormat.format(this.server.getBranchName(), Long.toString(this.getChangeNumber()));
        }

        @Override
        public String completeId() {
            return Long.toString(this.getChangeNumber());
        }
    }
}

