/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.AbstractGitCloneWizard;
import org.eclipse.egit.ui.internal.clone.CloneDestinationPage;
import org.eclipse.egit.ui.internal.clone.GitCloneSourceProviderExtension;
import org.eclipse.egit.ui.internal.clone.GitSelectRepositoryPage;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportRootWizardPage;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportWizard;

public class SmartImportGitWizard
extends AbstractGitCloneWizard
implements IImportWizard,
IPageChangedListener {
    private SmartImportWizard smartImportWizard;
    private GitSelectRepositoryPage selectRepoPage = new GitSelectRepositoryPage(false);

    public SmartImportGitWizard() {
        IDialogSettings dialogSettings = super.getDialogSettings();
        if (dialogSettings == null) {
            dialogSettings = Activator.getDefault().getDialogSettings();
            this.setDialogSettings(dialogSettings);
        }
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.smartImportWizard = new SmartImportWizard();
        this.setWindowTitle(UIText.GitImportWizard_WizardTitle);
    }

    @Override
    protected void addPreClonePages() {
        if (!this.hasSearchResult()) {
            this.addPage((IWizardPage)this.selectRepoPage);
        }
    }

    @Override
    protected void addPostClonePages() {
        this.smartImportWizard.addPages();
    }

    public boolean performFinish() {
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().getWizard() == this.smartImportWizard && this.smartImportWizard.canFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    @Override
    protected List<GitCloneSourceProviderExtension.CloneSourceProvider> getCloneSourceProviders() {
        List<GitCloneSourceProviderExtension.CloneSourceProvider> cloneSourceProvider = super.getCloneSourceProviders();
        cloneSourceProvider.add(0, GitCloneSourceProviderExtension.CloneSourceProvider.LOCAL);
        return cloneSourceProvider;
    }

    public CloneDestinationPage getCloneDestinationPage() {
        return this.cloneDestination;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectRepoPage || page == this.cloneDestination) {
            return this.smartImportWizard.getPages()[0];
        }
        return super.getNextPage(page);
    }

    public boolean needsClone() {
        return this.cloneDestination.cloneSettingsChanged();
    }

    private boolean needToCloneRepository() {
        return this.cloneDestination.cloneSettingsChanged();
    }

    private File doClone(SmartImportRootWizardPage importRootPage) {
        this.setCallerRunsCloneOperation(true);
        try {
            GitRepositoryInfo repositoryInfo = this.currentSearchResult.getGitRepositoryInfo();
            this.performClone(repositoryInfo);
            this.getContainer().getShell().getDisplay().asyncExec(() -> {
                this.runCloneOperation(this.getContainer(), repositoryInfo);
                this.cloneDestination.saveSettingsForClonedRepo();
                importRootPage.setInitialImportRoot(this.getCloneDestinationPage().getDestinationFile());
            });
        }
        catch (URISyntaxException e) {
            Activator.error(UIText.GitImportWizard_errorParsingURI, e);
        }
        catch (NoRepositoryInfoException e) {
            Activator.error(UIText.GitImportWizard_noRepositoryInfo, e);
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
        return this.getCloneDestinationPage().getDestinationFile();
    }

    public void pageChanged(PageChangedEvent event) {
        SmartImportRootWizardPage selectRootPage = (SmartImportRootWizardPage)this.smartImportWizard.getPages()[0];
        if (event.getSelectedPage() == selectRootPage) {
            Repository existingRepo = this.selectRepoPage.getRepository();
            if (existingRepo != null) {
                selectRootPage.setInitialImportRoot(existingRepo.getWorkTree());
            } else if (this.needToCloneRepository()) {
                this.doClone(selectRootPage);
            }
        }
    }

    public void setContainer(IWizardContainer container) {
        if (container instanceof IPageChangeProvider) {
            ((IPageChangeProvider)container).addPageChangedListener((IPageChangedListener)this);
        }
        super.setContainer(container);
    }

    public void dispose() {
        if (this.getContainer() instanceof IPageChangeProvider) {
            ((IPageChangeProvider)this.getContainer()).removePageChangedListener((IPageChangedListener)this);
        }
        super.dispose();
    }
}

