/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesOfSingleton;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesOfSingleton;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class TypeSetIntersection
extends TypeSet {
    private TypeSet fLHS;
    private TypeSet fRHS;
    private EnumeratedTypeSet fEnumCache = null;

    public TypeSetIntersection(TypeSet lhs, TypeSet rhs) {
        super(lhs.getTypeSetEnvironment());
        this.fLHS = lhs;
        this.fRHS = rhs;
    }

    public TypeSet getLHS() {
        return this.fLHS;
    }

    public TypeSet getRHS() {
        return this.fRHS;
    }

    @Override
    public boolean isUniverse() {
        return this.fLHS.isUniverse() && this.fRHS.isUniverse();
    }

    @Override
    public TypeSet makeClone() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (this.fLHS.isEmpty() || this.fRHS.isEmpty()) {
            return true;
        }
        if (this.fLHS.isUniverse() || this.fRHS.isUniverse()) {
            return false;
        }
        if (this.fLHS.contains(this.getJavaLangObject()) && this.fRHS.contains(this.getJavaLangObject())) {
            return false;
        }
        return false;
    }

    @Override
    public boolean contains(TType t) {
        return this.fLHS.contains(t) && this.fRHS.contains(t);
    }

    @Override
    public boolean containsAll(TypeSet s) {
        return this.fLHS.containsAll(s) && this.fRHS.containsAll(s);
    }

    @Override
    public TypeSet subTypes() {
        if (this.isUniverse() || this.contains(this.getJavaLangObject())) {
            return this.getTypeSetEnvironment().getUniverseTypeSet();
        }
        if ((this.fLHS instanceof SubTypesSet || this.fLHS instanceof SubTypesOfSingleton) && (this.fRHS instanceof SubTypesSet || this.fRHS instanceof SubTypesOfSingleton)) {
            return this;
        }
        return this.getTypeSetEnvironment().createSubTypesSet(this);
    }

    @Override
    public TypeSet superTypes() {
        if ((this.fLHS instanceof SuperTypesSet || this.fLHS instanceof SuperTypesOfSingleton) && (this.fRHS instanceof SuperTypesSet || this.fRHS instanceof SuperTypesOfSingleton)) {
            return this;
        }
        return this.getTypeSetEnvironment().createSuperTypesSet(this);
    }

    @Override
    public TypeSet upperBound() {
        if (this.fLHS.contains(this.getJavaLangObject()) && this.fRHS.contains(this.getJavaLangObject())) {
            return new SingletonTypeSet(this.getTypeSetEnvironment().getJavaLangObject(), this.getTypeSetEnvironment());
        }
        if (this.fEnumCache != null) {
            return this.fEnumCache.upperBound();
        }
        EnumeratedTypeSet lhsSet = this.fLHS.enumerate();
        EnumeratedTypeSet rhsSet = this.fRHS.enumerate();
        TypeSet xsect = lhsSet.intersectedWith(rhsSet);
        return xsect.upperBound();
    }

    @Override
    public TypeSet lowerBound() {
        if (this.fLHS.hasUniqueLowerBound() && this.fRHS.hasUniqueLowerBound()) {
            TType rhsBound;
            TType lhsBound = this.fLHS.uniqueLowerBound();
            if (lhsBound.equals(rhsBound = this.fRHS.uniqueLowerBound())) {
                return new SingletonTypeSet(lhsBound, this.getTypeSetEnvironment());
            }
            if (TTypes.canAssignTo(lhsBound, rhsBound)) {
                return new SingletonTypeSet(rhsBound, this.getTypeSetEnvironment());
            }
            if (TTypes.canAssignTo(rhsBound, lhsBound)) {
                return new SingletonTypeSet(lhsBound, this.getTypeSetEnvironment());
            }
        }
        if (this.fEnumCache != null) {
            return this.fEnumCache.lowerBound();
        }
        EnumeratedTypeSet lhsSet = this.fLHS.enumerate();
        EnumeratedTypeSet rhsSet = this.fRHS.enumerate();
        TypeSet xsect = lhsSet.intersectedWith(rhsSet);
        return xsect.lowerBound();
    }

    @Override
    protected TypeSet specialCasesIntersectedWith(TypeSet s2) {
        if (s2.equals(this.fLHS)) {
            return this;
        }
        if (s2.equals(this.fRHS)) {
            return this;
        }
        if (s2 instanceof TypeSetIntersection) {
            TypeSetIntersection x2 = (TypeSetIntersection)s2;
            if (this.fLHS.equals(x2.fLHS)) {
                return new TypeSetIntersection(this, x2.fRHS);
            }
            if (this.fLHS.equals(x2.fRHS)) {
                return new TypeSetIntersection(this, x2.fLHS);
            }
            if (this.fRHS.equals(x2.fLHS)) {
                return new TypeSetIntersection(this, x2.fRHS);
            }
            if (this.fRHS.equals(x2.fRHS)) {
                return new TypeSetIntersection(this, x2.fLHS);
            }
        }
        return null;
    }

    @Override
    public boolean isSingleton() {
        if (this.fEnumCache != null) {
            return this.fEnumCache.isSingleton();
        }
        int count = 0;
        Iterator<TType> lhsIter = this.fLHS.iterator();
        while (lhsIter.hasNext()) {
            TType t = lhsIter.next();
            if (this.fRHS.contains(t)) {
                ++count;
            }
            if (count <= 1) continue;
            return false;
        }
        return count == 1;
    }

    @Override
    public TType anyMember() {
        if (this.fEnumCache != null) {
            return this.fEnumCache.anyMember();
        }
        Iterator<TType> lhsIter = this.fLHS.iterator();
        while (lhsIter.hasNext()) {
            TType t = lhsIter.next();
            if (!this.fRHS.contains(t)) continue;
            return t;
        }
        return null;
    }

    @Override
    public Iterator<TType> iterator() {
        return this.enumerate().iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof TypeSetIntersection) {
            TypeSetIntersection other = (TypeSetIntersection)o;
            return other.fLHS.equals(this.fLHS) && other.fRHS.equals(this.fRHS);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.fLHS.hashCode() * 37 + this.fRHS.hashCode();
    }

    @Override
    public String toString() {
        return "<" + this.fID + ": intersect(" + String.valueOf(this.fLHS) + "," + String.valueOf(this.fRHS) + ")>";
    }

    @Override
    public boolean hasUniqueLowerBound() {
        return false;
    }

    @Override
    public boolean hasUniqueUpperBound() {
        return false;
    }

    @Override
    public TType uniqueLowerBound() {
        return null;
    }

    @Override
    public TType uniqueUpperBound() {
        return null;
    }

    @Override
    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            EnumeratedTypeSet lhsSet = this.fLHS.enumerate();
            EnumeratedTypeSet rhsSet = this.fRHS.enumerate();
            this.fEnumCache = lhsSet.intersectedWith(rhsSet).enumerate();
        }
        return this.fEnumCache;
    }
}

