/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import java.io.BufferedReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.LineReader;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator2;
import org.eclipse.compare.structuremergeviewer.SharedDocumentAdapterWrapper;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class StructureCreator
implements IStructureCreator2 {
    @Override
    public IStructureComparator getStructure(Object input) {
        String contents = null;
        IDocument doc = CompareUI.getDocument(input);
        if (doc == null) {
            if (input instanceof IStreamContentAccessor) {
                IStreamContentAccessor sca = (IStreamContentAccessor)input;
                try {
                    contents = Utilities.readString(sca);
                }
                catch (CoreException e) {
                    CompareUIPlugin.log(e);
                    return null;
                }
            }
            if (contents == null) {
                return null;
            }
            doc = new Document(contents);
            this.setupDocument(doc);
        }
        try {
            return this.createStructureComparator(input, doc, null, null);
        }
        catch (CoreException e) {
            CompareUIPlugin.log(e);
            return null;
        }
    }

    @Override
    public IStructureComparator createStructure(Object element, IProgressMonitor monitor) throws CoreException {
        IStructureComparator[] result = new IStructureComparator[1];
        Runnable runnable = () -> {
            try {
                iStructureComparatorArray[0] = this.internalCreateStructure(element, monitor);
            }
            catch (OperationCanceledException ex) {
                return;
            }
        };
        Utilities.runInUIThread(runnable);
        return result[0];
    }

    private IStructureComparator internalCreateStructure(Object element, IProgressMonitor monitor) {
        IDocumentProvider provider;
        IEditorInput input;
        ISharedDocumentAdapter sda = SharedDocumentAdapterWrapper.getAdapter(element);
        if (sda != null && (input = sda.getDocumentKey(element)) != null && (provider = SharedDocumentAdapter.getDocumentProvider(input)) != null) {
            try {
                sda.connect(provider, input);
                IDocument document = provider.getDocument((Object)input);
                this.setupDocument(document);
                return this.createStructureComparator(element, document, this.wrapSharedDocumentAdapter(sda, element, document), monitor);
            }
            catch (CoreException e) {
                CompareUIPlugin.log(e);
            }
        }
        return this.getStructure(element);
    }

    protected abstract IStructureComparator createStructureComparator(Object var1, IDocument var2, ISharedDocumentAdapter var3, IProgressMonitor var4) throws CoreException;

    protected void setupDocument(IDocument document) {
        String partitioning = this.getDocumentPartitioning();
        if (partitioning == null || !(document instanceof IDocumentExtension3)) {
            IDocumentPartitioner partitioner;
            if (document.getDocumentPartitioner() == null && (partitioner = this.getDocumentPartitioner()) != null) {
                document.setDocumentPartitioner(partitioner);
                partitioner.connect(document);
            }
        } else {
            IDocumentPartitioner partitioner;
            IDocumentExtension3 ex3 = (IDocumentExtension3)document;
            if (ex3.getDocumentPartitioner(partitioning) == null && (partitioner = this.getDocumentPartitioner()) != null) {
                ex3.setDocumentPartitioner(partitioning, partitioner);
                partitioner.connect(document);
            }
        }
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return null;
    }

    protected String getDocumentPartitioning() {
        return null;
    }

    @Override
    public void save(IStructureComparator node, Object input) {
        if (node instanceof IDocumentRange && input instanceof IEditableContent) {
            byte[] bytes;
            IDocument providerDoc;
            IDocumentProvider provider;
            IEditorInput key;
            IDocument document = ((IDocumentRange)((Object)node)).getDocument();
            ISharedDocumentAdapter sda = SharedDocumentAdapterWrapper.getAdapter(input);
            if (sda != null && (key = sda.getDocumentKey(input)) != null && (provider = SharedDocumentAdapter.getDocumentProvider(key)) != null && (providerDoc = provider.getDocument((Object)key)) != null && providerDoc == document && this.save(provider, document, input, sda, key)) {
                return;
            }
            IEditableContent bca = (IEditableContent)input;
            String contents = document.get();
            String encoding = null;
            if (input instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)input).getCharset();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            try {
                bytes = contents.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                bytes = contents.getBytes();
            }
            bca.setContent(bytes);
        }
    }

    private boolean save(IDocumentProvider provider, IDocument document, Object input, ISharedDocumentAdapter sda, IEditorInput key) {
        try {
            sda.flushDocument(provider, key, document, false);
            return true;
        }
        catch (CoreException e) {
            CompareUIPlugin.log(e);
            return false;
        }
    }

    private final ISharedDocumentAdapter wrapSharedDocumentAdapter(ISharedDocumentAdapter elementAdapter, final Object input, final IDocument document) {
        return new SharedDocumentAdapterWrapper(elementAdapter){

            @Override
            public IEditorInput getDocumentKey(Object element) {
                if (this.hasSameDocument(element)) {
                    return super.getDocumentKey(input);
                }
                return super.getDocumentKey(element);
            }

            private boolean hasSameDocument(Object element) {
                if (element instanceof DocumentRangeNode) {
                    DocumentRangeNode drn = (DocumentRangeNode)element;
                    return drn.getDocument() == document;
                }
                return false;
            }
        };
    }

    @Override
    public ITypedElement createElement(Object element, Object input, IProgressMonitor monitor) throws CoreException {
        String[] path = this.getPath(element, input);
        if (path == null) {
            IStructureComparator locate = this.locate(element, input);
            if (locate instanceof ITypedElement) {
                return (ITypedElement)((Object)locate);
            }
            return null;
        }
        IStructureComparator structure = this.createStructure(input, monitor);
        if (structure == null) {
            return null;
        }
        return this.findElement(structure, path);
    }

    @Override
    public IStructureComparator locate(Object element, Object input) {
        String[] path = this.getPath(element, input);
        if (path == null) {
            return null;
        }
        IStructureComparator structure = this.getStructure(input);
        if (structure == null) {
            return null;
        }
        return (IStructureComparator)((Object)this.findElement(structure, path));
    }

    protected ITypedElement findElement(IStructureComparator structure, String[] path) {
        return (ITypedElement)((Object)this.find(structure, path, 0));
    }

    private IStructureComparator find(IStructureComparator tree, String[] path, int index) {
        Object[] children;
        if (tree != null && (children = tree.getChildren()) != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object c = objectArray[n2];
                IStructureComparator child = (IStructureComparator)c;
                if (child instanceof ITypedElement && child instanceof DocumentRangeNode) {
                    String n22;
                    String n1 = ((DocumentRangeNode)child).getId();
                    if (n1 == null) {
                        n1 = ((ITypedElement)((Object)child)).getName();
                    }
                    if (n1.equals(n22 = path[index])) {
                        if (index == path.length - 1) {
                            return child;
                        }
                        IStructureComparator result = this.find(child, path, index + 1);
                        if (result != null) {
                            return result;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    protected String[] getPath(Object element, Object input) {
        return null;
    }

    @Override
    public void destroy(Object object) {
        IDisposable disposable = this.getDisposable(object);
        if (disposable != null) {
            disposable.dispose();
        }
    }

    private IDisposable getDisposable(Object object) {
        if (object instanceof IDisposable) {
            return (IDisposable)object;
        }
        if (object instanceof DocumentRangeNode) {
            DocumentRangeNode node = (DocumentRangeNode)object;
            return this.getDisposable(node.getParentNode());
        }
        return null;
    }

    public boolean contentsEquals(Object node1, char contributor1, Object node2, char contributor2, boolean ignoreWhitespace, ICompareFilter[] compareFilters) {
        List<String> lines1 = LineReader.readLines(new BufferedReader(new StringReader(this.getContents(node1, false))));
        List<String> lines2 = LineReader.readLines(new BufferedReader(new StringReader(this.getContents(node2, false))));
        StringBuilder buffer1 = new StringBuilder();
        StringBuilder buffer2 = new StringBuilder();
        int maxLines = Math.max(lines1.size(), lines2.size());
        int i = 0;
        while (i < maxLines) {
            String s2;
            String s1 = lines1.size() > i ? lines1.get(i) : "";
            String string = s2 = lines2.size() > i ? lines2.get(i) : "";
            if (compareFilters != null && compareFilters.length > 0) {
                s1 = Utilities.applyCompareFilters(s1, contributor1, s2, contributor2, compareFilters);
                s2 = Utilities.applyCompareFilters(s2, contributor2, s1, contributor1, compareFilters);
            }
            buffer1.append(s1);
            buffer2.append(s2);
            ++i;
        }
        if (ignoreWhitespace) {
            int l1 = buffer1.length();
            int l2 = buffer2.length();
            int c1 = 0;
            int c2 = 0;
            int i1 = 0;
            int i2 = 0;
            while (c1 != -1) {
                char c;
                c1 = -1;
                while (i1 < l1) {
                    if (Character.isWhitespace(c = buffer1.charAt(i1++))) continue;
                    c1 = c;
                    break;
                }
                c2 = -1;
                while (i2 < l2) {
                    if (Character.isWhitespace(c = buffer2.charAt(i2++))) continue;
                    c2 = c;
                    break;
                }
                if (c1 == c2) continue;
                return false;
            }
        } else if (!buffer1.toString().equals(buffer2.toString())) {
            return false;
        }
        return true;
    }
}

