/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.ProcDecl;
import org.eclipse.rcptt.core.ecl.model.VarDecl;

public class CompositeContainer
implements IDeclContainer {
    private IDeclContainer[] children;

    public CompositeContainer(IDeclContainer ... children) {
        this.children = children;
    }

    public void addProc(ProcDecl proc) {
        throw new UnsupportedOperationException();
    }

    public void addVar(VarDecl var) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProcDecl[] getProcs() {
        return this.getProcMap().values().toArray(new ProcDecl[0]);
    }

    @Override
    public VarDecl[] getVars() {
        return this.getVarMap().values().toArray(new VarDecl[0]);
    }

    @Override
    public ProcDecl resolveProc(String name) {
        IDeclContainer[] iDeclContainerArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IDeclContainer child = iDeclContainerArray[n2];
            ProcDecl result = child.resolveProc(name);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public VarDecl resolveVar(String name) {
        IDeclContainer[] iDeclContainerArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IDeclContainer child = iDeclContainerArray[n2];
            VarDecl result = child.resolveVar(name);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private Map<String, VarDecl> getVarMap() {
        LinkedHashMap<String, VarDecl> result = new LinkedHashMap<String, VarDecl>();
        IDeclContainer[] iDeclContainerArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IDeclContainer child = iDeclContainerArray[n2];
            VarDecl[] varDeclArray = child.getVars();
            int n3 = varDeclArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VarDecl var = varDeclArray[n4];
                if (!result.containsKey(var.name)) {
                    result.put(var.name, var);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private Map<String, ProcDecl> getProcMap() {
        LinkedHashMap<String, ProcDecl> result = new LinkedHashMap<String, ProcDecl>();
        IDeclContainer[] iDeclContainerArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IDeclContainer child = iDeclContainerArray[n2];
            ProcDecl[] procDeclArray = child.getProcs();
            int n3 = procDeclArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ProcDecl proc = procDeclArray[n4];
                if (!result.containsKey(proc.name)) {
                    result.put(proc.name, proc);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String getResource() {
        return null;
    }
}

