/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;

public class Q7ProjectInfo
extends OpenableElementInfo {
    private Object[] foreignResources;
    private ProjectMetadata metadata;

    public void setForeignResources(Object[] resources) {
        this.foreignResources = resources;
    }

    public Object[] getForeignResources(IContainer container) throws ModelException {
        if (this.foreignResources == null) {
            this.foreignResources = Q7ProjectInfo.computeFolderForeignResources(container);
        }
        return this.foreignResources;
    }

    public static Object[] computeFolderForeignResources(IContainer folder) throws ModelException {
        Object[] nonQ7Resources = new IResource[5];
        int nonQ7ResourcesCounter = 0;
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                switch (member.getType()) {
                    case 1: {
                        if (RcpttCore.isQ7File(member.getFullPath())) break;
                    }
                    default: {
                        if (nonQ7Resources.length == nonQ7ResourcesCounter) {
                            Object[] objectArray = nonQ7Resources;
                            nonQ7Resources = new IResource[nonQ7ResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonQ7Resources, 0, nonQ7ResourcesCounter);
                        }
                        nonQ7Resources[nonQ7ResourcesCounter++] = member;
                    }
                }
                ++i;
            }
            if (nonQ7Resources.length != nonQ7ResourcesCounter) {
                Object[] objectArray = nonQ7Resources;
                nonQ7Resources = new IResource[nonQ7ResourcesCounter];
                System.arraycopy(objectArray, 0, nonQ7Resources, 0, nonQ7ResourcesCounter);
            }
            return nonQ7Resources;
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }
}

