/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OverrideDependenciesDialog
extends MessageDialog {
    Text fModuleArgumentsText;
    Text fModuleArgumentsNewText;
    ILaunchConfiguration flaunchConfiguration;

    public OverrideDependenciesDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, ILaunchConfiguration config) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.flaunchConfiguration = config;
    }

    protected Control createCustomArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        Font font = parent.getFont();
        Group group = new Group(comp, 0);
        GridLayout topLayout = new GridLayout();
        group.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        gd.widthHint = this.convertWidthInCharsToPixels(70);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        Label description = new Label((Composite)group, 64);
        description.setText(ActionMessages.Override_Dependencies_label1);
        this.fModuleArgumentsText = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fModuleArgumentsText.setLayoutData((Object)gd);
        Label description1 = new Label((Composite)group, 64);
        description1.setText(ActionMessages.Override_Dependencies_label2);
        this.fModuleArgumentsNewText = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fModuleArgumentsNewText.setLayoutData((Object)gd);
        String moduleCLIOptions = "";
        try {
            AbstractJavaLaunchConfigurationDelegate delegate = this.getJavaLaunchConfigurationDelegate();
            if (delegate != null) {
                moduleCLIOptions = delegate.getModuleCLIOptions(this.flaunchConfiguration);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.fModuleArgumentsText.setText(moduleCLIOptions);
        this.fModuleArgumentsText.setEditable(false);
        try {
            if (!this.flaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_MODULE_CLI_OPTIONS, true)) {
                String str = this.flaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_CLI_OPTIONS, "");
                this.fModuleArgumentsNewText.setText(str);
            } else {
                this.fModuleArgumentsNewText.setText(moduleCLIOptions);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return comp;
    }

    public AbstractJavaLaunchConfigurationDelegate getJavaLaunchConfigurationDelegate() throws CoreException {
        Set modes = this.flaunchConfiguration.getModes();
        modes.add("run");
        AbstractJavaLaunchConfigurationDelegate delegate = null;
        ILaunchDelegate[] iLaunchDelegateArray = this.flaunchConfiguration.getType().getDelegates(modes);
        int n = iLaunchDelegateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchDelegate launchDelegate = iLaunchDelegateArray[n2];
            if (launchDelegate.getDelegate() instanceof AbstractJavaLaunchConfigurationDelegate) {
                delegate = (AbstractJavaLaunchConfigurationDelegate)launchDelegate.getDelegate();
                break;
            }
            ++n2;
        }
        return delegate;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (!this.fModuleArgumentsNewText.getText().equals(this.fModuleArgumentsText.getText())) {
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = this.flaunchConfiguration.getWorkingCopy();
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_MODULE_CLI_OPTIONS, false);
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_CLI_OPTIONS, this.fModuleArgumentsNewText.getText());
                    workingCopy.doSave();
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
            } else {
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = this.flaunchConfiguration.getWorkingCopy();
                    boolean attribute = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_MODULE_CLI_OPTIONS, true);
                    if (!attribute) {
                        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_MODULE_CLI_OPTIONS, true);
                        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_CLI_OPTIONS, this.fModuleArgumentsNewText.getText());
                        workingCopy.doSave();
                    }
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        }
        super.buttonPressed(buttonId);
    }
}

