/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.multiaut;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.rcptt.launching.multiaut.MultiAutLaunchPlugin;

public class LaunchStoreEntry {
    public final boolean restart;
    public final String autName;
    public final String testId;
    private static final LaunchStoreEntry UNITIALIZED = new LaunchStoreEntry(null, null, false);
    private static final LaunchStoreEntry[] NO_ENTRIES = new LaunchStoreEntry[0];
    private static final String PROP_TEST = "testId";
    private static final String PROP_AUT = "autName";
    private static final String PROP_RESTART = "restart";
    private static final String ATTR_ENTRIES = "q7.multilaunch.entries";

    public LaunchStoreEntry(String testId, String autName, boolean restart) {
        this.testId = testId;
        this.autName = autName;
        this.restart = restart;
    }

    public static JsonObject toJson(LaunchStoreEntry entry) {
        JsonObject result = new JsonObject();
        result.addProperty(PROP_TEST, entry.testId);
        result.addProperty(PROP_AUT, entry.autName);
        result.addProperty(PROP_RESTART, Boolean.valueOf(entry.restart));
        return result;
    }

    public static LaunchStoreEntry fromJson(JsonElement element) {
        if (!element.isJsonObject()) {
            return UNITIALIZED;
        }
        JsonObject object = (JsonObject)element;
        return new LaunchStoreEntry(LaunchStoreEntry.getSafeString(object, PROP_TEST, null), LaunchStoreEntry.getSafeString(object, PROP_AUT, null), LaunchStoreEntry.getSafeBool(object, PROP_RESTART, false));
    }

    public static LaunchStoreEntry[] entriesFromConfig(ILaunchConfiguration config) {
        String jsonString = null;
        try {
            jsonString = config.getAttribute(ATTR_ENTRIES, "[]");
        }
        catch (CoreException e) {
            MultiAutLaunchPlugin.logWarn(e, "Error getting attribute from config %s. Empty list will be used.", config.getName());
            return NO_ENTRIES;
        }
        JsonElement element = null;
        try {
            element = new JsonParser().parse(jsonString);
        }
        catch (JsonParseException e) {
            MultiAutLaunchPlugin.logWarn(e, "Error parsing json from config %s. Empty list will be used.", config.getName());
            return NO_ENTRIES;
        }
        if (!element.isJsonArray()) {
            MultiAutLaunchPlugin.logWarn("json is not an array in config %s. Empty list will be used.", config.getName());
            return NO_ENTRIES;
        }
        JsonArray entries = (JsonArray)element;
        ArrayList<LaunchStoreEntry> result = new ArrayList<LaunchStoreEntry>();
        for (JsonElement entry : entries) {
            result.add(LaunchStoreEntry.fromJson(entry));
        }
        return result.toArray(new LaunchStoreEntry[result.size()]);
    }

    public static void entriesToConfig(LaunchStoreEntry[] entries, ILaunchConfigurationWorkingCopy config) {
        JsonArray array = new JsonArray();
        LaunchStoreEntry[] launchStoreEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            LaunchStoreEntry entry = launchStoreEntryArray[n2];
            array.add((JsonElement)LaunchStoreEntry.toJson(entry));
            ++n2;
        }
        config.setAttribute(ATTR_ENTRIES, array.toString());
    }

    private static String getSafeString(JsonObject object, String property, String def) {
        if (!object.has(property)) {
            return def;
        }
        try {
            return object.get(property).getAsString();
        }
        catch (Exception e) {
            return def;
        }
    }

    private static boolean getSafeBool(JsonObject object, String property, boolean def) {
        if (!object.has(property)) {
            return def;
        }
        try {
            return object.get(property).getAsBoolean();
        }
        catch (Exception e) {
            return def;
        }
    }
}

