/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.ASTSemanticMatcher;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.InterruptibleVisitor;
import org.eclipse.jdt.internal.corext.dom.OrderedInfixExpression;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.dom.TypeRules;
import org.eclipse.jdt.internal.corext.dom.VarConflictVisitor;
import org.eclipse.jdt.internal.corext.dom.VarDeclarationIdentifierVisitor;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ASTNodes {
    public static final String UNTOUCH_COMMENT = "untouchComment";
    public static final int NODE_ONLY = 0;
    public static final int INCLUDE_FIRST_PARENT = 1;
    public static final int INCLUDE_ALL_PARENTS = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int INFO = 4;
    public static final int PROBLEMS = 7;
    public static final int EXCESSIVE_OPERAND_NUMBER = 5;
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    private static final IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    private static final int CLEAR_VISIBILITY = -8;
    static final Pattern comment = Pattern.compile("([ ]*\\/\\/\\$NON-NLS-[0-9]\\$) *$");
    static final Pattern leadingspaces_start = Pattern.compile("^[ \t]*");
    static final Pattern leadingspaces = Pattern.compile("\n[ \t]*");

    private ASTNodes() {
    }

    public static String asString(ASTNode node) {
        ASTFlattener flattener = new ASTFlattener();
        node.accept((ASTVisitor)flattener);
        return flattener.getResult();
    }

    public static String asFormattedString(ASTNode node, int indent, String lineDelim, Map<String, String> options) {
        String unformatted = ASTNodes.asString(node);
        TextEdit edit = CodeFormatterUtil.format2(node, unformatted, indent, lineDelim, options);
        if (edit != null) {
            Document document = new Document(unformatted);
            try {
                edit.apply((IDocument)document, 0);
            }
            catch (BadLocationException e) {
                JavaManipulationPlugin.log(e);
            }
            return document.get();
        }
        return unformatted;
    }

    public static String getNodeSource(ASTNode node, boolean extendedRange, boolean removeIndent) {
        ASTNode root = node.getRoot();
        if (root instanceof CompilationUnit) {
            CompilationUnit astRoot = (CompilationUnit)root;
            ITypeRoot typeRoot = astRoot.getTypeRoot();
            try {
                if (typeRoot != null && typeRoot.getBuffer() != null) {
                    IBuffer buffer = typeRoot.getBuffer();
                    int offset = extendedRange ? astRoot.getExtendedStartPosition(node) : node.getStartPosition();
                    int length = extendedRange ? astRoot.getExtendedLength(node) : node.getLength();
                    String str = buffer.getText(offset, length);
                    if (removeIndent) {
                        IJavaProject project = typeRoot.getJavaProject();
                        int indent = ASTNodes.getIndentUsed(buffer, node.getStartPosition(), project);
                        str = Strings.changeIndent(str, indent, project, "", typeRoot.findRecommendedLineSeparator());
                    }
                    return str;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    private static int getIndentUsed(IBuffer buffer, int offset, IJavaProject project) {
        int i = offset;
        while (i > 0 && !IndentManipulation.isLineDelimiterChar((char)buffer.getChar(i - 1))) {
            --i;
        }
        return Strings.computeIndentUnits(buffer.getText(i, offset - i), project);
    }

    public static List<? extends ASTNode> getContainingList(ASTNode node) {
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent != null && locationInParent.isChildListProperty()) {
            return ASTNodes.getChildListProperty(node.getParent(), (ChildListPropertyDescriptor)locationInParent);
        }
        return null;
    }

    public static <T extends ASTNode> List<T> getChildListProperty(ASTNode node, ChildListPropertyDescriptor propertyDescriptor) {
        return (List)node.getStructuralProperty((StructuralPropertyDescriptor)propertyDescriptor);
    }

    public static List<ASTNode> getChildren(ASTNode node) {
        ChildrenCollector visitor = new ChildrenCollector();
        node.accept((ASTVisitor)visitor);
        return visitor.result;
    }

    public static boolean isExistingNode(ASTNode node) {
        return node.getStartPosition() != -1;
    }

    public static Type getElementType(Type type) {
        if (!type.isArrayType()) {
            return type;
        }
        return ((ArrayType)type).getElementType();
    }

    public static List<ITypeBinding> filterSubtypes(List<ITypeBinding> typeBindings) {
        ArrayList<ITypeBinding> filteredBindings = new ArrayList<ITypeBinding>(typeBindings);
        Iterator subtypeIterator = filteredBindings.iterator();
        block0: while (subtypeIterator.hasNext()) {
            ITypeBinding iTypeBinding = (ITypeBinding)subtypeIterator.next();
            for (ITypeBinding superTypeBinding : filteredBindings) {
                if (iTypeBinding.equals((Object)superTypeBinding) || !iTypeBinding.isSubTypeCompatible(superTypeBinding)) continue;
                subtypeIterator.remove();
                continue block0;
            }
        }
        return filteredBindings;
    }

    public static ASTNode findDeclaration(IBinding binding, ASTNode root) {
        if ((root = root.getRoot()) instanceof CompilationUnit) {
            return ((CompilationUnit)root).findDeclaringNode(binding);
        }
        return null;
    }

    public static VariableDeclaration findVariableDeclaration(IVariableBinding binding, ASTNode root) {
        if (binding.isField()) {
            return null;
        }
        ASTNode result = ASTNodes.findDeclaration((IBinding)binding, root);
        if (result instanceof VariableDeclaration) {
            return (VariableDeclaration)result;
        }
        return null;
    }

    public static Type getType(VariableDeclaration declaration) {
        if (declaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)declaration).getType();
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).getType();
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).getType();
            }
            if (parent instanceof FieldDeclaration) {
                return ((FieldDeclaration)parent).getType();
            }
            if (parent instanceof LambdaExpression) {
                return null;
            }
        }
        Assert.isTrue((boolean)false, (String)"Unknown VariableDeclaration");
        return null;
    }

    public static int getDimensions(VariableDeclaration declaration) {
        int dim = declaration.getExtraDimensions();
        if (declaration instanceof VariableDeclarationFragment && declaration.getParent() instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)declaration.getParent();
            IMethodBinding methodBinding = lambda.resolveMethodBinding();
            if (methodBinding != null) {
                ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
                int index = lambda.parameters().indexOf(declaration);
                ITypeBinding typeBinding = parameterTypes[index];
                return typeBinding.getDimensions();
            }
        } else {
            Type type = ASTNodes.getType(declaration);
            if (type instanceof ArrayType) {
                dim += ((ArrayType)type).getDimensions();
            }
        }
        return dim;
    }

    public static List<IExtendedModifier> getModifiers(VariableDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        if (declaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)declaration).modifiers();
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).modifiers();
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).modifiers();
            }
        }
        return new ArrayList<IExtendedModifier>(0);
    }

    public static boolean isSingleDeclaration(VariableDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        if (declaration instanceof SingleVariableDeclaration) {
            return true;
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).fragments().size() == 1;
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).fragments().size() == 1;
            }
        }
        return false;
    }

    public static boolean instanceOf(Expression expression, String qualifiedTypeName) {
        return expression != null && ASTNodes.instanceOf(expression.resolveTypeBinding(), qualifiedTypeName);
    }

    public static boolean instanceOf(ITypeBinding typeBinding, String qualifiedTypeName) {
        return ASTNodes.findImplementedType(typeBinding, qualifiedTypeName) != null;
    }

    public static boolean isArray(Expression expression) {
        if (expression != null) {
            ITypeBinding typeBinding = expression.resolveTypeBinding();
            return typeBinding != null && typeBinding.isArray();
        }
        return false;
    }

    private static boolean isEnumConstant(Expression expression) {
        IBinding binding;
        if (expression instanceof Name && (binding = ((Name)expression).resolveBinding()) instanceof IVariableBinding) {
            return ((IVariableBinding)binding).isEnumConstant();
        }
        return false;
    }

    public static boolean isHardCoded(Expression expression) {
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: 
            case 45: {
                return true;
            }
            case 27: {
                for (Expression operand : ASTNodes.allOperands((InfixExpression)expression)) {
                    if (ASTNodes.isHardCoded(operand)) continue;
                    return false;
                }
                return true;
            }
            case 38: {
                PrefixExpression prefixExpression = (PrefixExpression)expression;
                return ASTNodes.isHardCoded(prefixExpression.getOperand());
            }
            case 37: {
                PostfixExpression postfixExpression = (PostfixExpression)expression;
                return ASTNodes.isHardCoded(postfixExpression.getOperand());
            }
            case 11: {
                return ASTNodes.isHardCoded(((CastExpression)expression).getExpression());
            }
            case 36: {
                return ASTNodes.isHardCoded(((ParenthesizedExpression)expression).getExpression());
            }
        }
        return expression.resolveConstantExpressionValue() != null || ASTNodes.isEnumConstant(expression);
    }

    public static Long getIntegerLiteral(Expression input) {
        Long value;
        if (input == null) {
            return null;
        }
        Object number = input.resolveConstantExpressionValue();
        if (number instanceof Short) {
            return ((Short)number).intValue();
        }
        if (number instanceof Integer) {
            return (long)((Integer)number);
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        InfixExpression operation = ASTNodes.as(input, InfixExpression.class);
        if (operation != null && ASTNodes.hasOperator(operation, InfixExpression.Operator.AND, InfixExpression.Operator.DIVIDE, InfixExpression.Operator.LEFT_SHIFT, InfixExpression.Operator.MINUS, InfixExpression.Operator.OR, InfixExpression.Operator.PLUS, InfixExpression.Operator.REMAINDER, InfixExpression.Operator.RIGHT_SHIFT_SIGNED, InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED, InfixExpression.Operator.TIMES, InfixExpression.Operator.XOR)) {
            List<Expression> operands = ASTNodes.allOperands(operation);
            Long leftValue = ASTNodes.getIntegerLiteral(operands.remove(0));
            if (leftValue == null) {
                return null;
            }
            long result = leftValue;
            for (Expression operand : operands) {
                Long newObject = ASTNodes.getIntegerLiteral(operand);
                if (newObject == null) {
                    return null;
                }
                long newValue = newObject;
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.PLUS, new InfixExpression.Operator[0])) {
                    result += newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.MINUS, new InfixExpression.Operator[0])) {
                    result -= newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.TIMES, new InfixExpression.Operator[0])) {
                    result *= newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.AND, new InfixExpression.Operator[0])) {
                    result &= newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.OR, new InfixExpression.Operator[0])) {
                    result |= newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.XOR, new InfixExpression.Operator[0])) {
                    result ^= newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.LEFT_SHIFT, new InfixExpression.Operator[0])) {
                    result <<= (int)newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.REMAINDER, new InfixExpression.Operator[0])) {
                    result %= newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.RIGHT_SHIFT_SIGNED, new InfixExpression.Operator[0])) {
                    result >>= (int)newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED, new InfixExpression.Operator[0])) {
                    result >>>= (int)newValue;
                    continue;
                }
                if (ASTNodes.hasOperator(operation, InfixExpression.Operator.DIVIDE, new InfixExpression.Operator[0]) && result % newValue == 0L) {
                    result /= newValue;
                    continue;
                }
                return null;
            }
            return result;
        }
        PrefixExpression negativeContant = ASTNodes.as(input, PrefixExpression.class);
        if (negativeContant != null && ASTNodes.hasOperator(negativeContant, PrefixExpression.Operator.MINUS, new PrefixExpression.Operator[0]) && (value = ASTNodes.getIntegerLiteral(negativeContant.getOperand())) != null) {
            return -value.longValue();
        }
        return null;
    }

    public static Object peremptoryValue(Expression peremptoryExpression) {
        Object constantExpression = peremptoryExpression.resolveConstantExpressionValue();
        if (constantExpression != null) {
            return constantExpression;
        }
        InfixExpression infixExpression = ASTNodes.as(peremptoryExpression, InfixExpression.class);
        if (infixExpression != null && !infixExpression.hasExtendedOperands() && ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS)) {
            if (ASTNodes.match((ASTNode)infixExpression.getLeftOperand(), (ASTNode)infixExpression.getRightOperand())) {
                return ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.EQUALS, new InfixExpression.Operator[0]);
            }
            if (ASTSemanticMatcher.INSTANCE.matchNegative((ASTNode)infixExpression.getLeftOperand(), infixExpression.getRightOperand())) {
                return ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.NOT_EQUALS, new InfixExpression.Operator[0]);
            }
        }
        return null;
    }

    public static SimpleName getField(Expression expression) {
        SuperFieldAccess superFieldAccess;
        TypeDeclaration visitedClass;
        SimpleName qualifier;
        ThisExpression thisExpression;
        SimpleName simpleName = ASTNodes.as(expression, SimpleName.class);
        if (simpleName != null) {
            return simpleName;
        }
        FieldAccess fieldName = ASTNodes.as(expression, FieldAccess.class);
        if (fieldName != null && (thisExpression = ASTNodes.as(fieldName.getExpression(), ThisExpression.class)) != null) {
            if (thisExpression.getQualifier() == null) {
                return fieldName.getName();
            }
            if (thisExpression.getQualifier().isSimpleName()) {
                qualifier = (SimpleName)thisExpression.getQualifier();
                visitedClass = ASTNodes.getTypedAncestor((ASTNode)expression, TypeDeclaration.class);
                if (visitedClass != null && ASTNodes.isSameVariable((ASTNode)visitedClass.getName(), (ASTNode)qualifier)) {
                    return fieldName.getName();
                }
            }
        }
        if ((superFieldAccess = ASTNodes.as(expression, SuperFieldAccess.class)) != null) {
            if (superFieldAccess.getQualifier() == null) {
                return superFieldAccess.getName();
            }
            if (superFieldAccess.getQualifier().isSimpleName()) {
                qualifier = (SimpleName)superFieldAccess.getQualifier();
                visitedClass = ASTNodes.getTypedAncestor((ASTNode)expression, TypeDeclaration.class);
                if (visitedClass != null && ASTNodes.isSameVariable((ASTNode)visitedClass.getName(), (ASTNode)qualifier)) {
                    return superFieldAccess.getName();
                }
            }
        }
        return null;
    }

    public static boolean isLiteral(Expression expression) {
        int type = expression.getNodeType();
        return type == 9 || type == 13 || type == 33 || type == 34 || type == 45 || type == 57 || type == 102;
    }

    public static boolean isLabel(SimpleName name) {
        int parentType = name.getParent().getNodeType();
        return parentType == 30 || parentType == 10 && name.getLocationInParent() == BreakStatement.LABEL_PROPERTY || parentType != 18;
    }

    public static Set<SimpleName> getLocalVariableIdentifiers(ASTNode node, boolean includeInnerScopes) {
        if (node == null) {
            return Collections.emptySet();
        }
        VarDeclarationIdentifierVisitor visitor = new VarDeclarationIdentifierVisitor(node, includeInnerScopes);
        node.accept((ASTVisitor)visitor);
        return visitor.getVariableNames();
    }

    public static boolean isPassiveWithoutFallingThrough(ASTNode node) {
        ExprActivityVisitor visitor = new ExprActivityVisitor();
        visitor.traverseNodeInterruptibly(node);
        return ExprActivity.PASSIVE_WITHOUT_FALLING_THROUGH.equals((Object)visitor.getActivityLevel());
    }

    public static boolean isStatic(BodyDeclaration declaration) {
        return Modifier.isStatic((int)declaration.getModifiers());
    }

    public static boolean isPassive(ASTNode node) {
        ExprActivityVisitor visitor = new ExprActivityVisitor();
        visitor.traverseNodeInterruptibly(node);
        return ExprActivity.PASSIVE_WITHOUT_FALLING_THROUGH.equals((Object)visitor.getActivityLevel()) || ExprActivity.PASSIVE.equals((Object)visitor.getActivityLevel());
    }

    public static Boolean isStatic(MethodInvocation method) {
        Expression calledType = method.getExpression();
        if (method.resolveMethodBinding() != null) {
            return Modifier.isStatic((int)method.resolveMethodBinding().getModifiers());
        }
        if (calledType instanceof Name && ((Name)calledType).resolveBinding() != null && ((Name)calledType).resolveBinding().getKind() == 2) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static boolean fallsThrough(Statement statement) {
        List<Statement> statements = ASTNodes.asList(statement);
        if (statements.isEmpty()) {
            return false;
        }
        Statement lastStatement = statements.get(statements.size() - 1);
        switch (lastStatement.getNodeType()) {
            case 10: 
            case 18: 
            case 41: 
            case 53: {
                return true;
            }
            case 8: {
                Block block = (Block)lastStatement;
                return ASTNodes.fallsThrough((Statement)block);
            }
            case 25: {
                IfStatement ifStatement = (IfStatement)lastStatement;
                Statement thenStatement = ifStatement.getThenStatement();
                Statement elseStatement = ifStatement.getElseStatement();
                return ASTNodes.fallsThrough(thenStatement) && ASTNodes.fallsThrough(elseStatement);
            }
            case 54: {
                TryStatement tryStatement = (TryStatement)lastStatement;
                if (!ASTNodes.fallsThrough((Statement)tryStatement.getBody()) || tryStatement.getFinally() != null && ASTNodes.fallsThrough((Statement)tryStatement.getFinally())) {
                    return false;
                }
                if (tryStatement.catchClauses() != null) {
                    for (Object catchClause : tryStatement.catchClauses()) {
                        if (ASTNodes.fallsThrough((Statement)((CatchClause)catchClause).getBody())) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static List<BodyDeclaration> getBodyDeclarations(ASTNode node) {
        if (node instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)node).bodyDeclarations();
        }
        if (node instanceof AnonymousClassDeclaration) {
            return ((AnonymousClassDeclaration)node).bodyDeclarations();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static ChildListPropertyDescriptor getBodyDeclarationsProperty(ASTNode node) {
        if (node instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)node).getBodyDeclarationsProperty();
        }
        if (node instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static String getTypeName(Type type) {
        final StringBuilder buffer = new StringBuilder();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(PrimitiveType node) {
                buffer.append(node.getPrimitiveTypeCode().toString());
                return false;
            }

            public boolean visit(SimpleType node) {
                buffer.append(ASTNodes.getSimpleNameIdentifier(node.getName()));
                return false;
            }

            public boolean visit(QualifiedType node) {
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public boolean visit(NameQualifiedType node) {
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public boolean visit(ParameterizedType node) {
                node.getType().accept((ASTVisitor)this);
                return false;
            }

            public void endVisit(ArrayType node) {
                int i = 0;
                while (i < node.dimensions().size()) {
                    buffer.append("[]");
                    ++i;
                }
            }
        };
        type.accept(visitor);
        return buffer.toString();
    }

    public static String getQualifiedTypeName(Type type) {
        final StringBuilder buffer = new StringBuilder();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(SimpleType node) {
                buffer.append(node.getName().getFullyQualifiedName());
                return false;
            }

            public boolean visit(QualifiedType node) {
                node.getQualifier().accept((ASTVisitor)this);
                buffer.append('.');
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public boolean visit(NameQualifiedType node) {
                buffer.append(node.getQualifier().getFullyQualifiedName());
                buffer.append('.');
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public boolean visit(ParameterizedType node) {
                node.getType().accept((ASTVisitor)this);
                return false;
            }

            public void endVisit(ArrayType node) {
                int i = 0;
                while (i < node.dimensions().size()) {
                    buffer.append("[]");
                    ++i;
                }
            }
        };
        type.accept(visitor);
        return buffer.toString();
    }

    public static Boolean getBooleanLiteral(ASTNode node) {
        if (!(node instanceof Expression)) {
            return null;
        }
        Expression expression = (Expression)node;
        BooleanLiteral bl = ASTNodes.as(expression, BooleanLiteral.class);
        if (bl != null) {
            return bl.booleanValue();
        }
        QualifiedName qn = ASTNodes.as(expression, QualifiedName.class);
        if (ASTNodes.hasType((Expression)qn, Boolean.class.getCanonicalName())) {
            return ASTNodes.getBooleanObject(qn);
        }
        return null;
    }

    public static boolean is(Statement statement, Class<? extends Statement> stmtClass) {
        return ASTNodes.as(statement, stmtClass) != null;
    }

    public static boolean is(Expression expression, Class<? extends Expression> exprClass) {
        return ASTNodes.as(expression, exprClass) != null;
    }

    public static <T extends Statement> T as(Statement statement, Class<T> stmtClass) {
        Statement oneStatement;
        if (statement == null) {
            return null;
        }
        List<Statement> statements = ASTNodes.asList(statement);
        if (statements.size() == 1 && stmtClass.isAssignableFrom((oneStatement = statements.get(0)).getClass())) {
            return (T)oneStatement;
        }
        return null;
    }

    public static <T extends Expression> T as(Expression expression, Class<T> exprClass) {
        if (expression != null) {
            if (exprClass.isAssignableFrom(expression.getClass())) {
                return (T)expression;
            }
            if (expression instanceof ParenthesizedExpression) {
                expression = ASTNodes.getUnparenthesedExpression(expression);
                return ASTNodes.as(expression, exprClass);
            }
        }
        return null;
    }

    public static <T extends Expression> T asExpression(Statement statement, Class<T> exprClass) {
        ExpressionStatement es = ASTNodes.as(statement, ExpressionStatement.class);
        if (es != null) {
            return ASTNodes.as(es.getExpression(), exprClass);
        }
        return null;
    }

    public static List<Statement> asList(Statement statement) {
        if (statement == null) {
            return Collections.emptyList();
        }
        if (statement instanceof Block) {
            return ((Block)statement).statements();
        }
        return Arrays.asList(statement);
    }

    public static <F extends Expression, S extends Expression> OrderedInfixExpression<F, S> orderedInfix(Expression node, Class<F> firstClass, Class<S> secondClass) {
        InfixExpression expression = ASTNodes.as(node, InfixExpression.class);
        if (expression == null || expression.hasExtendedOperands()) {
            return null;
        }
        if (firstClass != null && firstClass.equals(secondClass)) {
            F first = ASTNodes.as(expression.getLeftOperand(), firstClass);
            S second = ASTNodes.as(expression.getRightOperand(), secondClass);
            if (first != null && second != null) {
                return new OrderedInfixExpression<F, S>(first, expression.getOperator(), second);
            }
        } else {
            F leftFirst = ASTNodes.as(expression.getLeftOperand(), firstClass);
            S rightSecond = ASTNodes.as(expression.getRightOperand(), secondClass);
            if (leftFirst != null && rightSecond != null) {
                return new OrderedInfixExpression<F, S>(leftFirst, expression.getOperator(), rightSecond);
            }
            InfixExpression.Operator mirroredOperator = ASTNodes.mirrorOperator(expression);
            if (mirroredOperator != null) {
                F rightFirst = ASTNodes.as(expression.getRightOperand(), firstClass);
                S leftSecond = ASTNodes.as(expression.getLeftOperand(), secondClass);
                if (rightFirst != null && leftSecond != null) {
                    return new OrderedInfixExpression<F, S>(rightFirst, mirroredOperator, leftSecond);
                }
            }
        }
        return null;
    }

    private static InfixExpression.Operator mirrorOperator(InfixExpression expression) {
        if (Arrays.asList(InfixExpression.Operator.AND, InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS, InfixExpression.Operator.OR, InfixExpression.Operator.PLUS, InfixExpression.Operator.TIMES, InfixExpression.Operator.XOR).contains(expression.getOperator())) {
            return expression.getOperator();
        }
        if (InfixExpression.Operator.GREATER.equals(expression.getOperator())) {
            return InfixExpression.Operator.LESS;
        }
        if (InfixExpression.Operator.GREATER_EQUALS.equals(expression.getOperator())) {
            return InfixExpression.Operator.LESS_EQUALS;
        }
        if (InfixExpression.Operator.LESS.equals(expression.getOperator())) {
            return InfixExpression.Operator.GREATER;
        }
        if (InfixExpression.Operator.LESS_EQUALS.equals(expression.getOperator())) {
            return InfixExpression.Operator.GREATER_EQUALS;
        }
        return null;
    }

    public static boolean isCastCompatible(Expression expr1, Expression expr2) {
        ITypeBinding tb1 = expr1.resolveTypeBinding();
        ITypeBinding tb2 = expr2.resolveTypeBinding();
        return tb1 != null && tb2 != null && tb1.isCastCompatible(tb2);
    }

    public static boolean isInElse(IfStatement node) {
        if (node == null) {
            return false;
        }
        ASTNode parent = node.getParent();
        if (parent instanceof IfStatement) {
            IfStatement is = (IfStatement)parent;
            return node.equals((Object)is.getElseStatement());
        }
        return false;
    }

    public static List<Expression> allOperands(InfixExpression node) {
        List extOps = node.extendedOperands();
        ArrayList<Expression> operands = new ArrayList<Expression>(2 + extOps.size());
        operands.add(node.getLeftOperand());
        operands.add(node.getRightOperand());
        operands.addAll(extOps);
        ArrayList<Expression> optimizedOperands = new ArrayList<Expression>();
        for (Expression expression : operands) {
            if (expression instanceof InfixExpression && ASTNodes.hasOperator((InfixExpression)expression, node.getOperator(), new InfixExpression.Operator[0])) {
                optimizedOperands.addAll(ASTNodes.allOperands((InfixExpression)expression));
                continue;
            }
            optimizedOperands.add(expression);
        }
        return optimizedOperands;
    }

    public static boolean hasVariableConflict(Statement node, Statement statementInBlock) {
        Set<SimpleName> existingVariableNames = ASTNodes.getLocalVariableIdentifiers((ASTNode)statementInBlock, false);
        for (Statement statement : ASTNodes.getNextSiblings(node)) {
            VarConflictVisitor varOccurrenceVisitor = new VarConflictVisitor(existingVariableNames, true);
            varOccurrenceVisitor.traverseNodeInterruptibly((ASTNode)statement);
            if (!varOccurrenceVisitor.isVarConflicting()) continue;
            return true;
        }
        return false;
    }

    public static int getNbOperands(Expression node) {
        InfixExpression infixExpression = ASTNodes.as(node, InfixExpression.class);
        if (!(infixExpression != null && (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.CONDITIONAL_OR) || ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.AND, InfixExpression.Operator.OR, InfixExpression.Operator.XOR) && ASTNodes.hasType(infixExpression.getLeftOperand(), Boolean.TYPE.getCanonicalName(), Boolean.class.getCanonicalName())))) {
            return 1;
        }
        int nbOperands = 0;
        for (Expression operand : ASTNodes.allOperands(infixExpression)) {
            nbOperands += ASTNodes.getNbOperands(operand);
        }
        return nbOperands;
    }

    public static Boolean getBooleanObject(QualifiedName qualifiedName) {
        String fqn = qualifiedName.getFullyQualifiedName();
        if ("Boolean.TRUE".equals(fqn)) {
            return Boolean.TRUE;
        }
        if ("Boolean.FALSE".equals(fqn)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static ITypeBinding resolveTypeBinding(VariableDeclaration varDecl) {
        IVariableBinding varBinding;
        if (varDecl != null && (varBinding = varDecl.resolveBinding()) != null) {
            return varBinding.getType();
        }
        return null;
    }

    public static boolean hasOperator(Assignment node, Assignment.Operator expectedOperator, Assignment.Operator ... additionalExpectedOperators) {
        return node != null && ASTNodes.isOperatorInList(node.getOperator(), expectedOperator, additionalExpectedOperators);
    }

    public static boolean hasOperator(InfixExpression node, InfixExpression.Operator expectedOperator, InfixExpression.Operator ... additionalExpectedOperators) {
        return node != null && ASTNodes.isOperatorInList(node.getOperator(), expectedOperator, additionalExpectedOperators);
    }

    public static boolean hasOperator(PrefixExpression node, PrefixExpression.Operator expectedOperator, PrefixExpression.Operator ... additionalExpectedOperators) {
        return node != null && ASTNodes.isOperatorInList(node.getOperator(), expectedOperator, additionalExpectedOperators);
    }

    public static boolean hasOperator(PostfixExpression node, PostfixExpression.Operator expectedOperator, PostfixExpression.Operator ... additionalExpectedOperators) {
        return node != null && ASTNodes.isOperatorInList(node.getOperator(), expectedOperator, additionalExpectedOperators);
    }

    private static <O> boolean isOperatorInList(O actualOperator, O expectedOperator, O[] additionalExpectedOperators) {
        return actualOperator != null && (actualOperator.equals(expectedOperator) || Arrays.asList(additionalExpectedOperators).contains(actualOperator));
    }

    public static boolean hasType(Expression expression, String ... oneOfQualifiedTypeNames) {
        return expression != null && ASTNodes.hasType(expression.resolveTypeBinding(), oneOfQualifiedTypeNames);
    }

    public static boolean hasType(ITypeBinding typeBinding, String ... oneOfQualifiedTypeNames) {
        if (typeBinding != null) {
            String qualifiedName = typeBinding.getErasure().getQualifiedName();
            String[] stringArray = oneOfQualifiedTypeNames;
            int n = oneOfQualifiedTypeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String qualifiedTypeName = stringArray[n2];
                if (qualifiedTypeName.equals(qualifiedName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static InfixExpression.Operator negatedInfixOperator(InfixExpression.Operator operator) {
        if (InfixExpression.Operator.LESS.equals(operator)) {
            return InfixExpression.Operator.GREATER_EQUALS;
        }
        if (InfixExpression.Operator.LESS_EQUALS.equals(operator)) {
            return InfixExpression.Operator.GREATER;
        }
        if (InfixExpression.Operator.GREATER.equals(operator)) {
            return InfixExpression.Operator.LESS_EQUALS;
        }
        if (InfixExpression.Operator.GREATER_EQUALS.equals(operator)) {
            return InfixExpression.Operator.LESS;
        }
        if (InfixExpression.Operator.EQUALS.equals(operator)) {
            return InfixExpression.Operator.NOT_EQUALS;
        }
        if (InfixExpression.Operator.NOT_EQUALS.equals(operator)) {
            return InfixExpression.Operator.EQUALS;
        }
        if (InfixExpression.Operator.CONDITIONAL_AND.equals(operator)) {
            return InfixExpression.Operator.CONDITIONAL_OR;
        }
        if (InfixExpression.Operator.CONDITIONAL_OR.equals(operator)) {
            return InfixExpression.Operator.CONDITIONAL_AND;
        }
        return null;
    }

    public static InfixExpression.Operator convertToInfixOperator(Assignment.Operator operator) {
        if (operator.equals(Assignment.Operator.PLUS_ASSIGN)) {
            return InfixExpression.Operator.PLUS;
        }
        if (operator.equals(Assignment.Operator.MINUS_ASSIGN)) {
            return InfixExpression.Operator.MINUS;
        }
        if (operator.equals(Assignment.Operator.TIMES_ASSIGN)) {
            return InfixExpression.Operator.TIMES;
        }
        if (operator.equals(Assignment.Operator.DIVIDE_ASSIGN)) {
            return InfixExpression.Operator.DIVIDE;
        }
        if (operator.equals(Assignment.Operator.BIT_AND_ASSIGN)) {
            return InfixExpression.Operator.AND;
        }
        if (operator.equals(Assignment.Operator.BIT_OR_ASSIGN)) {
            return InfixExpression.Operator.OR;
        }
        if (operator.equals(Assignment.Operator.BIT_XOR_ASSIGN)) {
            return InfixExpression.Operator.XOR;
        }
        if (operator.equals(Assignment.Operator.REMAINDER_ASSIGN)) {
            return InfixExpression.Operator.REMAINDER;
        }
        if (operator.equals(Assignment.Operator.LEFT_SHIFT_ASSIGN)) {
            return InfixExpression.Operator.LEFT_SHIFT;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
        }
        Assert.isTrue((boolean)false, (String)"Cannot convert assignment operator");
        return null;
    }

    public static boolean isControlStatementBody(StructuralPropertyDescriptor locationInParent) {
        return locationInParent == IfStatement.THEN_STATEMENT_PROPERTY || locationInParent == IfStatement.ELSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == EnhancedForStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY;
    }

    public static ITypeBinding getExplicitCast(Expression initializer, Expression reference) {
        ITypeBinding initializerType = initializer.resolveTypeBinding();
        ITypeBinding referenceType = reference.resolveTypeBinding();
        if (initializerType == null || referenceType == null) {
            return null;
        }
        if (initializerType.isPrimitive() && referenceType.isPrimitive() && !referenceType.isEqualTo((IBinding)initializerType)) {
            return referenceType;
        }
        if (initializerType.isPrimitive() && !referenceType.isPrimitive()) {
            ITypeBinding unboxedReferenceType = Bindings.getUnboxedTypeBinding(referenceType, reference.getAST());
            if (!unboxedReferenceType.isEqualTo((IBinding)initializerType)) {
                return unboxedReferenceType;
            }
            if (ASTNodes.needsExplicitBoxing(reference)) {
                return referenceType;
            }
        } else if (!initializerType.isPrimitive() && referenceType.isPrimitive()) {
            ITypeBinding unboxedInitializerType = Bindings.getUnboxedTypeBinding(initializerType, reference.getAST());
            if (!unboxedInitializerType.isEqualTo((IBinding)referenceType)) {
                return referenceType;
            }
        } else {
            if (initializerType.isRawType() && referenceType.isParameterizedType()) {
                return referenceType;
            }
            if (initializer instanceof LambdaExpression || initializer instanceof MethodReference) {
                if (ASTNodes.isTargetAmbiguous(reference, ASTNodes.isExplicitlyTypedLambda(initializer))) {
                    return referenceType;
                }
                ITypeBinding targetType = ASTNodes.getTargetType(reference);
                if (targetType == null || targetType != referenceType) {
                    return referenceType;
                }
            } else if (!TypeRules.canAssign(initializerType, referenceType) ? !Bindings.containsTypeVariables(referenceType) : !initializerType.isEqualTo((IBinding)referenceType) && ASTNodes.isTargetAmbiguous(reference, initializerType)) {
                return referenceType;
            }
        }
        return null;
    }

    public static boolean isTargetAmbiguous(Expression expression, boolean expressionIsExplicitlyTyped) {
        ITypeBinding invocationTargetType;
        ParentSummary targetSummary = ASTNodes.getParentSummary(expression);
        if (targetSummary == null) {
            return false;
        }
        if (targetSummary.methodBinding != null && (invocationTargetType = ASTNodes.getInvocationType(expression.getParent(), targetSummary.methodBinding, targetSummary.invocationQualifier)) != null) {
            FunctionalInterfaceAmbiguousMethodAnalyzer visitor = new FunctionalInterfaceAmbiguousMethodAnalyzer(invocationTargetType, targetSummary.methodBinding, targetSummary.argumentIndex, targetSummary.argumentCount, expressionIsExplicitlyTyped);
            return !visitor.visit(invocationTargetType) || !Bindings.visitHierarchy(invocationTargetType, visitor);
        }
        return true;
    }

    public static boolean isTargetAmbiguous(Expression expression, ITypeBinding initializerType) {
        ParentSummary parentSummary = ASTNodes.getParentSummary(expression);
        if (parentSummary == null) {
            return false;
        }
        IMethodBinding methodBinding = parentSummary.methodBinding;
        if (methodBinding != null) {
            ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
            int argumentIndex = parentSummary.argumentIndex;
            if (methodBinding.isVarargs() && argumentIndex >= parameterTypes.length - 1) {
                argumentIndex = parameterTypes.length - 1;
                initializerType = initializerType.createArrayType(1);
            }
            parameterTypes[argumentIndex] = initializerType;
            ITypeBinding invocationType = ASTNodes.getInvocationType(expression.getParent(), methodBinding, parentSummary.invocationQualifier);
            if (invocationType != null) {
                TypeEnvironment typeEnvironment = new TypeEnvironment();
                AmbiguousMethodAnalyzer visitor = new AmbiguousMethodAnalyzer(typeEnvironment, methodBinding, typeEnvironment.create(parameterTypes));
                if (!visitor.visit(invocationType)) {
                    return true;
                }
                if (invocationType.isInterface()) {
                    return !Bindings.visitInterfaces(invocationType, visitor);
                }
                if (Modifier.isAbstract((int)invocationType.getModifiers())) {
                    return !Bindings.visitHierarchy(invocationType, visitor);
                }
                return !Bindings.visitSuperclasses(invocationType, visitor);
            }
        }
        return true;
    }

    private static ParentSummary getParentSummary(Expression expression) {
        int argumentCount;
        int argumentIndex;
        IMethodBinding methodBinding;
        StructuralPropertyDescriptor locationInParent = expression.getLocationInParent();
        while (locationInParent == ParenthesizedExpression.EXPRESSION_PROPERTY || locationInParent == ConditionalExpression.THEN_EXPRESSION_PROPERTY || locationInParent == ConditionalExpression.ELSE_EXPRESSION_PROPERTY) {
            expression = (Expression)expression.getParent();
            locationInParent = expression.getLocationInParent();
        }
        ASTNode parent = expression.getParent();
        Expression invocationQualifier = null;
        if (locationInParent == MethodInvocation.ARGUMENTS_PROPERTY) {
            MethodInvocation methodInvocation = (MethodInvocation)parent;
            methodBinding = methodInvocation.resolveMethodBinding();
            argumentIndex = methodInvocation.arguments().indexOf(expression);
            argumentCount = methodInvocation.arguments().size();
            invocationQualifier = methodInvocation.getExpression();
        } else if (locationInParent == SuperMethodInvocation.ARGUMENTS_PROPERTY) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)parent;
            methodBinding = superMethodInvocation.resolveMethodBinding();
            argumentIndex = superMethodInvocation.arguments().indexOf(expression);
            argumentCount = superMethodInvocation.arguments().size();
            invocationQualifier = superMethodInvocation.getQualifier();
        } else if (locationInParent == ConstructorInvocation.ARGUMENTS_PROPERTY) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)parent;
            methodBinding = constructorInvocation.resolveConstructorBinding();
            argumentIndex = constructorInvocation.arguments().indexOf(expression);
            argumentCount = constructorInvocation.arguments().size();
        } else if (locationInParent == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)parent;
            methodBinding = superConstructorInvocation.resolveConstructorBinding();
            argumentIndex = superConstructorInvocation.arguments().indexOf(expression);
            argumentCount = superConstructorInvocation.arguments().size();
        } else if (locationInParent == ClassInstanceCreation.ARGUMENTS_PROPERTY) {
            ClassInstanceCreation creation = (ClassInstanceCreation)parent;
            methodBinding = creation.resolveConstructorBinding();
            argumentIndex = creation.arguments().indexOf(expression);
            argumentCount = creation.arguments().size();
        } else if (locationInParent == EnumConstantDeclaration.ARGUMENTS_PROPERTY) {
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)parent;
            methodBinding = enumConstantDecl.resolveConstructorBinding();
            argumentIndex = enumConstantDecl.arguments().indexOf(expression);
            argumentCount = enumConstantDecl.arguments().size();
        } else {
            return null;
        }
        return new ParentSummary(methodBinding, argumentIndex, argumentCount, invocationQualifier);
    }

    public static ITypeBinding getInvocationType(ASTNode invocationNode, IMethodBinding methodBinding, Expression invocationQualifier) {
        ITypeBinding invocationType;
        if (invocationNode instanceof MethodInvocation || invocationNode instanceof SuperMethodInvocation) {
            if (invocationQualifier != null) {
                invocationType = invocationQualifier.resolveTypeBinding();
                if (invocationType != null && invocationNode instanceof SuperMethodInvocation) {
                    invocationType = invocationType.getSuperclass();
                }
            } else {
                IMethodBinding methodInHierarchy;
                ITypeBinding enclosingType = ASTNodes.getEnclosingType(invocationNode);
                if (enclosingType != null && invocationNode instanceof SuperMethodInvocation) {
                    enclosingType = enclosingType.getSuperclass();
                }
                invocationType = enclosingType != null ? ((methodInHierarchy = Bindings.findMethodInHierarchy(enclosingType, methodBinding.getName(), methodBinding.getParameterTypes())) != null ? enclosingType : methodBinding.getDeclaringClass()) : methodBinding.getDeclaringClass();
            }
        } else {
            invocationType = methodBinding.getDeclaringClass();
        }
        return invocationType;
    }

    public static ITypeBinding getTargetType(Expression expression) {
        ASTNode parent = expression.getParent();
        StructuralPropertyDescriptor locationInParent = expression.getLocationInParent();
        if (locationInParent == VariableDeclarationFragment.INITIALIZER_PROPERTY || locationInParent == SingleVariableDeclaration.INITIALIZER_PROPERTY) {
            return ((VariableDeclaration)parent).getName().resolveTypeBinding();
        }
        if (locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY) {
            return ((Assignment)parent).getLeftHandSide().resolveTypeBinding();
        }
        if (locationInParent == ReturnStatement.EXPRESSION_PROPERTY) {
            return ASTNodes.getTargetTypeForReturnStmt((ReturnStatement)parent);
        }
        if (locationInParent == ArrayInitializer.EXPRESSIONS_PROPERTY) {
            return ASTNodes.getTargetTypeForArrayInitializer((ArrayInitializer)parent);
        }
        if (locationInParent == ArrayAccess.INDEX_PROPERTY) {
            return parent.getAST().resolveWellKnownType(Integer.TYPE.getSimpleName());
        }
        if (locationInParent == ConditionalExpression.EXPRESSION_PROPERTY || locationInParent == IfStatement.EXPRESSION_PROPERTY || locationInParent == WhileStatement.EXPRESSION_PROPERTY || locationInParent == DoStatement.EXPRESSION_PROPERTY) {
            return parent.getAST().resolveWellKnownType(Boolean.TYPE.getSimpleName());
        }
        if (locationInParent == SwitchStatement.EXPRESSION_PROPERTY) {
            ITypeBinding discriminentType = expression.resolveTypeBinding();
            if (discriminentType == null) {
                return null;
            }
            if (discriminentType.isPrimitive() || discriminentType.isEnum() || discriminentType.getQualifiedName().equals(String.class.getCanonicalName())) {
                return discriminentType;
            }
            return Bindings.getUnboxedTypeBinding(discriminentType, parent.getAST());
        }
        if (locationInParent == MethodInvocation.ARGUMENTS_PROPERTY) {
            MethodInvocation methodInvocation = (MethodInvocation)parent;
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            if (methodBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, methodInvocation.arguments(), methodBinding);
            }
        } else if (locationInParent == SuperMethodInvocation.ARGUMENTS_PROPERTY) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)parent;
            IMethodBinding superMethodBinding = superMethodInvocation.resolveMethodBinding();
            if (superMethodBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, superMethodInvocation.arguments(), superMethodBinding);
            }
        } else if (locationInParent == ConstructorInvocation.ARGUMENTS_PROPERTY) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)parent;
            IMethodBinding constructorBinding = constructorInvocation.resolveConstructorBinding();
            if (constructorBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, constructorInvocation.arguments(), constructorBinding);
            }
        } else if (locationInParent == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)parent;
            IMethodBinding superConstructorBinding = superConstructorInvocation.resolveConstructorBinding();
            if (superConstructorBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, superConstructorInvocation.arguments(), superConstructorBinding);
            }
        } else if (locationInParent == ClassInstanceCreation.ARGUMENTS_PROPERTY) {
            ClassInstanceCreation creation = (ClassInstanceCreation)parent;
            IMethodBinding creationBinding = creation.resolveConstructorBinding();
            if (creationBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, creation.arguments(), creationBinding);
            }
        } else if (locationInParent == EnumConstantDeclaration.ARGUMENTS_PROPERTY) {
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)parent;
            IMethodBinding enumConstructorBinding = enumConstantDecl.resolveConstructorBinding();
            if (enumConstructorBinding != null) {
                return ASTNodes.getParameterTypeBinding(expression, enumConstantDecl.arguments(), enumConstructorBinding);
            }
        } else if (locationInParent == LambdaExpression.BODY_PROPERTY) {
            IMethodBinding methodBinding = ((LambdaExpression)parent).resolveMethodBinding();
            if (methodBinding != null) {
                return methodBinding.getReturnType();
            }
        } else {
            if (locationInParent == ConditionalExpression.THEN_EXPRESSION_PROPERTY || locationInParent == ConditionalExpression.ELSE_EXPRESSION_PROPERTY) {
                return ASTNodes.getTargetType((Expression)((ConditionalExpression)parent));
            }
            if (locationInParent == CastExpression.EXPRESSION_PROPERTY) {
                return ((CastExpression)parent).getType().resolveBinding();
            }
            if (locationInParent == ParenthesizedExpression.EXPRESSION_PROPERTY) {
                return ASTNodes.getTargetType((Expression)((ParenthesizedExpression)parent));
            }
        }
        return null;
    }

    private static ITypeBinding getParameterTypeBinding(Expression expression, List<Expression> arguments, IMethodBinding methodBinding) {
        int index = arguments.indexOf(expression);
        return ASTResolving.getParameterTypeBinding(methodBinding, index);
    }

    private static ITypeBinding getTargetTypeForArrayInitializer(ArrayInitializer arrayInitializer) {
        ITypeBinding typeBinding;
        ASTNode initializerParent = arrayInitializer.getParent();
        while (initializerParent instanceof ArrayInitializer) {
            initializerParent = initializerParent.getParent();
        }
        if (initializerParent instanceof ArrayCreation) {
            return ((ArrayCreation)initializerParent).getType().getElementType().resolveBinding();
        }
        if (initializerParent instanceof VariableDeclaration && (typeBinding = ((VariableDeclaration)initializerParent).getName().resolveTypeBinding()) != null) {
            return typeBinding.getElementType();
        }
        return null;
    }

    private static ITypeBinding getTargetTypeForReturnStmt(ReturnStatement returnStmt) {
        LambdaExpression enclosingLambdaExpr = ASTResolving.findEnclosingLambdaExpression((ASTNode)returnStmt);
        if (enclosingLambdaExpr != null) {
            IMethodBinding methodBinding = enclosingLambdaExpr.resolveMethodBinding();
            return methodBinding == null ? null : methodBinding.getReturnType();
        }
        MethodDeclaration enclosingMethodDecl = ASTResolving.findParentMethodDeclaration((ASTNode)returnStmt);
        if (enclosingMethodDecl != null) {
            IMethodBinding methodBinding = enclosingMethodDecl.resolveBinding();
            return methodBinding == null ? null : methodBinding.getReturnType();
        }
        return null;
    }

    private static Statement statementAtLevel(Statement node) {
        ASTNode parent = node.getParent();
        if (parent instanceof LabeledStatement) {
            return ASTNodes.statementAtLevel((Statement)((LabeledStatement)parent));
        }
        return node;
    }

    public static boolean canHaveSiblings(Statement node) {
        Statement statementAtLevel = ASTNodes.statementAtLevel(node);
        ASTNode parent = statementAtLevel.getParent();
        return parent instanceof Block || parent instanceof SwitchStatement && statementAtLevel.getLocationInParent() == SwitchStatement.STATEMENTS_PROPERTY;
    }

    public static Statement getPreviousSibling(Statement startNode) {
        List<Statement> siblings = ASTNodes.getSiblings(startNode, false);
        if (siblings.isEmpty()) {
            return null;
        }
        return siblings.get(siblings.size() - 1);
    }

    public static Statement getPreviousStatement(Statement startNode) {
        Statement previousSibling = ASTNodes.getPreviousSibling(startNode);
        if (previousSibling != null) {
            return previousSibling;
        }
        ASTNode parent = startNode.getParent();
        if (parent instanceof Statement) {
            return ASTNodes.getPreviousStatement((Statement)parent);
        }
        return null;
    }

    public static List<Statement> getPreviousSiblings(Statement startNode) {
        return ASTNodes.getSiblings(startNode, false);
    }

    private static List<Statement> getSiblings(Statement startNode, boolean isForward) {
        List<Statement> statements;
        int indexOfNode;
        int siblingIndex;
        Statement statementAtLevel = ASTNodes.statementAtLevel(startNode);
        if (ASTNodes.canHaveSiblings(statementAtLevel) && (siblingIndex = (indexOfNode = (statements = statementAtLevel.getParent() instanceof SwitchStatement ? ((SwitchStatement)statementAtLevel.getParent()).statements() : ASTNodes.asList((Statement)statementAtLevel.getParent())).indexOf(statementAtLevel)) + (isForward ? 1 : -1)) >= 0 && siblingIndex < statements.size()) {
            if (isForward) {
                return statements.subList(siblingIndex, statements.size());
            }
            return statements.subList(0, siblingIndex + 1);
        }
        return Collections.emptyList();
    }

    public static Statement getNextStatement(Statement startNode) {
        Statement nextSibling = ASTNodes.getNextSibling(startNode);
        if (nextSibling != null) {
            return nextSibling;
        }
        ASTNode parent = startNode.getParent();
        if (parent instanceof Statement) {
            return ASTNodes.getNextStatement((Statement)parent);
        }
        return null;
    }

    public static Statement getNextSibling(Statement startNode) {
        List<Statement> siblings = ASTNodes.getSiblings(startNode, true);
        if (siblings.isEmpty()) {
            return null;
        }
        return siblings.get(0);
    }

    public static List<Statement> getNextSiblings(Statement startNode) {
        return ASTNodes.getSiblings(startNode, true);
    }

    private static boolean needsExplicitBoxing(Expression expression) {
        StructuralPropertyDescriptor locationInParent = expression.getLocationInParent();
        if (locationInParent == ParenthesizedExpression.EXPRESSION_PROPERTY) {
            return ASTNodes.needsExplicitBoxing((Expression)((ParenthesizedExpression)expression.getParent()));
        }
        return locationInParent == ClassInstanceCreation.EXPRESSION_PROPERTY || locationInParent == FieldAccess.EXPRESSION_PROPERTY || locationInParent == MethodInvocation.EXPRESSION_PROPERTY;
    }

    public static boolean isExplicitlyTypedLambda(Expression expression) {
        if (!(expression instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression lambda = (LambdaExpression)expression;
        List parameters = lambda.parameters();
        if (parameters.isEmpty()) {
            return true;
        }
        return parameters.get(0) instanceof SingleVariableDeclaration;
    }

    public static <T extends ASTNode> T getTypedAncestor(ASTNode node, Class<T> ancestorClass) {
        if (node == null || node.getParent() == null) {
            return null;
        }
        ASTNode parent = node.getParent();
        if (ancestorClass.isAssignableFrom(parent.getClass())) {
            return (T)parent;
        }
        return ASTNodes.getTypedAncestor(parent, ancestorClass);
    }

    @SafeVarargs
    public static ASTNode getFirstAncestorOrNull(ASTNode node, Class<? extends ASTNode> ancestorClass, Class<? extends ASTNode> ... ancestorClasses) {
        if (node == null || node.getParent() == null) {
            return null;
        }
        ASTNode parent = node.getParent();
        if (ancestorClass.isAssignableFrom(parent.getClass()) || ASTNodes.instanceOf(parent, ancestorClasses)) {
            return parent;
        }
        return ASTNodes.getFirstAncestorOrNull(parent, ancestorClass, ancestorClasses);
    }

    public static <T extends ASTNode> T getFirstAncestorOrNull(ASTNode node, Class<T> ancestorClass) {
        if (node == null || node.getParent() == null) {
            return null;
        }
        ASTNode parent = node.getParent();
        if (ancestorClass.isAssignableFrom(parent.getClass())) {
            return (T)parent;
        }
        return ASTNodes.getFirstAncestorOrNull(parent, ancestorClass);
    }

    public static <T extends ASTNode> T getParent(ASTNode node, Class<T> parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return (T)((ASTNode)parentClass.cast(node));
    }

    public static AbstractTypeDeclaration getTopLevelTypeDeclaration(ASTNode node) {
        AbstractTypeDeclaration result = null;
        if (node instanceof AbstractTypeDeclaration) {
            result = (AbstractTypeDeclaration)node;
        }
        ASTNode parent = node.getParent();
        while (parent != null) {
            if (parent instanceof AbstractTypeDeclaration) {
                result = (AbstractTypeDeclaration)parent;
            }
            parent = parent.getParent();
        }
        return result;
    }

    public static ASTNode getParent(ASTNode node, int nodeType) {
        while ((node = node.getParent()) != null && node.getNodeType() != nodeType) {
        }
        return node;
    }

    public static ASTNode findParent(ASTNode node, StructuralPropertyDescriptor[][] pathes) {
        StructuralPropertyDescriptor[][] structuralPropertyDescriptorArray = pathes;
        int n = pathes.length;
        int n2 = 0;
        while (n2 < n) {
            StructuralPropertyDescriptor[] path = structuralPropertyDescriptorArray[n2];
            ASTNode current = node;
            int d = path.length - 1;
            while (d >= 0 && current != null) {
                StructuralPropertyDescriptor descriptor = path[d];
                if (!descriptor.equals(current.getLocationInParent())) break;
                current = current.getParent();
                --d;
            }
            if (d < 0) {
                return current;
            }
            ++n2;
        }
        return null;
    }

    @SafeVarargs
    public static ASTNode getHighestCompatibleNode(ASTNode node, Class<? extends ASTNode> ... compatibleClasses) {
        ASTNode parent = node.getParent();
        if (ASTNodes.instanceOf(parent, compatibleClasses)) {
            return ASTNodes.getHighestCompatibleNode(parent, compatibleClasses);
        }
        return node;
    }

    @SafeVarargs
    private static boolean instanceOf(ASTNode node, Class<? extends ASTNode> ... classes) {
        if (node == null) {
            return false;
        }
        Class<? extends ASTNode>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends ASTNode> clazz = classArray[n2];
            if (clazz.isAssignableFrom(node.getClass())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ASTNode getNormalizedNode(ASTNode node) {
        ASTNode current = node;
        if (QualifiedName.NAME_PROPERTY.equals(current.getLocationInParent())) {
            current = current.getParent();
        }
        if (QualifiedType.NAME_PROPERTY.equals(current.getLocationInParent()) || SimpleType.NAME_PROPERTY.equals(current.getLocationInParent()) || NameQualifiedType.NAME_PROPERTY.equals(current.getLocationInParent())) {
            current = current.getParent();
        }
        if (ParameterizedType.TYPE_PROPERTY.equals(current.getLocationInParent())) {
            current = current.getParent();
        }
        return current;
    }

    public static Set<IMethodBinding> getOverridenMethods(IMethodBinding overridingMethod) {
        HashSet<IMethodBinding> results = new HashSet<IMethodBinding>();
        ASTNodes.findOverridenMethods(overridingMethod, results, overridingMethod.getDeclaringClass());
        return results;
    }

    private static void findOverridenMethods(IMethodBinding overridingMethod, Set<IMethodBinding> results, ITypeBinding declaringClass) {
        ITypeBinding superclass = declaringClass.getSuperclass();
        if (superclass != null && !ASTNodes.addOverridenMethods(overridingMethod, superclass, results)) {
            ASTNodes.findOverridenMethods(overridingMethod, results, superclass);
        }
        ITypeBinding[] iTypeBindingArray = declaringClass.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding itf = iTypeBindingArray[n2];
            if (!ASTNodes.addOverridenMethods(overridingMethod, itf, results)) {
                ASTNodes.findOverridenMethods(overridingMethod, results, itf);
            }
            ++n2;
        }
    }

    private static boolean addOverridenMethods(IMethodBinding overridingMethod, ITypeBinding superType, Set<IMethodBinding> results) {
        IMethodBinding[] iMethodBindingArray = superType.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodFromType = iMethodBindingArray[n2];
            if (overridingMethod.overrides(methodFromType) && !results.add(methodFromType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Expression getNullCheckedExpression(Expression expression) {
        InfixExpression infixExpression = ASTNodes.as(expression, InfixExpression.class);
        if (infixExpression != null && !infixExpression.hasExtendedOperands() && ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.NOT_EQUALS, new InfixExpression.Operator[0])) {
            if (ASTNodes.is(infixExpression.getRightOperand(), NullLiteral.class)) {
                return infixExpression.getLeftOperand();
            }
            if (ASTNodes.is(infixExpression.getLeftOperand(), NullLiteral.class)) {
                return infixExpression.getRightOperand();
            }
        }
        return null;
    }

    public static VariableDeclarationFragment getUniqueFragment(Statement node) {
        VariableDeclarationStatement statement = ASTNodes.as(node, VariableDeclarationStatement.class);
        if (statement == null) {
            return null;
        }
        List fragments = statement.fragments();
        return fragments.size() == 1 ? (VariableDeclarationFragment)fragments.get(0) : null;
    }

    public static ASTNode getUnparenthesedExpression(ASTNode node) {
        if (node instanceof Expression) {
            return ASTNodes.getUnparenthesedExpression((Expression)node);
        }
        return node;
    }

    public static Expression getUnparenthesedExpression(Expression expression) {
        while (expression != null && expression.getNodeType() == 36) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        return expression;
    }

    public static boolean isParent(ASTNode node, ASTNode parent) {
        Assert.isNotNull((Object)parent);
        do {
            if ((node = node.getParent()) != parent) continue;
            return true;
        } while (node != null);
        return false;
    }

    public static boolean isLocalVariable(IBinding binding) {
        if (binding != null && binding.getKind() == 3) {
            IVariableBinding bnd = (IVariableBinding)binding;
            return !bnd.isField() && !bnd.isEnumConstant();
        }
        return false;
    }

    public static boolean isSameLocalVariable(IBinding binding, Expression expression) {
        return ASTNodes.isLocalVariable(binding) && expression != null && expression.getNodeType() == 42 && binding.equals((Object)((SimpleName)expression).resolveBinding());
    }

    public static boolean isSameLocalVariable(Expression expr1, Expression expr2) {
        return expr1 != null && expr1.getNodeType() == 42 && ASTNodes.isSameLocalVariable(((SimpleName)expr1).resolveBinding(), expr2);
    }

    public static boolean isSameLocalVariable(VariableDeclaration varDecl, Expression expression) {
        return varDecl != null && ASTNodes.isSameLocalVariable((IBinding)varDecl.resolveBinding(), expression);
    }

    private static boolean areVariableBindingsEqual(ASTNode node1, ASTNode node2) {
        return ASTNodes.areBindingsEqual(ASTNodes.varBinding(node1), ASTNodes.varBinding(node2));
    }

    public static boolean areBindingsEqual(IBinding ast1, IBinding ast2) {
        return ast1 != null && ast2 != null && ast1.isEqualTo(ast2);
    }

    private static IBinding varBinding(ASTNode node) {
        switch (node.getNodeType()) {
            case 52: {
                return ((ThisExpression)node).resolveTypeBinding();
            }
            case 22: {
                return ((FieldAccess)node).resolveFieldBinding();
            }
            case 40: 
            case 42: {
                return ((Name)node).resolveBinding();
            }
            case 44: 
            case 59: {
                return ((VariableDeclaration)node).resolveBinding();
            }
        }
        return null;
    }

    public static boolean isSameVariable(SimpleName name1, QualifiedName name2) {
        return false;
    }

    public static boolean isSameVariable(SimpleName name1, FieldAccess field2) {
        return ASTNodes.as(field2.getExpression(), ThisExpression.class) != null && ASTNodes.areVariableBindingsEqual((ASTNode)field2, (ASTNode)name1);
    }

    public static boolean isSameVariable(QualifiedName name1, QualifiedName name2) {
        return ASTNodes.areVariableBindingsEqual((ASTNode)name1, (ASTNode)name2) && ASTNodes.isSameVariable((ASTNode)name1.getQualifier(), (ASTNode)name2.getQualifier());
    }

    public static boolean isSameVariable(QualifiedName name1, FieldAccess field2) {
        return ASTNodes.areVariableBindingsEqual((ASTNode)name1, (ASTNode)field2) && ASTNodes.isSameVariable((ASTNode)field2.getExpression(), (ASTNode)name1.getQualifier());
    }

    public static boolean isSameVariable(FieldAccess field1, FieldAccess field2) {
        return ASTNodes.areVariableBindingsEqual((ASTNode)field1, (ASTNode)field2) && ASTNodes.isSameVariable((ASTNode)field1.getExpression(), (ASTNode)field2.getExpression());
    }

    public static boolean areSameVariables(ASTNode node0, ASTNode ... otherNodes) {
        ASTNode[] aSTNodeArray = otherNodes;
        int n = otherNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode nodeN = aSTNodeArray[n2];
            if (!ASTNodes.isSameVariable(node0, nodeN)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isSameVariable(ASTNode node1, ASTNode node2) {
        node1 = ASTNodes.getUnparenthesedExpression(node1);
        node2 = ASTNodes.getUnparenthesedExpression(node2);
        if (node1 == null || node2 == null) {
            return false;
        }
        switch (node1.getNodeType()) {
            case 52: {
                return node2.getNodeType() == 52;
            }
            case 42: {
                SimpleName sn = (SimpleName)node1;
                switch (node2.getNodeType()) {
                    case 40: {
                        return ASTNodes.isSameVariable(sn, (QualifiedName)node2);
                    }
                    case 22: {
                        return ASTNodes.isSameVariable(sn, (FieldAccess)node2);
                    }
                }
                break;
            }
            case 40: {
                QualifiedName qn = (QualifiedName)node1;
                switch (node2.getNodeType()) {
                    case 42: {
                        return ASTNodes.isSameVariable((SimpleName)node2, qn);
                    }
                    case 40: {
                        return ASTNodes.isSameVariable(qn, (QualifiedName)node2);
                    }
                    case 22: {
                        return ASTNodes.isSameVariable(qn, (FieldAccess)node2);
                    }
                }
                break;
            }
            case 22: {
                FieldAccess fa = (FieldAccess)node1;
                switch (node2.getNodeType()) {
                    case 42: {
                        return ASTNodes.isSameVariable((SimpleName)node2, fa);
                    }
                    case 40: {
                        return ASTNodes.isSameVariable((QualifiedName)node2, fa);
                    }
                    case 22: {
                        return ASTNodes.isSameVariable(fa, (FieldAccess)node2);
                    }
                }
            }
        }
        return ASTNodes.areVariableBindingsEqual(node1, node2);
    }

    public static int getExclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength();
    }

    public static int getInclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength() - 1;
    }

    public static IMethodBinding getMethodBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IMethodBinding) {
            return (IMethodBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getVariableBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            return (IVariableBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getLocalVariableBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || result.isField()) {
            return null;
        }
        return result;
    }

    public static IVariableBinding getFieldBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || !result.isField()) {
            return null;
        }
        return result;
    }

    public static ITypeBinding getTypeBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof ITypeBinding) {
            return (ITypeBinding)binding;
        }
        return null;
    }

    public static boolean isPrimitive(Expression expression, String primitiveTypeName) {
        return expression != null && ASTNodes.isPrimitive(expression.resolveTypeBinding(), primitiveTypeName);
    }

    private static boolean isPrimitive(ITypeBinding typeBinding, String primitiveTypeName) {
        return typeBinding != null && typeBinding.isPrimitive() && typeBinding.getQualifiedName().equals(primitiveTypeName);
    }

    public static ITypeBinding getReceiverTypeBinding(MethodInvocation invocation) {
        ITypeBinding result = null;
        Expression exp = invocation.getExpression();
        if (exp != null) {
            return exp.resolveTypeBinding();
        }
        AbstractTypeDeclaration type = ASTNodes.getParent((ASTNode)invocation, AbstractTypeDeclaration.class);
        if (type != null) {
            return type.resolveBinding();
        }
        return result;
    }

    public static ITypeBinding getEnclosingType(ASTNode node) {
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            node = node.getParent();
        }
        return null;
    }

    public static IProblem[] getProblems(ASTNode node, int scope, int severity) {
        ASTNode root = node.getRoot();
        if (!(root instanceof CompilationUnit)) {
            return EMPTY_PROBLEMS;
        }
        IProblem[] problems = ((CompilationUnit)root).getProblems();
        if (root == node) {
            return problems;
        }
        int iterations = ASTNodes.computeIterations(scope);
        ArrayList<IProblem> result = new ArrayList<IProblem>(5);
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            boolean consider = false;
            if ((severity & 7) == 7) {
                consider = true;
            } else if ((severity & 1) != 0) {
                consider = problem.isWarning();
            } else if ((severity & 2) != 0) {
                consider = problem.isError();
            } else if ((severity & 4) != 0) {
                consider = problem.isInfo();
            }
            if (consider) {
                ASTNode temp = node;
                int count = iterations;
                do {
                    int problemOffset;
                    int nodeOffset;
                    if ((nodeOffset = temp.getStartPosition()) <= (problemOffset = problem.getSourceStart()) && problemOffset < nodeOffset + temp.getLength()) {
                        result.add(problem);
                        count = 0;
                        continue;
                    }
                    --count;
                } while ((temp = temp.getParent()) != null && count > 0);
            }
            ++n2;
        }
        return result.toArray(new IProblem[result.size()]);
    }

    public static Message[] getMessages(ASTNode node, int flags) {
        ASTNode root = node.getRoot();
        if (!(root instanceof CompilationUnit)) {
            return EMPTY_MESSAGES;
        }
        Message[] messages = ((CompilationUnit)root).getMessages();
        if (root == node) {
            return messages;
        }
        int iterations = ASTNodes.computeIterations(flags);
        ArrayList<Message> result = new ArrayList<Message>(5);
        Message[] messageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            Message message = messageArray[n2];
            ASTNode temp = node;
            int count = iterations;
            do {
                int messageOffset;
                int nodeOffset;
                if ((nodeOffset = temp.getStartPosition()) <= (messageOffset = message.getStartPosition()) && messageOffset < nodeOffset + temp.getLength()) {
                    result.add(message);
                    count = 0;
                    continue;
                }
                --count;
            } while ((temp = temp.getParent()) != null && count > 0);
            ++n2;
        }
        return result.toArray(new Message[result.size()]);
    }

    private static int computeIterations(int flags) {
        switch (flags) {
            case 0: {
                return 1;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public static SimpleName getLeftMostSimpleName(Name name) {
        if (name instanceof SimpleName) {
            return (SimpleName)name;
        }
        final SimpleName[] result = new SimpleName[1];
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                Name left = qualifiedName.getQualifier();
                if (left instanceof SimpleName) {
                    result[0] = (SimpleName)left;
                } else {
                    left.accept((ASTVisitor)this);
                }
                return false;
            }
        };
        name.accept(visitor);
        return result[0];
    }

    public static Name getTopMostName(Name name) {
        Name result = name;
        while (result.getParent() instanceof Name) {
            result = (Name)result.getParent();
        }
        return result;
    }

    public static Type getTopMostType(ASTNode node) {
        ASTNode result = null;
        while (node instanceof Type && !(node instanceof UnionType) || node instanceof Name || node instanceof Annotation || node instanceof MemberValuePair || node instanceof Expression) {
            result = node;
            node = node.getParent();
        }
        if (result instanceof Type) {
            return (Type)result;
        }
        return null;
    }

    public static int changeVisibility(int modifiers, int visibility) {
        return modifiers & 0xFFFFFFF8 | visibility;
    }

    public static void setFlagsToAST(ASTNode root, final int flags) {
        root.accept((ASTVisitor)new GenericVisitor(true){

            @Override
            protected boolean visitNode(ASTNode node) {
                node.setFlags(node.getFlags() | flags);
                return true;
            }
        });
    }

    public static String getQualifier(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getQualifier().getFullyQualifiedName();
        }
        return "";
    }

    public static String getSimpleNameIdentifier(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().getIdentifier();
        }
        return ((SimpleName)name).getIdentifier();
    }

    public static boolean isDeclaration(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().isDeclaration();
        }
        return ((SimpleName)name).isDeclaration();
    }

    public static boolean isField(QualifiedName node, String qualifiedTypeName, String ... fieldNames) {
        return ASTNodes.instanceOf((Expression)node, qualifiedTypeName) && Arrays.asList(fieldNames).contains(node.getName().getIdentifier());
    }

    public static boolean isExceptionExpected(ASTNode node) {
        ASTNode parentNode = ASTNodes.getFirstAncestorOrNull(node, TryStatement.class, BodyDeclaration.class);
        while (parentNode instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)parentNode;
            List catchClauses = tryStatement.catchClauses();
            for (CatchClause catchClause : catchClauses) {
                if (catchClause.getException().getType() == null || ASTNodes.instanceOf(catchClause.getException().getType().resolveBinding(), RuntimeException.class.getCanonicalName())) continue;
                return true;
            }
            parentNode = ASTNodes.getFirstAncestorOrNull(parentNode, TryStatement.class, BodyDeclaration.class);
        }
        return false;
    }

    public static boolean hasConflictingMethodOrConstructor(ASTNode methodOrConstructor, IMethodBinding methodOrConstructorBinding, ITypeBinding[] expectedArgumentTypes) {
        TypeDeclaration typeDeclaration = ASTNodes.getTypedAncestor(methodOrConstructor, TypeDeclaration.class);
        if (typeDeclaration == null) {
            return true;
        }
        ITypeBinding type = typeDeclaration.resolveBinding();
        if (type == null) {
            return true;
        }
        boolean inSameClass = true;
        if (methodOrConstructor instanceof ClassInstanceCreation) {
            type = ((ClassInstanceCreation)methodOrConstructor).resolveTypeBinding();
            inSameClass = type.isNested();
        } else if (methodOrConstructor instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)methodOrConstructor;
            Expression expression = methodInvocation.getExpression();
            if (expression == null) {
                ASTNode root = methodOrConstructor.getRoot();
                if (root instanceof CompilationUnit) {
                    CompilationUnit compilationUnit = (CompilationUnit)root;
                    List imports = compilationUnit.imports();
                    String localPackage = null;
                    if (compilationUnit.getPackage() != null && compilationUnit.getPackage().getName() != null) {
                        localPackage = compilationUnit.getPackage().getName().getFullyQualifiedName();
                    }
                    for (ImportDeclaration oneImport : imports) {
                        if (!oneImport.isStatic() || oneImport.isOnDemand() || !(oneImport.getName() instanceof QualifiedName)) continue;
                        QualifiedName methodName = (QualifiedName)oneImport.getName();
                        String methodIdentifier = methodName.getName().getIdentifier();
                        ITypeBinding conflictingType = methodName.getQualifier().resolveTypeBinding();
                        if (conflictingType == null) {
                            return true;
                        }
                        String importPackage = null;
                        if (conflictingType.getPackage() != null) {
                            importPackage = conflictingType.getPackage().getName();
                        }
                        boolean inSamePackage = Objects.equals(localPackage, importPackage);
                        IMethodBinding[] iMethodBindingArray = conflictingType.getDeclaredMethods();
                        int n = iMethodBindingArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethodBinding declaredMethod = iMethodBindingArray[n2];
                            if (methodIdentifier.equals(declaredMethod.getName()) && ASTNodes.isMethodMatching(expectedArgumentTypes, methodOrConstructorBinding, false, inSamePackage, declaredMethod)) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                }
                if (Modifier.isStatic((int)methodOrConstructorBinding.getModifiers())) {
                    inSameClass = methodOrConstructorBinding.getDeclaringClass().isEqualTo((IBinding)type);
                    type = methodOrConstructorBinding.getDeclaringClass();
                }
            } else if (!(expression instanceof ThisExpression)) {
                inSameClass = methodOrConstructorBinding.getDeclaringClass().isEqualTo((IBinding)type);
                type = expression.resolveTypeBinding();
            }
        } else if (methodOrConstructor instanceof SuperMethodInvocation) {
            inSameClass = type.isNested();
            type = type.getSuperclass();
        } else {
            return true;
        }
        if (type == null) {
            return true;
        }
        return ASTNodes.hasEquivalentMethodForInheritedTypes(expectedArgumentTypes, methodOrConstructorBinding, type, type, inSameClass);
    }

    private static boolean hasEquivalentMethodForInheritedTypes(ITypeBinding[] parameterTypesForConflictingMethod, IMethodBinding binding, ITypeBinding type, ITypeBinding origType, boolean wasInSameClass) {
        ITypeBinding superType = type;
        boolean inSameClass = wasInSameClass;
        while (superType != null) {
            IPackageBinding packageBinding = superType.getPackage();
            boolean inSamePackage = packageBinding.isEqualTo((IBinding)origType.getPackage());
            if (ASTNodes.hasEquivalentMethodForOneType(parameterTypesForConflictingMethod, binding, superType, inSameClass, inSamePackage)) {
                return true;
            }
            if (superType.isNested()) {
                if (ASTNodes.hasEquivalentMethodForInheritedTypes(parameterTypesForConflictingMethod, binding, superType.getDeclaringClass(), origType, inSameClass)) {
                    return true;
                }
                superType = superType.getSuperclass();
                inSameClass &= superType.isNested();
                continue;
            }
            superType = superType.getSuperclass();
            inSameClass = false;
        }
        return false;
    }

    private static boolean hasEquivalentMethodForOneType(ITypeBinding[] parameterTypesForConflictingMethod, IMethodBinding binding, ITypeBinding type, boolean inSameClass, boolean inSamePackage) {
        IMethodBinding[] iMethodBindingArray = type.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (ASTNodes.isMethodMatching(parameterTypesForConflictingMethod, binding, inSameClass, inSamePackage, method)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isMethodMatching(ITypeBinding[] parameterTypesForConflictingMethod, IMethodBinding binding, boolean inSameClass, boolean inSamePackage, IMethodBinding testedMethod) {
        int methodModifiers = testedMethod.getModifiers();
        ITypeBinding[] parameterTypes = testedMethod.getParameterTypes();
        if (!binding.isEqualTo((IBinding)testedMethod) && parameterTypesForConflictingMethod.length == parameterTypes.length && binding.getName().equals(testedMethod.getName()) && (inSameClass || Modifier.isPublic((int)methodModifiers) || Modifier.isProtected((int)methodModifiers) || inSamePackage && !Modifier.isPrivate((int)methodModifiers))) {
            int i = 0;
            while (i < parameterTypesForConflictingMethod.length) {
                if (parameterTypesForConflictingMethod[i] == null || parameterTypes[i] == null) {
                    return true;
                }
                if (!parameterTypesForConflictingMethod[i].isAssignmentCompatible(parameterTypes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean usesGivenSignature(MethodInvocation node, String typeQualifiedName, String methodName, String ... parameterTypesQualifiedNames) {
        return node != null && ASTNodes.usesGivenSignature(node.resolveMethodBinding(), typeQualifiedName, methodName, parameterTypesQualifiedNames);
    }

    public static boolean usesGivenSignature(MethodDeclaration actualMethod, String typeQualifiedName, String methodName, String ... parameterTypesQualifiedNames) {
        return actualMethod != null && ASTNodes.usesGivenSignature(actualMethod.resolveBinding(), typeQualifiedName, methodName, parameterTypesQualifiedNames);
    }

    public static boolean usesGivenSignature(IMethodBinding methodBinding, String typeQualifiedName, String methodName, String ... parameterTypesQualifiedNames) {
        if (methodBinding == null || !methodName.equals(methodBinding.getName()) || methodBinding.getParameterTypes().length != parameterTypesQualifiedNames.length) {
            return false;
        }
        ITypeBinding declaringClass = methodBinding.getDeclaringClass();
        ITypeBinding implementedType = ASTNodes.findImplementedType(declaringClass, typeQualifiedName);
        if (ASTNodes.parameterTypesMatch(implementedType, methodBinding, parameterTypesQualifiedNames)) {
            return true;
        }
        IMethodBinding overriddenMethod = ASTNodes.findOverridenMethod(declaringClass, typeQualifiedName, methodName, parameterTypesQualifiedNames);
        if (overriddenMethod != null && methodBinding.overrides(overriddenMethod)) {
            return true;
        }
        IMethodBinding methodDeclaration = methodBinding.getMethodDeclaration();
        return methodDeclaration != null && methodDeclaration != methodBinding && ASTNodes.usesGivenSignature(methodDeclaration, typeQualifiedName, methodName, parameterTypesQualifiedNames);
    }

    private static boolean parameterTypesMatch(ITypeBinding implementedType, IMethodBinding methodBinding, String[] parameterTypesQualifiedNames) {
        ITypeBinding erasure;
        if (implementedType != null && !implementedType.isRawType() && ((erasure = implementedType.getErasure()).isGenericType() || erasure.isParameterizedType())) {
            return ASTNodes.parameterizedTypesMatch(implementedType, erasure, methodBinding);
        }
        return implementedType != null && ASTNodes.concreteTypesMatch(methodBinding.getParameterTypes(), parameterTypesQualifiedNames);
    }

    private static IMethodBinding findOverridenMethod(ITypeBinding typeBinding, String typeQualifiedName, String methodName, String[] parameterTypesQualifiedNames) {
        ITypeBinding superclassBinding = typeBinding.getSuperclass();
        if (superclassBinding != null) {
            if (typeQualifiedName.equals((superclassBinding = superclassBinding.getErasure()).getErasure().getQualifiedName())) {
                return ASTNodes.findOverridenMethod(methodName, parameterTypesQualifiedNames, superclassBinding.getDeclaredMethods());
            }
            IMethodBinding overridenMethod = ASTNodes.findOverridenMethod(superclassBinding, typeQualifiedName, methodName, parameterTypesQualifiedNames);
            if (overridenMethod != null) {
                return overridenMethod;
            }
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding itfBinding = iTypeBindingArray[n2];
            if (typeQualifiedName.equals((itfBinding = itfBinding.getErasure()).getQualifiedName())) {
                return ASTNodes.findOverridenMethod(methodName, parameterTypesQualifiedNames, itfBinding.getDeclaredMethods());
            }
            IMethodBinding overridenMethod = ASTNodes.findOverridenMethod(itfBinding, typeQualifiedName, methodName, parameterTypesQualifiedNames);
            if (overridenMethod != null) {
                return overridenMethod;
            }
            ++n2;
        }
        return null;
    }

    private static IMethodBinding findOverridenMethod(String methodName, String[] parameterTypesQualifiedNames, IMethodBinding[] declaredMethods) {
        IMethodBinding[] iMethodBindingArray = declaredMethods;
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
            if (methodBinding.getName().equals(methodName) && methodDecl != null && ASTNodes.concreteTypesMatch(methodDecl.getParameterTypes(), parameterTypesQualifiedNames)) {
                return methodBinding;
            }
            ++n2;
        }
        return null;
    }

    private static boolean concreteTypesMatch(ITypeBinding[] typeBindings, String ... typesQualifiedNames) {
        if (typeBindings.length != typesQualifiedNames.length) {
            return false;
        }
        int i = 0;
        while (i < typesQualifiedNames.length) {
            if (!(typesQualifiedNames[i].equals(typeBindings[i].getQualifiedName()) || typesQualifiedNames[i].equals(Bindings.getBoxedTypeName(typeBindings[i].getQualifiedName())) || typesQualifiedNames[i].equals(Bindings.getUnboxedTypeName(typeBindings[i].getQualifiedName())))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean parameterizedTypesMatch(ITypeBinding clazz, ITypeBinding clazzErasure, IMethodBinding methodBinding) {
        if (clazz.isParameterizedType() && !clazz.equals((Object)clazzErasure)) {
            Map<ITypeBinding, ITypeBinding> genericToConcreteTypeParamsFromClass = ASTNodes.getGenericToConcreteTypeParamsMap(clazz, clazzErasure);
            IMethodBinding[] iMethodBindingArray = clazzErasure.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding declaredMethod = iMethodBindingArray[n2];
                if (declaredMethod.getName().equals(methodBinding.getName())) {
                    Map<ITypeBinding, ITypeBinding> genericToConcreteTypeParams = ASTNodes.getGenericToConcreteTypeParamsMap(methodBinding, declaredMethod);
                    genericToConcreteTypeParams.putAll(genericToConcreteTypeParamsFromClass);
                    if (ASTNodes.parameterizedTypesMatch(genericToConcreteTypeParams, methodBinding, declaredMethod)) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private static Map<ITypeBinding, ITypeBinding> getGenericToConcreteTypeParamsMap(IMethodBinding method, IMethodBinding methodErasure) {
        return ASTNodes.getGenericToConcreteTypeParamsMap(method.getTypeArguments(), methodErasure.getTypeParameters());
    }

    private static Map<ITypeBinding, ITypeBinding> getGenericToConcreteTypeParamsMap(ITypeBinding clazz, ITypeBinding clazzErasure) {
        return ASTNodes.getGenericToConcreteTypeParamsMap(clazz.getTypeArguments(), clazzErasure.getTypeParameters());
    }

    private static Map<ITypeBinding, ITypeBinding> getGenericToConcreteTypeParamsMap(ITypeBinding[] typeParams, ITypeBinding[] genericTypeParams) {
        HashMap<ITypeBinding, ITypeBinding> results = new HashMap<ITypeBinding, ITypeBinding>();
        int i = 0;
        while (i < genericTypeParams.length && i < typeParams.length) {
            results.put(genericTypeParams[i], typeParams[i]);
            ++i;
        }
        return results;
    }

    private static boolean parameterizedTypesMatch(Map<ITypeBinding, ITypeBinding> genericToConcreteTypeParams, IMethodBinding parameterizedMethod, IMethodBinding genericMethod) {
        ITypeBinding[] genericParamTypes;
        ITypeBinding[] paramTypes = parameterizedMethod.getParameterTypes();
        if (paramTypes.length != (genericParamTypes = genericMethod.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < genericParamTypes.length) {
            ITypeBinding erasure2;
            String erasureName2;
            ITypeBinding erasure1;
            String erasureName1;
            ITypeBinding genericParamType = genericParamTypes[i];
            ITypeBinding concreteParamType = null;
            if (genericParamType.isArray()) {
                ITypeBinding concreteElementType = genericToConcreteTypeParams.get(genericParamType.getElementType());
                if (concreteElementType != null) {
                    concreteParamType = concreteElementType.createArrayType(genericParamType.getDimensions());
                }
            } else {
                concreteParamType = genericToConcreteTypeParams.get(genericParamType);
            }
            if (concreteParamType == null) {
                concreteParamType = genericParamType;
            }
            if (!(erasureName1 = (erasure1 = paramTypes[i].getErasure()).isPrimitive() ? Bindings.getBoxedTypeName(erasure1.getQualifiedName()) : erasure1.getQualifiedName()).equals(erasureName2 = (erasure2 = concreteParamType.getErasure()).isPrimitive() ? Bindings.getBoxedTypeName(erasure2.getQualifiedName()) : erasure2.getQualifiedName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ITypeBinding findImplementedType(ITypeBinding typeBinding, String qualifiedTypeName) {
        if (typeBinding == null) {
            return null;
        }
        ITypeBinding typeErasure = typeBinding.getErasure();
        if (qualifiedTypeName.equals(typeBinding.getQualifiedName()) || qualifiedTypeName.equals(typeErasure.getQualifiedName())) {
            return typeBinding;
        }
        return ASTNodes.findImplementedType2(typeBinding, qualifiedTypeName);
    }

    private static ITypeBinding findImplementedType2(ITypeBinding typeBinding, String qualifiedTypeName) {
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            String superClassQualifiedName = superclass.getErasure().getQualifiedName();
            if (qualifiedTypeName.equals(superClassQualifiedName)) {
                return superclass;
            }
            ITypeBinding implementedType = ASTNodes.findImplementedType2(superclass, qualifiedTypeName);
            if (implementedType != null) {
                return implementedType;
            }
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding itfBinding = iTypeBindingArray[n2];
            String itfQualifiedName = itfBinding.getErasure().getQualifiedName();
            if (qualifiedTypeName.equals(itfQualifiedName)) {
                return itfBinding;
            }
            ITypeBinding implementedType = ASTNodes.findImplementedType2(itfBinding, qualifiedTypeName);
            if (implementedType != null) {
                return implementedType;
            }
            ++n2;
        }
        return null;
    }

    public static Modifier findModifierNode(int flag, List<IExtendedModifier> modifiers) {
        for (IExtendedModifier curr : modifiers) {
            if (!(curr instanceof Modifier) || ((Modifier)curr).getKeyword().toFlagValue() != flag) continue;
            return (Modifier)curr;
        }
        return null;
    }

    public static boolean match(List<Statement> referenceStatements, List<Statement> comparedStatements) {
        return ASTNodes.match(ASTSemanticMatcher.INSTANCE, referenceStatements, comparedStatements);
    }

    public static boolean match(ASTSemanticMatcher matcher, List<Statement> referenceStatements, List<Statement> comparedStatements) {
        if (referenceStatements.size() != comparedStatements.size()) {
            return false;
        }
        int codeLine = 0;
        while (codeLine < referenceStatements.size()) {
            if (!ASTNodes.match(matcher, (ASTNode)referenceStatements.get(codeLine), (ASTNode)comparedStatements.get(codeLine))) {
                return false;
            }
            ++codeLine;
        }
        return true;
    }

    public static boolean match(ASTNode node1, ASTNode node2) {
        return ASTNodes.match(ASTSemanticMatcher.INSTANCE, node1, node2);
    }

    public static boolean match(ASTSemanticMatcher matcher, ASTNode node1, ASTNode node2) {
        return matcher.safeSubtreeMatch(node1, node2);
    }

    public static ITypeBinding getTypeBinding(CompilationUnit root, IType type) throws JavaModelException {
        if (type.isAnonymous()) {
            IJavaElement parent = type.getParent();
            if (parent instanceof IField && Flags.isEnum((int)((IMember)parent).getFlags())) {
                AnonymousClassDeclaration declaration;
                EnumConstantDeclaration constant = (EnumConstantDeclaration)NodeFinder.perform((ASTNode)root, (ISourceRange)((ISourceReference)parent).getSourceRange());
                if (constant != null && (declaration = constant.getAnonymousClassDeclaration()) != null) {
                    return declaration.resolveBinding();
                }
            } else {
                ClassInstanceCreation creation = ASTNodes.getParent(NodeFinder.perform((ASTNode)root, (ISourceRange)type.getNameRange()), ClassInstanceCreation.class);
                if (creation != null) {
                    return creation.resolveTypeBinding();
                }
            }
        } else {
            AbstractTypeDeclaration declaration = ASTNodes.getParent(NodeFinder.perform((ASTNode)root, (ISourceRange)type.getNameRange()), AbstractTypeDeclaration.class);
            if (declaration != null) {
                return declaration.resolveBinding();
            }
        }
        return null;
    }

    public static String getEscapedStringLiteral(String stringValue) {
        StringLiteral stringLiteral = AST.newAST((int)IASTSharedValues.SHARED_AST_LEVEL, (boolean)false).newStringLiteral();
        stringLiteral.setLiteralValue(stringValue);
        return stringLiteral.getEscapedValue();
    }

    public static String getEscapedCharacterLiteral(char ch) {
        CharacterLiteral characterLiteral = AST.newAST((int)IASTSharedValues.SHARED_AST_LEVEL, (boolean)false).newCharacterLiteral();
        characterLiteral.setCharValue(ch);
        return characterLiteral.getEscapedValue();
    }

    public static ASTNode getCopyOrReplacement(ASTRewrite rewrite, ASTNode node, TextEditGroup group) {
        ASTNode rewrittenNode = (ASTNode)rewrite.get(node.getParent(), node.getLocationInParent());
        if (rewrittenNode != node) {
            rewrite.replace(rewrittenNode, node, group);
            return rewrittenNode;
        }
        return rewrite.createCopyTarget(node);
    }

    public static <T extends ASTNode> List<T> createMoveTarget(ASTRewrite rewrite, Collection<T> nodes) {
        if (nodes != null) {
            ArrayList<ASTNode> newNodes = new ArrayList<ASTNode>(nodes.size());
            for (ASTNode node : nodes) {
                newNodes.add(rewrite.createMoveTarget(node));
            }
            return newNodes;
        }
        return null;
    }

    public static <T extends ASTNode> T createMoveTarget(ASTRewrite rewrite, T node) {
        return (T)rewrite.createMoveTarget(node);
    }

    public static <T extends ASTNode> T copySubtree(AST target, T node) {
        return (T)ASTNode.copySubtree((AST)target, node);
    }

    public static void removeButKeepComment(ASTRewrite rewrite, ASTNode node, TextEditGroup editGroup) {
        node.setProperty(UNTOUCH_COMMENT, (Object)Boolean.TRUE);
        rewrite.remove(node, editGroup);
    }

    public static void replaceButKeepComment(ASTRewrite rewrite, ASTNode node, ASTNode replacement, TextEditGroup editGroup) {
        node.setProperty(UNTOUCH_COMMENT, (Object)Boolean.TRUE);
        rewrite.replace(node, replacement, editGroup);
    }

    public static void replaceAndRemoveNLS(ASTRewrite rewrite, ASTNode visited, ASTNode replace_with_Call, TextEditGroup editGroup, CompilationUnitRewrite cuRewrite) throws CoreException {
        String original = null;
        ASTNode replacement = null;
        try {
            ASTNode st = ASTNodes.getFirstAncestorOrNull(visited, Statement.class, FieldDeclaration.class);
            CompilationUnit cu = (CompilationUnit)st.getRoot();
            String buffer = cuRewrite.getCu().getBuffer().getContents();
            int origStart = cu.getExtendedStartPosition(st);
            int origLength = cu.getExtendedLength(st);
            original = buffer.substring(origStart, origStart + origLength);
            original = comment.matcher(original).replaceFirst("");
            original = leadingspaces_start.matcher(original).replaceAll("");
            original = leadingspaces.matcher(original).replaceAll("\n");
            String visitedString = buffer.substring(visited.getStartPosition(), visited.getStartPosition() + visited.getLength());
            String replacementCallString = replace_with_Call.toString().replaceAll(",", ", ");
            String originalmodified = original.replace(visitedString, replacementCallString);
            replacement = rewrite.createStringPlaceholder(originalmodified, st.getNodeType());
            rewrite.replace(st, replacement, editGroup);
        }
        catch (JavaModelException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public static void replaceAndRemoveNLSByCount(ASTRewrite rewrite, ASTNode visited, String replace_with_Call, int count, TextEditGroup editGroup, CompilationUnitRewrite cuRewrite) throws CoreException {
        String original = null;
        ASTNode replacement = null;
        try {
            ASTNode st = ASTNodes.getFirstAncestorOrNull(visited, Statement.class, FieldDeclaration.class);
            CompilationUnit cu = (CompilationUnit)st.getRoot();
            String buffer = cuRewrite.getCu().getBuffer().getContents();
            int origStart = cu.getExtendedStartPosition(st);
            int origLength = cu.getExtendedLength(st);
            original = buffer.substring(origStart, origStart + origLength);
            Matcher commentMatcher = comment.matcher(original);
            int i = count;
            while (i-- > 0) {
                original = commentMatcher.replaceFirst("");
                commentMatcher = comment.matcher(original);
            }
            original = leadingspaces_start.matcher(original).replaceAll("");
            original = leadingspaces.matcher(original).replaceAll("\n");
            String visitedString = buffer.substring(visited.getStartPosition(), visited.getStartPosition() + visited.getLength());
            String originalmodified = original.replace(visitedString, replace_with_Call);
            replacement = rewrite.createStringPlaceholder(originalmodified, st.getNodeType());
            rewrite.replace(st, replacement, editGroup);
        }
        catch (JavaModelException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public static List<String> getVisibleLocalVariablesInScope(ASTNode node) {
        IBinding[] bindings;
        ArrayList<String> variableNames = new ArrayList<String>();
        CompilationUnit root = (CompilationUnit)node.getRoot();
        IBinding[] iBindingArray = bindings = new ScopeAnalyzer(root).getDeclarationsInScope(node.getStartPosition(), 26);
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            variableNames.add(binding.getName());
            ++n2;
        }
        return variableNames;
    }

    public static List<String> getAllLocalVariablesInBlock(ASTNode node) {
        ArrayList<String> variableNames = new ArrayList<String>();
        CompilationUnit root = (CompilationUnit)node.getRoot();
        Block block = ASTNodes.getFirstAncestorOrNull(node, Block.class);
        if (block != null) {
            Collection<String> names = new ScopeAnalyzer(root).getUsedVariableNames(block.getStartPosition(), block.getLength());
            variableNames.addAll(names);
        }
        return variableNames;
    }

    public static boolean hasSemicolon(ExpressionStatement exprStatement, ICompilationUnit cu) {
        boolean hasSemicolon = true;
        if ((exprStatement.getFlags() & 8) != 0) {
            try {
                Expression expression = exprStatement.getExpression();
                TokenScanner scanner = new TokenScanner((ITypeRoot)cu);
                hasSemicolon = scanner.readNext(expression.getStartPosition() + expression.getLength(), true) == 64;
            }
            catch (CoreException e) {
                hasSemicolon = false;
            }
        }
        return hasSemicolon;
    }

    public static boolean isVarType(ASTNode node, CompilationUnit astRoot) {
        IJavaElement root = astRoot.getJavaElement();
        if (root == null) {
            return false;
        }
        IJavaProject javaProject = root.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        if (!JavaModelUtil.is10OrHigher(javaProject)) {
            return false;
        }
        Type type = null;
        if (node instanceof SimpleName) {
            SimpleName name = (SimpleName)node;
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return false;
            }
            IVariableBinding varBinding = (IVariableBinding)binding;
            if (varBinding.isField() || varBinding.isParameter()) {
                return false;
            }
            ASTNode varDeclaration = astRoot.findDeclaringNode((IBinding)varBinding);
            if (varDeclaration == null) {
                return false;
            }
            ITypeBinding typeBinding = varBinding.getType();
            if (typeBinding == null || typeBinding.isAnonymous() || typeBinding.isIntersectionType() || typeBinding.isWildcardType()) {
                return false;
            }
            if (varDeclaration instanceof SingleVariableDeclaration) {
                type = ((SingleVariableDeclaration)varDeclaration).getType();
            } else if (varDeclaration instanceof VariableDeclarationFragment) {
                ASTNode parent = varDeclaration.getParent();
                if (parent instanceof VariableDeclarationStatement) {
                    type = ((VariableDeclarationStatement)parent).getType();
                } else if (parent instanceof VariableDeclarationExpression) {
                    type = ((VariableDeclarationExpression)parent).getType();
                }
            }
        } else if (node instanceof VariableDeclarationStatement) {
            type = ((VariableDeclarationStatement)node).getType();
        } else {
            return false;
        }
        return type == null ? false : type.isVar();
    }

    public static List<Comment> getLeadingComments(ASTNode node) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        CompilationUnit cu = (CompilationUnit)node.getRoot();
        List commentList = cu.getCommentList();
        for (Comment commentFromList : commentList) {
            if (commentFromList.getStartPosition() < cu.getExtendedStartPosition(node) || commentFromList.getStartPosition() + commentFromList.getLength() >= node.getStartPosition()) continue;
            comments.add(commentFromList);
        }
        return comments;
    }

    public static List<Comment> getTrailingLineComments(ASTNode node, int offset) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        CompilationUnit cu = (CompilationUnit)node.getRoot();
        List commentList = cu.getCommentList();
        int nodeLine = cu.getLineNumber(node.getStartPosition() + offset);
        for (Comment commentFromList : commentList) {
            if (commentFromList.getStartPosition() >= node.getStartPosition() + offset && cu.getLineNumber(commentFromList.getStartPosition()) == nodeLine) {
                comments.add(commentFromList);
                continue;
            }
            if (cu.getLineNumber(nodeLine) > nodeLine) break;
        }
        return comments;
    }

    public static List<Comment> getTrailingComments(ASTNode node) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        CompilationUnit cu = (CompilationUnit)node.getRoot();
        List commentList = cu.getCommentList();
        int extendedStart = cu.getExtendedStartPosition(node);
        int extendedLength = cu.getExtendedLength(node);
        for (Comment commentFromList : commentList) {
            if (commentFromList.getStartPosition() <= node.getStartPosition() || commentFromList.getStartPosition() >= extendedStart + extendedLength) continue;
            comments.add(commentFromList);
        }
        return comments;
    }

    public static List<Comment> getCommentsForRegion(CompilationUnit cu, int start, int length) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        List commentList = cu.getCommentList();
        for (Comment commentFromList : commentList) {
            if (commentFromList.getStartPosition() <= start || commentFromList.getStartPosition() >= start + length) continue;
            comments.add(commentFromList);
        }
        return comments;
    }

    public static int getNumberOfTypeReferences(ITypeBinding typeBinding, CompilationUnit cu) {
        class CounterVisitor
        extends ASTVisitor {
            private int counter = 0;
            private final /* synthetic */ ITypeBinding val$typeBinding;

            CounterVisitor(ITypeBinding iTypeBinding) {
                this.val$typeBinding = iTypeBinding;
            }

            private void checkType(Type type) {
                ITypeBinding binding;
                if (type != null && !type.isParameterizedType() && (binding = type.resolveBinding()) != null) {
                    if (binding.isArray()) {
                        binding = binding.getElementType();
                    }
                    if (binding.isEqualTo((IBinding)this.val$typeBinding)) {
                        ++this.counter;
                    }
                }
            }

            public int getCounter() {
                return this.counter;
            }

            public boolean visit(ArrayCreation node) {
                ArrayType type = node.getType();
                this.checkType((Type)type);
                return true;
            }

            public boolean visit(MethodDeclaration node) {
                Type type = node.getReturnType2();
                this.checkType(type);
                List exceptions = node.thrownExceptionTypes();
                for (Type t : exceptions) {
                    this.checkType(t);
                }
                return true;
            }

            public boolean visit(ClassInstanceCreation node) {
                Type type = node.getType();
                this.checkType(type);
                return true;
            }

            public boolean visit(SingleVariableDeclaration node) {
                Type type = node.getType();
                this.checkType(type);
                return true;
            }

            public boolean visit(CastExpression node) {
                Type type = node.getType();
                this.checkType(type);
                return true;
            }

            public boolean visit(VariableDeclarationExpression node) {
                Type type = node.getType();
                this.checkType(type);
                return true;
            }

            public boolean visit(InstanceofExpression node) {
                Type type = node.getRightOperand();
                this.checkType(type);
                return true;
            }

            public boolean visit(FieldDeclaration node) {
                Type type = node.getType();
                this.checkType(type);
                return true;
            }

            public boolean visit(ParameterizedType node) {
                Type type = node.getType();
                this.checkType(type);
                List types = node.typeArguments();
                for (Type t : types) {
                    this.checkType(t);
                }
                return true;
            }

            public boolean visit(TypeDeclaration node) {
                List types = node.typeParameters();
                for (Type t : types) {
                    this.checkType(t);
                }
                return true;
            }

            public boolean visit(RecordDeclaration node) {
                List types = node.typeParameters();
                for (Type t : types) {
                    this.checkType(t);
                }
                return true;
            }
        }
        CounterVisitor visitor = new CounterVisitor(typeBinding);
        cu.accept((ASTVisitor)visitor);
        return visitor.getCounter();
    }

    private static class AmbiguousMethodAnalyzer
    implements TypeBindingVisitor {
        private TypeEnvironment fTypeEnvironment;
        private TType[] fTypes;
        private IMethodBinding fOriginal;

        public AmbiguousMethodAnalyzer(TypeEnvironment typeEnvironment, IMethodBinding original, TType[] types) {
            this.fTypeEnvironment = typeEnvironment;
            this.fOriginal = original;
            this.fTypes = types;
        }

        @Override
        public boolean visit(ITypeBinding node) {
            IMethodBinding[] methods;
            IMethodBinding[] iMethodBindingArray = methods = node.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding candidate = iMethodBindingArray[n2];
                if (candidate != this.fOriginal && this.fOriginal.getName().equals(candidate.getName()) && this.canImplicitlyCall(candidate)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private boolean canImplicitlyCall(IMethodBinding candidate) {
            ITypeBinding[] parameters = candidate.getParameterTypes();
            if (parameters.length != this.fTypes.length) {
                return false;
            }
            int i = 0;
            while (i < parameters.length) {
                if (!this.fTypes[i].canAssignTo(this.fTypeEnvironment.create(parameters[i]))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class ChildrenCollector
    extends GenericVisitor {
        public List<ASTNode> result = null;

        public ChildrenCollector() {
            super(true);
        }

        @Override
        protected boolean visitNode(ASTNode node) {
            if (this.result == null) {
                this.result = new ArrayList<ASTNode>();
                return true;
            }
            this.result.add(node);
            return false;
        }
    }

    public static enum ExprActivity {
        PASSIVE_WITHOUT_FALLING_THROUGH(0),
        PASSIVE(1),
        CAN_BE_ACTIVE(2),
        ACTIVE(3);

        private final int asInteger;

        private ExprActivity(int asInteger) {
            this.asInteger = asInteger;
        }
    }

    private static final class ExprActivityVisitor
    extends InterruptibleVisitor {
        private ExprActivity activityLevel = ExprActivity.PASSIVE_WITHOUT_FALLING_THROUGH;

        private ExprActivityVisitor() {
        }

        public ExprActivity getActivityLevel() {
            return this.activityLevel;
        }

        public boolean visit(CastExpression node) {
            this.setActivityLevel(ExprActivity.PASSIVE);
            return true;
        }

        public boolean visit(ArrayAccess node) {
            this.setActivityLevel(ExprActivity.PASSIVE);
            return true;
        }

        public boolean visit(FieldAccess node) {
            this.setActivityLevel(ExprActivity.PASSIVE);
            return true;
        }

        public boolean visit(QualifiedName node) {
            if (node.getQualifier() == null || node.getQualifier().resolveBinding() == null || node.getQualifier().resolveBinding().getKind() != 1 && node.getQualifier().resolveBinding().getKind() != 2) {
                this.setActivityLevel(ExprActivity.PASSIVE);
            }
            return true;
        }

        public boolean visit(Assignment node) {
            this.setActivityLevel(ExprActivity.ACTIVE);
            return this.interruptVisit();
        }

        public boolean visit(PrefixExpression node) {
            if (ASTNodes.hasOperator(node, PrefixExpression.Operator.INCREMENT, PrefixExpression.Operator.DECREMENT)) {
                this.setActivityLevel(ExprActivity.ACTIVE);
                return this.interruptVisit();
            }
            if (ASTNodes.hasType(node.getOperand(), Object.class.getCanonicalName())) {
                this.setActivityLevel(ExprActivity.PASSIVE);
            }
            return true;
        }

        public boolean visit(PostfixExpression node) {
            this.setActivityLevel(ExprActivity.ACTIVE);
            return this.interruptVisit();
        }

        public boolean visit(InfixExpression node) {
            if (ASTNodes.hasOperator(node, InfixExpression.Operator.DIVIDE, new InfixExpression.Operator[0])) {
                this.setActivityLevel(ExprActivity.PASSIVE);
            } else {
                for (Expression operand : ASTNodes.allOperands(node)) {
                    if (!ASTNodes.hasType(operand, Object.class.getCanonicalName())) continue;
                    this.setActivityLevel(ExprActivity.PASSIVE);
                    break;
                }
            }
            if (ASTNodes.hasOperator(node, InfixExpression.Operator.PLUS, new InfixExpression.Operator[0]) && ASTNodes.hasType((Expression)node, String.class.getCanonicalName()) && (this.mayCallActiveToString(node.getLeftOperand()) || this.mayCallActiveToString(node.getRightOperand()) || this.mayCallActiveToString(node.extendedOperands()))) {
                this.setActivityLevel(ExprActivity.CAN_BE_ACTIVE);
            }
            return true;
        }

        private boolean mayCallActiveToString(List<Expression> extendedOperands) {
            if (extendedOperands != null) {
                for (Expression expression : extendedOperands) {
                    if (!this.mayCallActiveToString(expression)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean mayCallActiveToString(Expression expression) {
            return !ASTNodes.hasType(expression, String.class.getCanonicalName(), Boolean.TYPE.getSimpleName(), Integer.TYPE.getSimpleName(), Long.TYPE.getSimpleName(), Double.TYPE.getSimpleName(), Float.TYPE.getSimpleName(), Short.TYPE.getSimpleName(), Character.TYPE.getSimpleName(), Boolean.class.getCanonicalName(), Integer.class.getCanonicalName(), Long.class.getCanonicalName(), Double.class.getCanonicalName(), Float.class.getCanonicalName(), Short.class.getCanonicalName(), Character.class.getCanonicalName()) && !(expression instanceof PrefixExpression) && !(expression instanceof InfixExpression) && !(expression instanceof PostfixExpression);
        }

        public boolean visit(SuperMethodInvocation node) {
            this.setActivityLevel(ExprActivity.CAN_BE_ACTIVE);
            return true;
        }

        public boolean visit(MethodInvocation node) {
            this.setActivityLevel(ExprActivity.CAN_BE_ACTIVE);
            return true;
        }

        public boolean visit(ClassInstanceCreation node) {
            this.setActivityLevel(ExprActivity.CAN_BE_ACTIVE);
            return true;
        }

        public boolean visit(ThrowStatement node) {
            this.setActivityLevel(ExprActivity.CAN_BE_ACTIVE);
            return true;
        }

        private void setActivityLevel(ExprActivity newActivityLevel) {
            if (this.activityLevel.asInteger < newActivityLevel.asInteger) {
                this.activityLevel = newActivityLevel;
            }
        }
    }

    private static class FunctionalInterfaceAmbiguousMethodAnalyzer
    implements TypeBindingVisitor {
        private ITypeBinding fDeclaringType;
        private IMethodBinding fOriginalMethod;
        private int fArgIndex;
        private int fArgumentCount;
        private boolean fExpressionIsExplicitlyTyped;

        public FunctionalInterfaceAmbiguousMethodAnalyzer(ITypeBinding declaringType, IMethodBinding originalMethod, int argumentIndex, int argumentCount, boolean expressionIsExplicitlyTyped) {
            this.fDeclaringType = declaringType;
            this.fOriginalMethod = originalMethod;
            this.fArgIndex = argumentIndex;
            this.fArgumentCount = argumentCount;
            this.fExpressionIsExplicitlyTyped = expressionIsExplicitlyTyped;
        }

        @Override
        public boolean visit(ITypeBinding type) {
            IMethodBinding[] iMethodBindingArray = type.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    IMethodBinding candidate;
                    block14: {
                        candidate = iMethodBindingArray[n2];
                        if (candidate.getMethodDeclaration() == this.fOriginalMethod.getMethodDeclaration()) break block13;
                        ITypeBinding candidateDeclaringType = candidate.getDeclaringClass();
                        if (this.fDeclaringType == candidateDeclaringType) break block14;
                        int modifiers = candidate.getModifiers();
                        if (candidateDeclaringType.isInterface() && Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers)) break block13;
                    }
                    if (this.fOriginalMethod.getName().equals(candidate.getName()) && !this.fOriginalMethod.overrides(candidate)) {
                        ITypeBinding parameterType;
                        boolean couldBeAmbiguous;
                        ITypeBinding[] candidateParameterTypes;
                        ITypeBinding[] originalParameterTypes = this.fOriginalMethod.getParameterTypes();
                        if (originalParameterTypes.length == (candidateParameterTypes = candidate.getParameterTypes()).length) {
                            couldBeAmbiguous = true;
                        } else if (this.fOriginalMethod.isVarargs() || candidate.isVarargs()) {
                            int candidateMinArgumentCount = candidateParameterTypes.length;
                            if (candidate.isVarargs()) {
                                --candidateMinArgumentCount;
                            }
                            couldBeAmbiguous = this.fArgumentCount >= candidateMinArgumentCount;
                        } else {
                            couldBeAmbiguous = false;
                        }
                        if (couldBeAmbiguous && (parameterType = ASTResolving.getParameterTypeBinding(candidate, this.fArgIndex)) != null && parameterType.getFunctionalInterfaceMethod() != null) {
                            boolean candidateIsVoidCompatible;
                            if (!this.fExpressionIsExplicitlyTyped) {
                                return false;
                            }
                            ITypeBinding origParamType = ASTResolving.getParameterTypeBinding(this.fOriginalMethod, this.fArgIndex);
                            boolean originalIsVoidCompatible = Bindings.isVoidType(origParamType.getFunctionalInterfaceMethod().getReturnType());
                            if (originalIsVoidCompatible == (candidateIsVoidCompatible = Bindings.isVoidType(parameterType.getFunctionalInterfaceMethod().getReturnType()))) {
                                return false;
                            }
                        }
                    }
                }
                ++n2;
            }
            return true;
        }
    }

    private static class ParentSummary {
        private final IMethodBinding methodBinding;
        private final int argumentIndex;
        private final int argumentCount;
        private final Expression invocationQualifier;

        ParentSummary(IMethodBinding methodBinding, int argumentIndex, int argumentCount, Expression invocationQualifier) {
            this.methodBinding = methodBinding;
            this.argumentIndex = argumentIndex;
            this.argumentCount = argumentCount;
            this.invocationQualifier = invocationQualifier;
        }
    }
}

