/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.ui.editors.ecl.EclEditorInput;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class EclDocumentProvider
extends AbstractDocumentProvider {
    private WorkspaceOperationRunner fOperationRunner;

    protected IDocument createDocument(Object element) throws CoreException {
        if (element instanceof EclEditorInput) {
            String scriptContent = this.getScriptContent((EclEditorInput)((Object)element));
            Document document = new Document(scriptContent);
            return document;
        }
        return null;
    }

    protected String getScriptContent(EclEditorInput element) throws ModelException {
        if (element.getElement() instanceof ITestCase) {
            ITestCase scenario = (ITestCase)element.getElement();
            String scriptContent = Scenarios.getScriptContent((Scenario)((Scenario)scenario.getNamedElement()));
            return scriptContent;
        }
        return "";
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof EclEditorInput) {
            return new ResourceMarkerAnnotationModel(((EclEditorInput)((Object)element)).getElement().getResource());
        }
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        if (this.fOperationRunner == null) {
            this.fOperationRunner = new WorkspaceOperationRunner();
        }
        this.fOperationRunner.setProgressMonitor(monitor);
        return this.fOperationRunner;
    }

    public boolean isModifiable(Object element) {
        return true;
    }

    public boolean isReadOnly(Object element) {
        return false;
    }

    public IContentType getContentType(Object element) throws CoreException {
        IContentType contentType = null;
        if (!this.canSaveDocument(element) && element instanceof EclEditorInput) {
            contentType = this.getContentType(((EclEditorInput)((Object)element)).getElement().getResource());
        }
        if (contentType == null) {
            contentType = super.getContentType(element);
        }
        if (contentType == null && element instanceof EclEditorInput) {
            contentType = this.getContentType(((EclEditorInput)((Object)element)).getElement().getResource());
        }
        return contentType;
    }

    public boolean isSynchronized(Object element) {
        if (element instanceof EclEditorInput) {
            if (this.getElementInfo(element) != null) {
                EclEditorInput input = (EclEditorInput)((Object)element);
                IFile resource = input.getFile();
                return resource.isSynchronized(0);
            }
            return false;
        }
        return super.isSynchronized(element);
    }
}

