/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public abstract class JavaStatusContext
extends RefactoringStatusContext {
    public static RefactoringStatusContext create(IMember member) {
        if (member == null || !member.exists()) {
            return null;
        }
        return new MemberSourceContext(member);
    }

    public static RefactoringStatusContext create(IImportDeclaration declaration) {
        if (declaration == null || !declaration.exists()) {
            return null;
        }
        return new ImportDeclarationSourceContext(declaration);
    }

    public static RefactoringStatusContext create(IMethodBinding method) {
        return JavaStatusContext.create((IMember)((IMethod)method.getJavaElement()));
    }

    public static RefactoringStatusContext create(ITypeRoot typeRoot) {
        return JavaStatusContext.create(typeRoot, null);
    }

    public static RefactoringStatusContext create(ITypeRoot typeRoot, ISourceRange range) {
        if (typeRoot instanceof ICompilationUnit) {
            return new CompilationUnitSourceContext((ICompilationUnit)typeRoot, range);
        }
        if (typeRoot instanceof IClassFile) {
            return new ClassFileSourceContext((IClassFile)typeRoot, range);
        }
        return null;
    }

    public static RefactoringStatusContext create(ITypeRoot typeRoot, ASTNode node) {
        SourceRange range = null;
        if (node != null) {
            range = new SourceRange(node.getStartPosition(), node.getLength());
        }
        return JavaStatusContext.create(typeRoot, range);
    }

    public static RefactoringStatusContext create(ITypeRoot typeRoot, Selection selection) {
        SourceRange range = null;
        if (selection != null) {
            range = new SourceRange(selection.getOffset(), selection.getLength());
        }
        return JavaStatusContext.create(typeRoot, range);
    }

    public abstract boolean isBinary();

    public abstract ICompilationUnit getCompilationUnit();

    public abstract IClassFile getClassFile();

    public abstract ISourceRange getSourceRange();

    public Object getCorrespondingElement() {
        if (this.isBinary()) {
            return this.getClassFile();
        }
        return this.getCompilationUnit();
    }

    private static class ClassFileSourceContext
    extends JavaStatusContext {
        private IClassFile fClassFile;
        private ISourceRange fSourceRange;

        private ClassFileSourceContext(IClassFile classFile, ISourceRange range) {
            this.fClassFile = classFile;
            this.fSourceRange = range;
            if (this.fSourceRange == null) {
                this.fSourceRange = new SourceRange(0, 0);
            }
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return null;
        }

        @Override
        public IClassFile getClassFile() {
            return this.fClassFile;
        }

        @Override
        public ISourceRange getSourceRange() {
            return this.fSourceRange;
        }

        public String toString() {
            return String.valueOf(this.getSourceRange()) + " in " + super.toString();
        }
    }

    private static class CompilationUnitSourceContext
    extends JavaStatusContext {
        private ICompilationUnit fCUnit;
        private ISourceRange fSourceRange;

        private CompilationUnitSourceContext(ICompilationUnit cunit, ISourceRange range) {
            this.fCUnit = cunit;
            this.fSourceRange = range;
            if (this.fSourceRange == null) {
                this.fSourceRange = new SourceRange(0, 0);
            }
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return this.fCUnit;
        }

        @Override
        public IClassFile getClassFile() {
            return null;
        }

        @Override
        public ISourceRange getSourceRange() {
            return this.fSourceRange;
        }

        public String toString() {
            return String.valueOf(this.getSourceRange()) + " in " + super.toString();
        }
    }

    private static class ImportDeclarationSourceContext
    extends JavaStatusContext {
        private IImportDeclaration fImportDeclartion;

        private ImportDeclarationSourceContext(IImportDeclaration declaration) {
            this.fImportDeclartion = declaration;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return (ICompilationUnit)this.fImportDeclartion.getParent().getParent();
        }

        @Override
        public IClassFile getClassFile() {
            return null;
        }

        @Override
        public ISourceRange getSourceRange() {
            try {
                return this.fImportDeclartion.getSourceRange();
            }
            catch (JavaModelException e) {
                return new SourceRange(0, 0);
            }
        }
    }

    private static class MemberSourceContext
    extends JavaStatusContext {
        private IMember fMember;

        private MemberSourceContext(IMember member) {
            this.fMember = member;
        }

        @Override
        public boolean isBinary() {
            return this.fMember.isBinary();
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return this.fMember.getCompilationUnit();
        }

        @Override
        public IClassFile getClassFile() {
            return this.fMember.getClassFile();
        }

        @Override
        public ISourceRange getSourceRange() {
            try {
                return this.fMember.getSourceRange();
            }
            catch (JavaModelException e) {
                return new SourceRange(0, 0);
            }
        }
    }
}

