/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;

public abstract class AbstractActivityManager
implements IActivityManager {
    private ListenerList<IActivityManagerListener> activityManagerListeners;
    private boolean disposed;

    protected AbstractActivityManager() {
    }

    @Override
    public void addActivityManagerListener(IActivityManagerListener activityManagerListener) {
        if (activityManagerListener == null) {
            throw new NullPointerException();
        }
        if (this.activityManagerListeners == null) {
            this.activityManagerListeners = new ListenerList();
        }
        this.activityManagerListeners.add((Object)activityManagerListener);
    }

    protected void fireActivityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (activityManagerEvent == null) {
            throw new NullPointerException();
        }
        if (this.activityManagerListeners != null) {
            for (IActivityManagerListener listener : this.activityManagerListeners) {
                listener.activityManagerChanged(activityManagerEvent);
            }
        }
    }

    @Override
    public void removeActivityManagerListener(IActivityManagerListener activityManagerListener) {
        if (activityManagerListener == null) {
            throw new NullPointerException();
        }
        if (this.activityManagerListeners != null) {
            this.activityManagerListeners.remove((Object)activityManagerListener);
        }
    }

    @Override
    public void dispose() {
        this.activityManagerListeners.clear();
        this.disposed = true;
    }

    protected boolean isDisposed() {
        return this.disposed;
    }
}

