/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;

public class TeslaProcessorManager {
    private final List<ITeslaCommandProcessor> processors = new ArrayList<ITeslaCommandProcessor>();

    public TeslaProcessorManager() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.tesla.core.processor");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            try {
                ITeslaCommandProcessor provider = (ITeslaCommandProcessor)cfg.createExecutableExtension("class");
                this.processors.add(provider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        Collections.sort(this.processors, new ProcessorComparator());
    }

    public void collectInformation(AdvancedInformation collector, Command command) {
        for (ITeslaCommandProcessor processor : this.processors) {
            processor.collectInformation(collector, command);
        }
    }

    public void initializeProcessors(AbstractTeslaClient client, String clientId) {
        for (ITeslaCommandProcessor processor : this.processors) {
            processor.initialize(client, clientId);
        }
    }

    public void terminate() {
        for (ITeslaCommandProcessor processor : this.processors) {
            processor.terminate();
        }
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
        for (ITeslaCommandProcessor processor : this.processors) {
            processor.postSelect(element, mapper);
        }
    }

    public SelectResponse select(SelectCommand command, ElementGenerator generator, IElementProcessorMapper mapper) {
        String kind = command.getData().getKind();
        for (ITeslaCommandProcessor processor : this.processors) {
            SelectResponse response;
            if (!processor.isSelectorSupported(kind) || (response = processor.select(command, generator, mapper)) == null) continue;
            if (response.getStatus().equals((Object)ResponseStatus.FAILED)) {
                return response;
            }
            if (response.getElements().isEmpty()) continue;
            for (Element uiElement : response.getElements()) {
                mapper.map(uiElement, processor);
            }
            return response;
        }
        return null;
    }

    public Response executeCommand(Command command, IElementProcessorMapper abstractTeslaClient, boolean returnOnFirstResult) {
        for (ITeslaCommandProcessor processor : this.processors) {
            Response response;
            if (!processor.isCommandSupported(command) || (response = processor.executeCommand(command, abstractTeslaClient)) == null) continue;
            if (response.getStatus().equals((Object)ResponseStatus.FAILED)) {
                return response;
            }
            if (!returnOnFirstResult) continue;
            return response;
        }
        return null;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        for (ITeslaCommandProcessor processor : this.processors) {
            if (processor.canProceed(context, info)) continue;
            return false;
        }
        return true;
    }

    public void clean() {
        for (ITeslaCommandProcessor processor : this.processors) {
            processor.clean();
        }
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        for (ITeslaCommandProcessor processor : this.processors) {
            ITeslaCommandProcessor.PreExecuteStatus rv = processor.preExecute(command, previousStatus, info);
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    public <T> T getProcessor(Class<T> clazz$) {
        for (ITeslaCommandProcessor processor : this.processors) {
            if (clazz$ != processor.getClass()) continue;
            return clazz$.cast(processor);
        }
        return null;
    }

    public <T> List<T> getProcessors(Class<T> clazz$) {
        ArrayList<T> result = new ArrayList<T>();
        for (ITeslaCommandProcessor processor : this.processors) {
            if (!clazz$.isInstance(processor)) continue;
            result.add(clazz$.cast(processor));
        }
        return result;
    }

    public void notifyUI() {
        for (ITeslaCommandProcessor processor : this.processors) {
            processor.notifyUI();
        }
    }

    private static class ProcessorComparator
    implements Comparator<ITeslaCommandProcessor> {
        private ProcessorComparator() {
        }

        @Override
        public int compare(ITeslaCommandProcessor first, ITeslaCommandProcessor second) {
            return Integer.compare(first.getPriority(), second.getPriority());
        }
    }
}

