/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.nebula.recording.ecl;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.tesla.ecl.model.Selector;
import org.eclipse.rcptt.tesla.ecl.nebula.GetEmptyArea;
import org.eclipse.rcptt.tesla.ecl.nebula.GetItemCell;
import org.eclipse.rcptt.tesla.ecl.nebula.GetNebulaGrid;
import org.eclipse.rcptt.tesla.ecl.nebula.NebulaFactory;
import org.eclipse.rcptt.tesla.ecl.nebula.NebulaPackage;
import org.eclipse.rcptt.tesla.recording.core.ecl.ISelectorParserExtension;

public class NebulaSelectorParserExtension
implements ISelectorParserExtension {
    public Selector selector(String customKindId, String text, List<String> path, List<Integer> indexes) {
        if ("NebulaGrid".equals(customKindId)) {
            return NebulaSelectorParserExtension.makeNebulaGrid();
        }
        if ("NebulaRowHeader".equals(customKindId)) {
            return NebulaSelectorParserExtension.makeRowHeader();
        }
        if ("NebulaItemCell".equals(customKindId)) {
            return NebulaSelectorParserExtension.makeItemCell(text);
        }
        if ("NebulaEmptyArea".equals(customKindId)) {
            return this.makeEmptyArea(path);
        }
        return null;
    }

    private static GetNebulaGrid makeNebulaGrid() {
        return NebulaFactory.eINSTANCE.createGetNebulaGrid();
    }

    static Selector makeRowHeader() {
        return NebulaFactory.eINSTANCE.createGetRowHeader();
    }

    static Selector makeItemCell(String columnTitle) {
        GetItemCell cell = NebulaFactory.eINSTANCE.createGetItemCell();
        cell.setColumn(columnTitle);
        return cell;
    }

    private Selector makeEmptyArea(List<String> path) {
        GetEmptyArea area = NebulaFactory.eINSTANCE.createGetEmptyArea();
        if (path.size() == 2 && path.get(0).equals("COLUMN")) {
            area.setColumn(path.get(1));
        } else {
            for (String p : path) {
                if (p.equals("TOP")) {
                    area.setTop(true);
                }
                if (!p.equals("LEFT")) continue;
                area.setLeft(true);
            }
        }
        return area;
    }

    public boolean isParamNameForced(String commandName, String paramName) {
        String getItemCell = CoreUtils.getScriptletNameByClass((EClass)NebulaPackage.eINSTANCE.getGetItemCell());
        return commandName.equals(getItemCell) && paramName.equals("column");
    }
}

