/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandToElementEntry;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.internal.core.ModelUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class TeslaUtils {
    private static Version eclipseVer;
    private static Version gefVer;
    public static final boolean isMac;
    public static final boolean isWin;
    public static final boolean isLinux;

    static {
        isMac = Platform.getOS().equals("macosx");
        isWin = Platform.getOS().equals("win32");
        isLinux = Platform.getOS().equals("linux");
    }

    private TeslaUtils() {
    }

    public static TeslaScenario merge(TeslaScenario first, TeslaScenario second) {
        TeslaScenario result = first != null ? (TeslaScenario)EcoreUtil.copy((EObject)first) : null;
        TeslaScenario secondCopy = second != null ? (TeslaScenario)EcoreUtil.copy((EObject)second) : null;
        int count = TeslaUtils.getElementsCount(result);
        IdGenerator idGenerator = new IdGenerator(count);
        HashMap<String, Element> elementsMap = new HashMap<String, Element>();
        if (secondCopy != null) {
            for (Command command : secondCopy.getCommands()) {
                ModelUtils.updateElementsAccordingTo(command, elementsMap, new HashSet<EObject>());
                List<Element> elements = TeslaUtils.getElements(secondCopy, command);
                if (elements == null) continue;
                for (Element element : elements) {
                    elementsMap.put(ModelUtils.makeKey(element), element);
                    String newId = idGenerator.getId(element.getId(), element.getKind());
                    element.setId(newId);
                }
            }
            result.getCommands().addAll(secondCopy.getCommands());
            result.getElementMapping().addAll(secondCopy.getElementMapping());
        }
        return result;
    }

    private static List<Element> getElements(TeslaScenario scenario, Command command) {
        EList<CommandToElementEntry> elementMapping = scenario.getElementMapping();
        for (CommandToElementEntry commandToElementEntry : elementMapping) {
            if (!commandToElementEntry.getCommand().equals(command)) continue;
            return commandToElementEntry.getElements();
        }
        return null;
    }

    private static int getElementsCount(TeslaScenario scenario) {
        int count = 0;
        EList<CommandToElementEntry> entries = scenario.getElementMapping();
        for (CommandToElementEntry entry : entries) {
            count += entry.getElements().size();
        }
        return count;
    }

    public static Version getEclipseVersion() {
        if (eclipseVer == null) {
            eclipseVer = new Version(((String)Platform.getBundle((String)"org.eclipse.osgi").getHeaders().get("Bundle-Version")).toString());
        }
        return eclipseVer;
    }

    public static Version getGEFVersion() {
        Bundle gefBundle;
        if (gefVer == null && (gefBundle = Platform.getBundle((String)"org.eclipse.gef")) != null) {
            gefVer = new Version(((String)gefBundle.getHeaders().get("Bundle-Version")).toString());
        }
        return gefVer;
    }

    public static String intToButtonName(int button) {
        switch (button) {
            case 1: {
                return "left";
            }
            case 2: {
                return "middle";
            }
            case 3: {
                return "right";
            }
        }
        return "button" + button;
    }

    public static int buttonNameToInt(String name) {
        if (name == null) {
            return 1;
        }
        if ((name = name.toLowerCase()).equals("left")) {
            return 1;
        }
        if (name.equals("middle")) {
            return 2;
        }
        if (name.equals("right")) {
            return 3;
        }
        if (name.startsWith("button")) {
            String buttonNumber = name.substring("button".length());
            try {
                return Integer.parseInt(buttonNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static class IdGenerator {
        private Map<String, Integer> map = new HashMap<String, Integer>();
        private int start;

        public IdGenerator(int startVal) {
            this.start = startVal;
        }

        public String getId(String oldId, String kind) {
            Integer val = this.map.get(kind);
            if (val == null) {
                val = this.start;
            }
            val = val + 1;
            String id = oldId + "_" + String.valueOf(val);
            this.map.put(kind, val);
            return id;
        }
    }
}

