/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.ui.IBasicMappingNode;

public class BasicElementMapper<T extends IBasicMappingNode> {
    protected Map<String, T> elements = new HashMap<String, T>();
    private Map<T, Element> backElements = new HashMap<T, Element>();
    private ElementGenerator generator = new ElementGenerator();

    public ElementGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(ElementGenerator generator) {
        this.generator = generator;
    }

    private String makeKey(Element uiElement) {
        if (uiElement != null) {
            return uiElement.getKind() + ":" + uiElement.getId();
        }
        return null;
    }

    public T get(Element element) {
        return (T)((IBasicMappingNode)this.elements.get(this.makeKey(element)));
    }

    public Element get(T result) {
        Element element = this.backElements.get(result);
        if (element != null) {
            return element;
        }
        Element resultElement = this.generator.generate(result.getGenerationKind());
        this.elements.put(this.makeKey(resultElement), result);
        this.backElements.put(result, resultElement);
        return resultElement;
    }

    public void put(T result, Element element) {
        this.elements.put(this.makeKey(element), result);
        this.backElements.put(result, element);
    }

    public void remove(Element element) {
        IBasicMappingNode remove = (IBasicMappingNode)this.elements.remove(this.makeKey(element));
        if (remove != null) {
            this.backElements.remove(remove);
        }
    }

    public void clear() {
        this.backElements.clear();
        this.elements.clear();
    }
}

