/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Foreach;
import org.eclipse.rcptt.ecl.core.Let;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.internal.core.LetService;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;

public class ForeachService
implements ICommandService {
    @Override
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        Foreach foreach = (Foreach)command;
        IStatus status = Status.OK_STATUS;
        Val val = foreach.getItem();
        Val indexVal = foreach.getIndex();
        boolean valSet = val != null;
        EList<EObject> objects = foreach.getInput();
        int i = 0;
        int size = objects.size();
        while (i < size) {
            if (!context.isAlive()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            EObject o = (EObject)objects.get(i);
            ISession session = context.getSession();
            IPipe in = null;
            if (valSet) {
                val.setValue(o);
                LetService.getLocals(context).declare(val.getName(), val, true);
            } else {
                in = session.createPipe();
                in.write(o);
                in.close(Status.OK_STATUS);
            }
            IPipe out = session.createPipe();
            Command doCommand = foreach.getDo();
            status = session.execute(ForeachService.wrapBody(i, indexVal, doCommand), in, out).waitFor();
            if (status.getSeverity() != 0) break;
            for (Object outObj : CoreUtils.readPipeContent(out)) {
                context.getOutput().write(outObj);
            }
            ++i;
        }
        return status;
    }

    private static Command wrapBody(int i, Val indexVal, Command body) {
        Let let = CoreFactory.eINSTANCE.createLet();
        let.setBody((Command)EcoreUtil.copy((EObject)body));
        if (indexVal != null) {
            indexVal.setValue(BoxedValues.box(i));
            let.getVals().add((Object)indexVal);
        }
        return let;
    }
}

