/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.rdf4j.sail.lmdb.util.SignificantBytesBE;

public final class Varint {
    static final byte[] ENCODED_LONG_MAX = new byte[]{-1, 127, -1, -1, -1, -1, -1, -1, -1};
    static final byte[] ENCODED_LONG_MAX_QUAD = new byte[]{-1, 127, -1, -1, -1, -1, -1, -1, -1, -1, 127, -1, -1, -1, -1, -1, -1, -1, -1, 127, -1, -1, -1, -1, -1, -1, -1, -1, 127, -1, -1, -1, -1, -1, -1, -1};
    static final byte[] ALL_ZERO_QUAD = new byte[]{0, 0, 0, 0};
    private static final byte[] VARINT_EXTRA_BYTES = Varint.buildVarintExtraBytes();
    private static final int[] FIRST_TO_LENGTH = Varint.buildFirstToLength();

    private Varint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeUnsigned(ByteBuffer bb, long value) {
        if (value == Long.MAX_VALUE) {
            ByteOrder prev = bb.order();
            if (prev != ByteOrder.BIG_ENDIAN) {
                bb.order(ByteOrder.BIG_ENDIAN);
            }
            try {
                bb.put(ENCODED_LONG_MAX);
            }
            finally {
                if (prev != ByteOrder.BIG_ENDIAN) {
                    bb.order(prev);
                }
            }
            return;
        }
        if (value <= 240L) {
            bb.put((byte)value);
        } else if (value <= 2287L) {
            long v = value - 240L;
            ByteOrder prev = bb.order();
            if (prev != ByteOrder.BIG_ENDIAN) {
                bb.order(ByteOrder.BIG_ENDIAN);
            }
            try {
                int hi = (int)(v >>> 8) + 241;
                int lo = (int)(v & 0xFFL);
                bb.putShort((short)(hi << 8 | lo));
            }
            finally {
                if (prev != ByteOrder.BIG_ENDIAN) {
                    bb.order(prev);
                }
            }
        } else if (value <= 67823L) {
            long v = value - 2288L;
            bb.put((byte)-7);
            ByteOrder prev = bb.order();
            if (prev != ByteOrder.BIG_ENDIAN) {
                bb.order(ByteOrder.BIG_ENDIAN);
            }
            try {
                bb.putShort((short)v);
            }
            finally {
                if (prev != ByteOrder.BIG_ENDIAN) {
                    bb.order(prev);
                }
            }
        } else {
            int bytes = Varint.descriptor(value) + 1;
            bb.put((byte)(250 + (bytes - 3)));
            Varint.writeSignificantBits(bb, value, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSignificantBits(ByteBuffer bb, long value, int bytes) {
        ByteOrder prev = bb.order();
        if (prev != ByteOrder.BIG_ENDIAN) {
            bb.order(ByteOrder.BIG_ENDIAN);
        }
        try {
            int shift;
            int i = bytes;
            if ((i & 1) != 0) {
                bb.put((byte)(value >>> (i - 1) * 8));
                --i;
            }
            if (i == 8) {
                bb.putLong(value);
                return;
            }
            if (i >= 4) {
                shift = (i - 4) * 8;
                bb.putInt((int)(value >>> shift));
                i -= 4;
            }
            while (i >= 2) {
                shift = (i - 2) * 8;
                bb.putShort((short)(value >>> shift));
                i -= 2;
            }
        }
        finally {
            if (prev != ByteOrder.BIG_ENDIAN) {
                bb.order(prev);
            }
        }
    }

    public static int calcLengthUnsigned(long value) {
        if (value <= 240L) {
            return 1;
        }
        if (value <= 2287L) {
            return 2;
        }
        if (value <= 67823L) {
            return 3;
        }
        int bytes = Varint.descriptor(value) + 1;
        return 1 + bytes;
    }

    public static int calcListLengthUnsigned(long a, long b, long c, long d) {
        return Varint.calcLengthUnsigned(a) + Varint.calcLengthUnsigned(b) + Varint.calcLengthUnsigned(c) + Varint.calcLengthUnsigned(d);
    }

    private static byte descriptor(long value) {
        return value == 0L ? (byte)0 : (byte)(7 - Long.numberOfLeadingZeros(value) / 8);
    }

    public static long readUnsigned(ByteBuffer bb) throws IllegalArgumentException {
        int a0 = bb.get() & 0xFF;
        if (a0 <= 240) {
            return a0;
        }
        byte extra = VARINT_EXTRA_BYTES[a0];
        switch (extra) {
            case 1: {
                int a1 = bb.get() & 0xFF;
                return 240L + ((long)(a0 - 241) << 8) + (long)a1;
            }
            case 2: {
                int a1 = bb.get() & 0xFF;
                int a2 = bb.get() & 0xFF;
                return 2288L + ((long)a1 << 8) + (long)a2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Varint.readSignificantBitsDirect(bb, extra);
            }
        }
        throw new IllegalArgumentException("Bytes is higher than 8: " + extra);
    }

    public static void skipUnsigned(ByteBuffer bb) throws IllegalArgumentException {
        int a0 = bb.get() & 0xFF;
        if (a0 <= 240) {
            return;
        }
        byte extra = VARINT_EXTRA_BYTES[a0];
        bb.position(bb.position() + extra);
    }

    private static byte[] buildVarintExtraBytes() {
        int i;
        byte[] t = new byte[256];
        for (i = 0; i <= 240; ++i) {
            t[i] = 0;
        }
        for (i = 241; i <= 248; ++i) {
            t[i] = 1;
        }
        t[249] = 2;
        for (i = 250; i <= 255; ++i) {
            t[i] = (byte)(i - 247);
        }
        return t;
    }

    public static long readUnsignedHeap(ByteBuffer bb) throws IllegalArgumentException {
        int a0 = bb.get() & 0xFF;
        if (a0 <= 240) {
            return a0;
        }
        if (a0 <= 248) {
            int a1 = bb.get() & 0xFF;
            return 240 + 256 * (a0 - 241) + a1;
        }
        if (a0 == 249) {
            int a1 = bb.get() & 0xFF;
            int a2 = bb.get() & 0xFF;
            return 2288 + 256 * a1 + a2;
        }
        int bytes = a0 - 250 + 3;
        return Varint.readSignificantBitsHeap(bb, bytes);
    }

    public static long readUnsigned(ByteBuffer bb, int pos) throws IllegalArgumentException {
        int a0 = bb.get(pos) & 0xFF;
        if (a0 <= 240) {
            return a0;
        }
        if (a0 <= 248) {
            int a1 = bb.get(pos + 1) & 0xFF;
            return 240 + 256 * (a0 - 241) + a1;
        }
        if (a0 == 249) {
            int a1 = bb.get(pos + 1) & 0xFF;
            int a2 = bb.get(pos + 2) & 0xFF;
            return 2288 + 256 * a1 + a2;
        }
        int bytes = a0 - 250 + 3;
        return Varint.readSignificantBits(bb, pos + 1, bytes);
    }

    private static int[] buildFirstToLength() {
        int i;
        int[] t = new int[256];
        for (i = 0; i <= 240; ++i) {
            t[i] = 1;
        }
        for (i = 241; i <= 248; ++i) {
            t[i] = 2;
        }
        t[249] = 3;
        for (i = 250; i <= 255; ++i) {
            t[i] = i - 246;
        }
        return t;
    }

    public static int firstToLength(byte a0) {
        return FIRST_TO_LENGTH[a0 & 0xFF];
    }

    public static long readListElementUnsigned(ByteBuffer bb, int index) {
        int pos = 0;
        for (int i = 0; i < index; ++i) {
            pos += Varint.firstToLength(bb.get(pos));
        }
        return Varint.readUnsigned(bb, pos);
    }

    public static void writeListUnsigned(ByteBuffer bb, long[] values) {
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            if (value <= 240L) {
                bb.put((byte)value);
                continue;
            }
            if (value <= 2287L) {
                bb.put((byte)((value - 240L) / 256L + 241L));
                bb.put((byte)((value - 240L) % 256L));
                continue;
            }
            if (value <= 67823L) {
                bb.put((byte)-7);
                bb.put((byte)((value - 2288L) / 256L));
                bb.put((byte)((value - 2288L) % 256L));
                continue;
            }
            int bytes = Varint.descriptor(value) + 1;
            bb.put((byte)(250 + (bytes - 3)));
            Varint.writeSignificantBits(bb, value, bytes);
        }
    }

    public static void readListUnsigned(ByteBuffer bb, long[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = Varint.readUnsigned(bb);
        }
    }

    public static void readQuadUnsigned(ByteBuffer bb, long[] values) {
        values[0] = Varint.readUnsigned(bb);
        values[1] = Varint.readUnsigned(bb);
        values[2] = Varint.readUnsigned(bb);
        values[3] = Varint.readUnsigned(bb);
    }

    public static void readListUnsigned(ByteBuffer bb, int[] indexMap, long[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[indexMap[i]] = Varint.readUnsigned(bb);
        }
    }

    public static void readQuadUnsigned(ByteBuffer bb, int[] indexMap, long[] values) {
        values[indexMap[0]] = Varint.readUnsigned(bb);
        values[indexMap[1]] = Varint.readUnsigned(bb);
        values[indexMap[2]] = Varint.readUnsigned(bb);
        values[indexMap[3]] = Varint.readUnsigned(bb);
    }

    private static long readSignificantBits(ByteBuffer bb, int n) {
        if (bb.isDirect()) {
            return Varint.readSignificantBitsDirect(bb, n);
        }
        return Varint.readSignificantBitsHeap(bb, n);
    }

    private static long readSignificantBitsDirect(ByteBuffer bb, int n) {
        return SignificantBytesBE.readDirect(bb, n);
    }

    private static long readSignificantBitsHeap(ByteBuffer bb, int n) {
        return SignificantBytesBE.read(bb, n);
    }

    private static long readSignificantBits(ByteBuffer bb, int pos, int bytes) {
        long value = (long)(bb.get(pos++) & 0xFF) << --bytes * 8;
        while (bytes-- > 0) {
            value |= (long)(bb.get(pos++) & 0xFF) << bytes * 8;
        }
        return value;
    }

    private static int compareRegion(ByteBuffer bb1, int startIdx1, ByteBuffer bb2, int startIdx2, int length) {
        int result = 0;
        for (int i = 0; result == 0 && i < length; ++i) {
            result = (bb1.get(startIdx1 + i) & 0xFF) - (bb2.get(startIdx2 + i) & 0xFF);
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    public static class GroupMatcher {
        final ByteBuffer value;
        final boolean[] shouldMatch;
        final int[] lengths;

        public GroupMatcher(ByteBuffer value, boolean[] shouldMatch) {
            this.value = value;
            this.shouldMatch = shouldMatch;
            this.lengths = new int[shouldMatch.length];
            int pos = 0;
            for (int i = 0; i < this.lengths.length; ++i) {
                int length;
                this.lengths[i] = length = Varint.firstToLength(value.get(pos));
                pos += length;
            }
        }

        public GroupMatcher(ByteBuffer value, boolean a, boolean b, boolean c, boolean d, boolean e) {
            this(value, new boolean[]{a, b, c, d, e});
        }

        public boolean matches(ByteBuffer other) {
            int thisPos = 0;
            int otherPos = 0;
            for (int i = 0; i < this.shouldMatch.length; ++i) {
                int length = this.lengths[i];
                int otherLength = Varint.firstToLength(other.get(otherPos));
                if (this.shouldMatch[i] && (length != otherLength || Varint.compareRegion(this.value, thisPos, other, otherPos, length) != 0)) {
                    return false;
                }
                thisPos += length;
                otherPos += otherLength;
            }
            return true;
        }
    }
}

