/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemTriple;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemTripleIterator<X extends Exception>
extends LookAheadIteration<MemTriple> {
    private final MemStatement[] statementList;
    private final MemResource subject;
    private final MemIRI predicate;
    private final MemValue object;
    private final int snapshot;
    private final int statementListSize;
    private int statementIndex;

    public MemTripleIterator(MemStatementList statementList, MemResource subject, MemIRI predicate, MemValue object, int snapshot) throws InterruptedException {
        this.statementList = statementList.getStatements();
        this.statementListSize = statementList.getGuaranteedLastIndexInUse() + 1;
        assert (this.statementListSize <= this.statementList.length);
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.snapshot = snapshot;
        this.statementIndex = -1;
    }

    protected MemTriple getNextElement() {
        ++this.statementIndex;
        while (this.statementIndex < this.statementListSize) {
            MemTriple triple;
            MemStatement statement = this.statementList[this.statementIndex];
            if (statement != null && this.isInSnapshot(statement) && (((MemResource)statement.getSubject()).isTriple() && statement.getSubject() instanceof MemTriple ? (triple = (MemTriple)statement.getSubject()).matchesSPO(this.subject, this.predicate, this.object) : ((MemValue)statement.getObject()).isTriple() && statement.getObject() instanceof MemTriple && (triple = (MemTriple)statement.getObject()).matchesSPO(this.subject, this.predicate, this.object))) {
                return triple;
            }
            ++this.statementIndex;
        }
        return null;
    }

    private boolean isInSnapshot(MemStatement st) {
        return this.snapshot < 0 || st.isInSnapshot(this.snapshot);
    }

    protected void handleClose() {
    }
}

