/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclSparqlConstraintFailureException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SparqlConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTupleHelper;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlConstraintSelect
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(SparqlConstraintSelect.class);
    private static final Pattern MESSAGE_TEMPLATE_PATTERN = Pattern.compile("\\{[?$]([A-Za-z_][A-Za-z0-9_]*)\\}");
    private final SailConnection connection;
    private final PlanNode targets;
    private final String query;
    private final Resource[] dataGraph;
    private final boolean produceValidationReports;
    private final SparqlConstraintComponent constraintComponent;
    private final Shape shape;
    private final String[] variables;
    private final ConstraintComponent.Scope scope;
    private final Dataset dataset;
    private final ParsedQuery parsedQuery;
    private final boolean printed = false;
    private final Value shapesGraphBinding;
    private final Value currentShapeBinding;
    private final Value pathForMessageBinding;
    private ValidationExecutionLogger validationExecutionLogger;

    public SparqlConstraintSelect(SailConnection connection, PlanNode targets, String query, ConstraintComponent.Scope scope, Resource[] dataGraph, boolean produceValidationReports, SparqlConstraintComponent constraintComponent, Shape shape) {
        this.connection = connection;
        this.targets = targets;
        this.query = query;
        this.dataGraph = dataGraph;
        this.produceValidationReports = produceValidationReports;
        this.constraintComponent = constraintComponent;
        this.shape = shape;
        assert (query.contains("$this")) : "Query should contain $this: " + query;
        this.variables = new String[]{"$this"};
        this.scope = scope;
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
        this.currentShapeBinding = shape != null ? shape.getId() : null;
        this.shapesGraphBinding = SparqlConstraintSelect.determineShapesGraphBinding(shape);
        this.pathForMessageBinding = SparqlConstraintSelect.determinePathForMessageBinding(constraintComponent, scope);
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
        try {
            this.parsedQuery = queryParserFactory.getParser().parseQuery(query, null);
        }
        catch (MalformedQueryException e) {
            logger.error("Malformed query: \n{}", (Object)query);
            throw e;
        }
    }

    private static Value determineShapesGraphBinding(Shape shape) {
        if (shape == null) {
            return null;
        }
        Resource[] contexts = shape.getContexts();
        if (contexts == null) {
            return null;
        }
        for (Resource context : contexts) {
            if (context == null || !context.isIRI()) continue;
            return context;
        }
        return null;
    }

    private static Value determinePathForMessageBinding(SparqlConstraintComponent constraintComponent, ConstraintComponent.Scope scope) {
        if (constraintComponent == null || scope != ConstraintComponent.Scope.propertyShape) {
            return null;
        }
        return constraintComponent.getTargetChain().getPath().map(p -> Values.literal((String)p.toSparqlPathString())).orElse(null);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<? extends BindingSet> results;
            CloseableIteration<? extends ValidationTuple> targetIterator;
            ValidationTuple next;
            ValidationTuple nextTarget;

            @Override
            protected void init() {
                assert (this.targetIterator == null);
                this.targetIterator = SparqlConstraintSelect.this.targets.iterator();
            }

            private void calculateNext() {
                while (this.next == null && (this.targetIterator.hasNext() || this.results != null && this.results.hasNext())) {
                    if (this.results == null && this.targetIterator.hasNext()) {
                        this.nextTarget = (ValidationTuple)this.targetIterator.next();
                        MapBindingSet bindings = new MapBindingSet(3);
                        bindings.setBinding("this", this.nextTarget.getActiveTarget());
                        if (SparqlConstraintSelect.this.currentShapeBinding != null) {
                            bindings.setBinding("currentShape", SparqlConstraintSelect.this.currentShapeBinding);
                        }
                        if (SparqlConstraintSelect.this.shapesGraphBinding != null) {
                            bindings.setBinding("shapesGraph", SparqlConstraintSelect.this.shapesGraphBinding);
                        }
                        this.results = SparqlConstraintSelect.this.connection.evaluate(SparqlConstraintSelect.this.parsedQuery.getTupleExpr(), SparqlConstraintSelect.this.dataset, (BindingSet)bindings, true);
                    }
                    if (this.results.hasNext()) {
                        List<Literal> templates;
                        BindingSet bindingSet = (BindingSet)this.results.next();
                        if (bindingSet.hasBinding("failure") && bindingSet.getValue("failure").equals((Object)BooleanLiteral.TRUE)) {
                            throw new ShaclSparqlConstraintFailureException(SparqlConstraintSelect.this.shape, SparqlConstraintSelect.this.query, bindingSet, this.nextTarget.getActiveTarget(), SparqlConstraintSelect.this.dataGraph);
                        }
                        Value value1 = bindingSet.getValue("value");
                        if (value1 == null) {
                            value1 = this.nextTarget.getValue();
                        }
                        Value currentValue = value1;
                        Value path = bindingSet.getValue("path");
                        List<Object> resultMessages = null;
                        Value messageValue = bindingSet.getValue("message");
                        if (messageValue != null) {
                            resultMessages = messageValue.isLiteral() ? List.of((Literal)messageValue) : List.of(Values.literal((String)messageValue.stringValue()));
                        } else if (SparqlConstraintSelect.this.produceValidationReports && !(templates = SparqlConstraintSelect.this.constraintComponent.getDefaultMessage()).isEmpty()) {
                            if (SparqlConstraintSelect.this.constraintComponent.hasMessageTemplateVariables()) {
                                Value focusNode = this.nextTarget.getActiveTarget();
                                resultMessages = templates.stream().map(t -> SparqlConstraintSelect.substituteMessageTemplate(t, bindingSet, focusNode, SparqlConstraintSelect.this.shapesGraphBinding, SparqlConstraintSelect.this.currentShapeBinding, SparqlConstraintSelect.this.pathForMessageBinding)).collect(Collectors.toList());
                            } else {
                                resultMessages = List.copyOf(templates);
                            }
                        }
                        List<Literal> finalResultMessages = resultMessages;
                        if (SparqlConstraintSelect.this.scope == ConstraintComponent.Scope.nodeShape) {
                            this.next = this.nextTarget.addValidationResult(t -> {
                                ValidationResult validationResult = new ValidationResult(t.getActiveTarget(), currentValue, SparqlConstraintSelect.this.shape, SparqlConstraintSelect.this.constraintComponent, SparqlConstraintSelect.this.shape.getSeverity(), ConstraintComponent.Scope.nodeShape, t.getContexts(), SparqlConstraintSelect.this.shape.getContexts());
                                if (finalResultMessages != null) {
                                    validationResult.setMessagesOverride(finalResultMessages);
                                }
                                if (path != null && path.isIRI()) {
                                    validationResult.setPathIri(path);
                                }
                                return validationResult;
                            });
                            continue;
                        }
                        ValidationTuple validationTuple = new ValidationTuple(this.nextTarget.getActiveTarget(), currentValue, SparqlConstraintSelect.this.scope, currentValue != null, this.nextTarget.getContexts());
                        this.next = ValidationTupleHelper.join(this.nextTarget, validationTuple).addValidationResult(t -> {
                            ValidationResult validationResult = new ValidationResult(t.getActiveTarget(), currentValue, SparqlConstraintSelect.this.shape, SparqlConstraintSelect.this.constraintComponent, SparqlConstraintSelect.this.shape.getSeverity(), ConstraintComponent.Scope.propertyShape, t.getContexts(), SparqlConstraintSelect.this.shape.getContexts());
                            if (finalResultMessages != null) {
                                validationResult.setMessagesOverride(finalResultMessages);
                            }
                            if (path != null && path.isIRI()) {
                                validationResult.setPathIri(path);
                            }
                            return validationResult;
                        });
                        continue;
                    }
                    this.results.close();
                    this.results = null;
                }
            }

            @Override
            protected boolean localHasNext() {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void localClose() {
                try {
                    if (this.targetIterator != null) {
                        this.targetIterator.close();
                    }
                }
                finally {
                    if (this.results != null) {
                        this.results.close();
                    }
                }
            }
        };
    }

    @Override
    public int depth() {
        return this.targets.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
    }

    private static Literal substituteMessageTemplate(Literal template, BindingSet bindingSet, Value focusNode, Value shapesGraphBinding, Value currentShapeBinding, Value pathForMessageBinding) {
        String label = template.getLabel();
        Matcher matcher = MESSAGE_TEMPLATE_PATTERN.matcher(label);
        if (!matcher.find()) {
            return template;
        }
        matcher.reset();
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String varName = matcher.group(1);
            Value value = bindingSet.getValue(varName);
            if (value == null) {
                if ("this".equals(varName)) {
                    value = focusNode;
                } else if ("shapesGraph".equals(varName)) {
                    value = shapesGraphBinding;
                } else if ("currentShape".equals(varName)) {
                    value = currentShapeBinding;
                } else if ("PATH".equals(varName)) {
                    value = pathForMessageBinding;
                }
            }
            String replacement = value != null ? value.stringValue() : matcher.group(0);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        if (template.getLanguage().isPresent()) {
            return Values.literal((String)sb.toString(), (String)((String)template.getLanguage().get()));
        }
        return Values.literal((String)sb.toString(), (IRI)template.getDatatype());
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "SparqlConstraintSelect{targets=" + String.valueOf(this.targets) + ", query='" + this.query.replace("\n", "  ") + "', dataGraph=" + Arrays.toString(this.dataGraph) + ", scope=" + String.valueOf((Object)this.scope) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparqlConstraintSelect that = (SparqlConstraintSelect)o;
        if (this.scope != that.scope) {
            return false;
        }
        if (!this.targets.equals(that.targets)) {
            return false;
        }
        if (!this.query.equals(that.query)) {
            return false;
        }
        if (!Arrays.equals(this.dataGraph, that.dataGraph)) {
            return false;
        }
        if (!Arrays.equals(this.variables, that.variables)) {
            return false;
        }
        return Objects.equals(this.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)this.connection).getSail() : this.connection, that.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)that.connection).getSail() : that.connection);
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            int result = ((MemoryStoreConnection)this.connection).getSail().hashCode();
            result = 31 * result + this.targets.hashCode();
            result = 31 * result + this.query.hashCode();
            result = 31 * result + Arrays.hashCode(this.dataGraph);
            result = 31 * result + Arrays.hashCode(this.variables);
            result = 31 * result + this.scope.hashCode();
            return result;
        }
        int result = this.connection.hashCode();
        result = 31 * result + this.targets.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Arrays.hashCode(this.dataGraph);
        result = 31 * result + Arrays.hashCode(this.variables);
        result = 31 * result + this.scope.hashCode();
        return result;
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.targets.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

