/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.repository;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.federated.structures.FedXBooleanQuery;
import org.eclipse.rdf4j.federated.structures.FedXGraphQuery;
import org.eclipse.rdf4j.federated.structures.FedXTupleQuery;
import org.eclipse.rdf4j.federated.structures.QueryType;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.parser.ParsedDescribeQuery;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailBooleanQuery;
import org.eclipse.rdf4j.repository.sail.SailGraphQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailTupleQuery;
import org.eclipse.rdf4j.sail.SailConnection;

public class FedXRepositoryConnection
extends SailRepositoryConnection {
    public static final String BINDING_ORIGINAL_QUERY = "__originalQuery";
    public static final String BINDING_ORIGINAL_BASE_URI = "__originalBaseURI";
    public static final String BINDING_ORIGINAL_QUERY_TYPE = "__originalQueryType";
    public static final String BINDING_ORIGINAL_MAX_EXECUTION_TIME = "__originalQueryMaxExecutionTime";
    public static final Set<String> FEDX_BINDINGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"__originalQuery", "__originalBaseURI", "__originalQueryType", "__originalQueryMaxExecutionTime"}));
    private final FederationContext federationContext;

    protected FedXRepositoryConnection(FedXRepository repository, SailConnection sailConnection) {
        super(repository, sailConnection);
        this.federationContext = repository.getFederationContext();
    }

    @Override
    public SailQuery prepareQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        SailQuery q = super.prepareQuery(ql, queryString, baseURI);
        if (q instanceof SailTupleQuery) {
            this.insertOriginalQueryString(q, queryString, baseURI, QueryType.SELECT);
            q = new FedXTupleQuery((SailTupleQuery)q);
        } else if (q instanceof SailGraphQuery) {
            this.insertOriginalQueryString(q, queryString, baseURI, this.determineGraphQueryType((SailGraphQuery)q));
            q = new FedXGraphQuery((SailGraphQuery)q);
        } else if (q instanceof SailBooleanQuery) {
            this.insertOriginalQueryString(q, queryString, baseURI, QueryType.ASK);
            q = new FedXBooleanQuery((SailBooleanQuery)q);
        }
        this.setIncludeInferredDefault(q);
        return q;
    }

    @Override
    public FedXTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        SailTupleQuery q = super.prepareTupleQuery(ql, queryString, baseURI);
        this.insertOriginalQueryString(q, queryString, baseURI, QueryType.SELECT);
        this.setIncludeInferredDefault(q);
        return new FedXTupleQuery(q);
    }

    @Override
    public FedXGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        SailGraphQuery q = super.prepareGraphQuery(ql, queryString, baseURI);
        this.insertOriginalQueryString(q, queryString, baseURI, this.determineGraphQueryType(q));
        this.setIncludeInferredDefault(q);
        return new FedXGraphQuery(q);
    }

    @Override
    public SailBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        SailBooleanQuery q = super.prepareBooleanQuery(ql, queryString, baseURI);
        this.insertOriginalQueryString(q, queryString, baseURI, QueryType.ASK);
        this.setIncludeInferredDefault(q);
        return new FedXBooleanQuery(q);
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String updateString, String baseURI) throws RepositoryException, MalformedQueryException {
        Update update = super.prepareUpdate(ql, updateString, baseURI);
        this.insertOriginalQueryString(update, updateString, baseURI, QueryType.UPDATE);
        return update;
    }

    private void setIncludeInferredDefault(SailQuery query) {
        query.setIncludeInferred(this.federationContext.getConfig().getIncludeInferredDefault());
    }

    private void insertOriginalQueryString(Operation query, String queryString, String baseURI, QueryType qt) {
        if (baseURI != null) {
            query.setBinding(BINDING_ORIGINAL_BASE_URI, FedXUtil.literal(baseURI));
        }
        query.setBinding(BINDING_ORIGINAL_QUERY, FedXUtil.literal(queryString));
        query.setBinding(BINDING_ORIGINAL_QUERY_TYPE, FedXUtil.literal(qt.name()));
    }

    private QueryType determineGraphQueryType(SailGraphQuery q) {
        if (q.getParsedQuery() instanceof ParsedDescribeQuery) {
            return QueryType.DESCRIBE;
        }
        return QueryType.CONSTRUCT;
    }
}

