/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.order.AvailableStatementOrder;
import org.eclipse.rdf4j.federated.algebra.BoundJoinTupleExpr;
import org.eclipse.rdf4j.federated.algebra.NodeFactory;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.iterator.SingleBindingSetIteration;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.repository.RepositoryException;

public class CheckStatementPattern
implements StatementTupleExpr,
BoundJoinTupleExpr {
    private static final long serialVersionUID = -4063951571744144255L;
    protected final StatementTupleExpr stmt;
    protected final String id;
    protected final QueryInfo queryInfo;
    private double resultSizeEstimate = -1.0;
    private double costEstimate = -1.0;
    private long resultSizeActual = -1L;
    private long totalTimeNanosActual = -1L;

    public CheckStatementPattern(StatementTupleExpr stmt, QueryInfo queryInfo) {
        this.stmt = stmt;
        this.id = NodeFactory.getNextId();
        this.queryInfo = queryInfo;
    }

    public StatementPattern getStatementPattern() {
        return (StatementPattern)this.stmt;
    }

    @Override
    public int getFreeVarCount() {
        return 0;
    }

    @Override
    public List<String> getFreeVars() {
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<StatementSource> getStatementSources() {
        return this.stmt.getStatementSources();
    }

    @Override
    public boolean hasFreeVarsFor(BindingSet binding) {
        return false;
    }

    public Set<String> getAssuredBindingNames() {
        return this.stmt.getAssuredBindingNames();
    }

    public Set<String> getBindingNames() {
        return this.stmt.getBindingNames();
    }

    public QueryModelNode getParentNode() {
        return this.stmt.getParentNode();
    }

    public String getSignature() {
        return this.stmt.getSignature();
    }

    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        this.stmt.replaceChildNode(current, replacement);
    }

    public void replaceWith(QueryModelNode replacement) {
        this.stmt.replaceWith(replacement);
    }

    public void setParentNode(QueryModelNode parent) {
        this.stmt.setParentNode(parent);
    }

    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        this.stmt.visit(visitor);
    }

    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.stmt.visitChildren(visitor);
    }

    public CheckStatementPattern clone() {
        throw new RuntimeException("Operation not supported on this node!");
    }

    public double getResultSizeEstimate() {
        return this.resultSizeEstimate;
    }

    public void setResultSizeEstimate(double resultSizeEstimate) {
        this.resultSizeEstimate = resultSizeEstimate;
    }

    public long getResultSizeActual() {
        return this.resultSizeActual;
    }

    public void setResultSizeActual(long resultSizeActual) {
        this.resultSizeActual = resultSizeActual;
    }

    public double getCostEstimate() {
        return this.costEstimate;
    }

    public void setCostEstimate(double costEstimate) {
        this.costEstimate = costEstimate;
    }

    public long getTotalTimeNanosActual() {
        return this.totalTimeNanosActual;
    }

    public void setTotalTimeNanosActual(long totalTimeNanosActual) {
        this.totalTimeNanosActual = totalTimeNanosActual;
    }

    @Override
    public CloseableIteration<BindingSet> evaluate(BindingSet bindings) throws QueryEvaluationException {
        StatementPattern st = (StatementPattern)this.stmt;
        try {
            for (StatementSource source : this.stmt.getStatementSources()) {
                Endpoint ownedEndpoint = this.queryInfo.getFederationContext().getEndpointManager().getEndpoint(source.getEndpointID());
                TripleSource t = ownedEndpoint.getTripleSource();
                if (!t.hasStatements(st, bindings, this.queryInfo, this.queryInfo.getDataset())) continue;
                return new SingleBindingSetIteration(bindings);
            }
        }
        catch (MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e);
        }
        return new EmptyIteration();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stmt.getQueryInfo();
    }

    public Set<Var> getSupportedOrders(AvailableStatementOrder tripleSource) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setOrder(Var var) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Var getOrder() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

