/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.example.rcp;

import com.ibm.icu.text.MessageFormat;
import java.util.Dictionary;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.recommenders.internal.privacy.example.rcp.dialogs.HeartbeatInterval;
import org.eclipse.recommenders.internal.privacy.example.rcp.l10n.Messages;
import org.eclipse.recommenders.privacy.heartbeat.rcp.IHeartbeatService;
import org.eclipse.recommenders.privacy.rcp.IAnonymousIdService;
import org.eclipse.recommenders.privacy.rcp.IPrivacySettingsService;
import org.eclipse.recommenders.privacy.rcp.PermissionState;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private IPrivacySettingsService settingsService;
    private IAnonymousIdService anonymousIdService;
    private IHeartbeatService heartbeatService;
    private HeartbeatInterval heartbeatInterval;
    private Job heartbeatJob;

    public void start(BundleContext bundleContext) throws Exception {
        IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.settingsService = (IPrivacySettingsService)eclipseContext.get(IPrivacySettingsService.class);
        this.anonymousIdService = (IAnonymousIdService)eclipseContext.get(IAnonymousIdService.class);
        this.heartbeatService = (IHeartbeatService)eclipseContext.get(IHeartbeatService.class);
        this.heartbeatInterval = this.getHeartbeatInterval();
        this.sendHeartbeat();
    }

    private HeartbeatInterval getHeartbeatInterval() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.privacy.example.rcp");
        String delayName = preferences.get("delay", HeartbeatInterval.HOURLY.name());
        return HeartbeatInterval.valueOf(delayName);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.heartbeatJob.cancel();
    }

    private void sendHeartbeat() {
        this.heartbeatJob = new Job(Messages.JOB_SENDING_HEARTBEAT){

            public IStatus run(IProgressMonitor monitor) {
                PermissionState state = Activator.this.settingsService.getState("org.eclipse.recommenders.privacy.example.rcp.principals.example", "org.eclipse.recommenders.privacy.rcp.datums.heartbeat");
                Activator.this.heartbeatInterval = Activator.this.getHeartbeatInterval();
                if (PermissionState.APPROVED.equals((Object)state)) {
                    LOG.info(MessageFormat.format((String)Messages.LOG_INFO_SENDING_PERMISSION_APPROVED, (Object[])new Object[]{"Heartbeat"}));
                    Activator.this.heartbeatService.sendHeartbeat("http://recommenders.eclipse.org/heartbeat", Activator.this.getValueFromHeader("org.eclipse.recommenders.privacy.example.rcp", "Bundle-SymbolicName"), Activator.this.getValueFromHeader("org.eclipse.recommenders.privacy.example.rcp", "Bundle-Version"), monitor, Activator.this.getAnonymousId());
                    if (HeartbeatInterval.ONCE.equals((Object)Activator.this.heartbeatInterval)) {
                        return Status.OK_STATUS;
                    }
                } else if (PermissionState.DISAPPROVED.equals((Object)state)) {
                    LOG.info(MessageFormat.format((String)Messages.LOG_INFO_SENDING_PERMISSION_DISAPPROVED, (Object[])new Object[]{"Heartbeat"}));
                } else {
                    LOG.info(MessageFormat.format((String)Messages.LOG_INFO_SENDING_PERMISSION_UNKNOWN, (Object[])new Object[]{"Heartbeat"}));
                }
                this.schedule(Activator.this.heartbeatInterval.getDelay());
                return Status.OK_STATUS;
            }
        };
        this.heartbeatJob.schedule();
    }

    private String getAnonymousId() {
        if (this.settingsService.isApproved("org.eclipse.recommenders.privacy.example.rcp.principals.example", new String[]{"org.eclipse.recommenders.privacy.rcp.datums.anonymousId"})) {
            LOG.info(MessageFormat.format((String)Messages.LOG_INFO_SENDING_PERMISSION_APPROVED, (Object[])new Object[]{"anonymous ID"}));
            return this.anonymousIdService.getAnonymousId().toString();
        }
        LOG.info(MessageFormat.format((String)Messages.LOG_INFO_SENDING_PERMISSION_DISAPPROVED, (Object[])new Object[]{"anonymous ID"}));
        return null;
    }

    private String getValueFromHeader(String bundleId, String key) {
        Dictionary directory = Platform.getBundle((String)bundleId).getHeaders();
        String value = (String)directory.get(key);
        int parametersIndex = value.indexOf(59);
        return parametersIndex < 0 ? value : value.substring(0, parametersIndex);
    }
}

