/**
 * Copyright (c) 2014 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.recommenders.stats.charts.rcp.renderer.AbstractChartPage;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.ui.data.WeekDays;
import org.eclipse.recommenders.stats.rcp.ui.data.WorkbenchData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;

import com.google.inject.Inject;

public class EclipseActivityChart extends AbstractChartPage {

    private final IDataPersistenceService service;

    @Inject
    public EclipseActivityChart(IDataPersistenceService service) {
        this.service = service;
    }

    @Override
    public Chart createChart() {
        List<String> dayList = new ArrayList<String>();
        List<Double> numberList = new ArrayList<Double>();
        Map<WeekDays, Long> data = WorkbenchData.create(service).getHoursForWeekdays();
        for (WeekDays day : data.keySet()) {
            if (data.get(day) != null) {
                Double hoursPerDay = convertToHours(data.get(day));

                dayList.add(day.getDay());
                numberList.add(hoursPerDay);
            }
        }
        Map<WeekDays, List<Long>> rawData = WorkbenchData.create(service).getRawWeekDayData();
        if (getParent() != null) {
            new Label(getParent(), SWT.NONE).setText("Total number of spent hours: " + getTotalNumber(rawData));
        }

        String[] names = dayList.toArray(new String[dayList.size()]);
        Double[] values = numberList.toArray(new Double[numberList.size()]);

        return BarChartFactory.create("Weekday Performance", "Hours per Day", names, values);
    }

    private Double convertToHours(long data) {
        double formatHours = (double) data / 3600000L;
        return Math.round(formatHours * 100) / 100d;
    }

    private double getTotalNumber(Map<WeekDays, List<Long>> rawData) {
        long result = 0L;
        for (WeekDays day : rawData.keySet()) {
            if (rawData.get(day) != null) {
                List<Long> list = rawData.get(day);
                for (Long time : list) {
                    result += time;
                }
            }
        }

        return convertToHours(result);
    }
}
