/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.events;

import com.google.inject.Inject;
import javax.annotation.PreDestroy;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.WorkbenchSession;
import org.eclipse.ui.IStartup;

public class EclipseWorkbenchCollector
implements IRcpService,
IStartup {
    private long sessionStarted;
    private final IDataPersistenceService service;

    @Inject
    public EclipseWorkbenchCollector(IDataPersistenceService service) {
        this.service = service;
    }

    @PreDestroy
    public void shutDown() {
        WorkbenchSession event = new WorkbenchSession(this.sessionStarted, System.currentTimeMillis());
        this.service.record(event, "org.eclipse.recommenders.stats.rcp.channels.workbenchSession");
    }

    public void earlyStartup() {
        this.sessionStarted = System.currentTimeMillis();
    }
}

