/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.events;

import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.stats.rcp.events.CompletionEvent;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;

public class StatisticsSessionProcessor
extends SessionProcessor
implements IRcpService {
    private static final ASTNode NULL = new NullAstNode();
    private final JavaElementResolver resolver;
    private final IDataPersistenceService persistenceService;
    protected CompletionEvent event;
    private IRecommendersCompletionContext ctx;

    @Inject
    public StatisticsSessionProcessor(JavaElementResolver resolver, IDataPersistenceService persistenceService) {
        this.resolver = resolver;
        this.persistenceService = persistenceService;
    }

    public boolean startSession(IRecommendersCompletionContext ctx) {
        this.ctx = ctx;
        this.flushCurrentEvent();
        this.initEvent();
        return true;
    }

    public void applied(ICompletionProposal proposal) {
        this.event.sessionEnded = System.currentTimeMillis();
        if (proposal instanceof IProcessableProposal) {
            IProcessableProposal p = (IProcessableProposal)proposal;
            CompletionProposal coreProposal = (CompletionProposal)p.getCoreProposal().orNull();
            if (coreProposal != null) {
                this.event.prefix = p.getPrefix();
                this.event.applied = CompletionEvent.ProposalKind.toKind(coreProposal.getKind());
                this.event.completion = new String(coreProposal.getCompletion());
                if (CompletionEvent.ProposalKind.UNKNOWN == this.event.applied && StringUtils.isEmpty((CharSequence)this.event.completion)) {
                    this.event.error = coreProposal.toString();
                }
            }
        } else {
            this.event.applied = CompletionEvent.ProposalKind.UNKNOWN;
        }
        this.flushCurrentEvent();
    }

    public void aboutToClose() {
        if (this.event != null) {
            this.event.sessionEnded = System.currentTimeMillis();
        }
    }

    public void endSession(List<ICompletionProposal> proposals) {
        this.event.numberOfProposals = proposals.size();
    }

    private void initEvent() {
        this.event = new CompletionEvent();
        this.event.sessionStarted = System.currentTimeMillis();
        this.event.completionKind = ((ASTNode)this.ctx.getCompletionNode().or((Object)NULL)).getClass().getSimpleName();
        this.event.completionParentKind = ((ASTNode)this.ctx.getCompletionNodeParent().or((Object)NULL)).getClass().getSimpleName();
        IType receiverType = (IType)this.ctx.getReceiverType().orNull();
        if (receiverType != null) {
            this.event.receiverType = this.resolver.toRecType(receiverType);
        }
        this.event.prefix = this.ctx.getPrefix();
    }

    private void flushCurrentEvent() {
        this.persistenceService.record(this.event, "org.eclipse.recommenders.stats.rcp.channels.completionEvents");
        this.event = null;
    }

    private static class NullAstNode
    extends ASTNode {
        private NullAstNode() {
        }

        public StringBuffer print(int indent, StringBuffer output) {
            return output;
        }
    }
}

