/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.model;

import java.util.List;

public class WorkspaceProjectType {
    private final String name;
    private final List<String> labelList;
    private final String fileCount;
    private final long bytes;

    public WorkspaceProjectType(String name, List<String> labelList, int fileCount, long bytes) {
        this.name = name;
        this.labelList = labelList;
        this.fileCount = Integer.toString(fileCount);
        this.bytes = bytes;
    }

    public String getName() {
        return this.name;
    }

    public String getFileCount() {
        return this.fileCount;
    }

    public long getBytes() {
        return this.bytes;
    }

    public String getType() {
        String displayLabel = null;
        if (this.labelList == null || this.labelList.isEmpty()) {
            return "Unknown Project Type";
        }
        for (String label : this.labelList) {
            if (label == null || label.isEmpty()) continue;
            label = label.replace(" Development", "");
            displayLabel = displayLabel == null ? label : String.valueOf(displayLabel) + "/" + label;
        }
        return String.valueOf(displayLabel) + " Project";
    }
}

