/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.recommenders.stats.rcp.events.CompletionEvent;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;
import org.eclipse.recommenders.stats.rcp.ui.util.TableViewerFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.UiFormsFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.UiFormsSash;
import org.eclipse.recommenders.stats.rcp.ui.views.NavigationViewer;
import org.eclipse.recommenders.stats.rcp.ui.views.StatisticsView;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DeveloperActivityDialog
extends TitleAreaDialog {
    private final IDataPersistenceService persistenceService;

    public DeveloperActivityDialog(Shell parentShell, IDataPersistenceService persistenceService) {
        super(parentShell);
        this.persistenceService = persistenceService;
        this.setShellStyle(2160);
        this.setHelpAvailable(false);
    }

    protected Control createContents(Composite parent) {
        super.createContents(parent);
        this.getShell().setText("Developer Activity Report");
        this.getShell().setSize(750, 600);
        this.setTitle("Developer Activities");
        this.setMessage(this.getDescriptionText());
        return parent;
    }

    protected Control createDialogArea(Composite parent) {
        UiFormsFactory.createSeparator(parent);
        Composite mainComposite = TableViewerFactory.createWrapperComposite(parent);
        mainComposite.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        FormToolkit toolkit = new FormToolkit(mainComposite.getDisplay());
        UiFormsSash sashForm = UiFormsFactory.createSash(mainComposite, toolkit);
        Section masterSection = UiFormsFactory.createSection((Composite)sashForm, toolkit, "Navigation");
        Section detailSection = UiFormsFactory.createSection((Composite)sashForm, toolkit, "Eclipse Usage Statistics");
        Composite masterCmp = UiFormsFactory.createCompositeForSection(toolkit, masterSection);
        Composite detailCmp = UiFormsFactory.createCompositeForSection(toolkit, detailSection);
        sashForm.hookResizeListener();
        StackLayout stack = new StackLayout();
        detailCmp.setLayout((Layout)stack);
        NavigationViewer navigationViewer = new NavigationViewer(masterCmp);
        navigationViewer.createViewer();
        navigationViewer.addSelectionChangedListener(stack, detailCmp, detailSection);
        stack.topControl = new StatisticsView(this.persistenceService).createContent(detailCmp);
        sashForm.setWeights(new int[]{35, 65});
        UiFormsFactory.createSeparator(parent);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected boolean isResizable() {
        return true;
    }

    private String getDescriptionText() {
        String date = "the beginning of recording";
        Collection<CompletionEvent> okayEvents = StatisticData.create(this.persistenceService).getOkayEvents();
        if (okayEvents.size() > 0) {
            Date start = new Date(((CompletionEvent)Iterables.getFirst(okayEvents, null)).sessionStarted);
            date = String.format("%tF", start);
        }
        return "Here is a summary of your activities since " + date;
    }
}

