/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.recommenders.stats.rcp.interfaces.ICategoryItem;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.recommenders.stats.rcp.model.TreeCategory;
import org.eclipse.recommenders.stats.rcp.model.TreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionPointReader {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionPointReader.class);
    private static final String EXTENSION_POINT_ID = "org.eclipse.recommenders.stats.rcp.pages";
    private static final String PAGE = "page";
    private static final String CATEGORY = "category";
    private static final String NAME = "name";
    private static final String IMAGE = "image";
    private static ExtensionPointReader instance = new ExtensionPointReader();

    public static ExtensionPointReader getInstance() {
        return instance;
    }

    public List<ICategoryItem> createTreeObjectsFromExtensions() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        return this.createTreeObjectsFromExtensions(elements);
    }

    @VisibleForTesting
    protected List<ICategoryItem> createTreeObjectsFromExtensions(IConfigurationElement[] elements) {
        if (elements == null) {
            return new ArrayList<ICategoryItem>();
        }
        Map<String, ICategoryItem> catMap = this.buildDataStructure(elements);
        return new ArrayList<ICategoryItem>(catMap.values());
    }

    private Map<String, ICategoryItem> buildDataStructure(IConfigurationElement[] elements) {
        Map<String, ICategoryItem> catMap = this.readCategories(elements);
        this.readItems(elements, catMap);
        return catMap;
    }

    private Map<String, ICategoryItem> readCategories(IConfigurationElement[] elements) {
        HashMap<String, ICategoryItem> catMap = new HashMap<String, ICategoryItem>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementType = element.getName();
            String pluginId = element.getContributor().getName();
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)element.getAttribute(IMAGE));
            Image image = imageDescriptor == null ? null : imageDescriptor.createImage();
            String id = element.getAttribute("id");
            String name = element.getAttribute(NAME);
            if (elementType.equals(CATEGORY) && !catMap.containsKey(id)) {
                TreeCategory cat = new TreeCategory(name, image, element.getAttribute("description"), this.getExecutableObject(element));
                catMap.put(id, cat);
            }
            ++n2;
        }
        return catMap;
    }

    private void readItems(IConfigurationElement[] elements, Map<String, ICategoryItem> catMap) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ICategoryItem catItem;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementType = element.getName();
            String pluginId = element.getContributor().getName();
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)element.getAttribute(IMAGE));
            Image image = imageDescriptor == null ? null : imageDescriptor.createImage();
            String categoryID = element.getAttribute(CATEGORY);
            String name = element.getAttribute(NAME);
            String desc = element.getAttribute("description");
            if (elementType.equals(PAGE) && (catItem = catMap.get(categoryID)) != null) {
                TreeItem item = new TreeItem(name, image, this.getExecutableObject(element), desc);
                catItem.addItem(item);
            }
            ++n2;
        }
    }

    private IPageContent getExecutableObject(IConfigurationElement element) {
        IPageContent object = null;
        try {
            object = (IPageContent)element.createExecutableExtension("class");
        }
        catch (CoreException coreException) {
            LOG.debug("Failed to instantiate executable " + element.getAttribute("class"));
        }
        return object;
    }
}

