/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;

public final class CommandData {
    private final IDataPersistenceService service;

    private CommandData(IDataPersistenceService service) {
        this.service = service;
    }

    public static CommandData create(IDataPersistenceService service) {
        return new CommandData(service);
    }

    public Collection<TriggeredCommandObject> getData() {
        return CommandData.buildViewerModel(this.service.retrieve(TriggeredCommandObject.class, "org.eclipse.recommenders.stats.rcp.channels.triggeredCommands"));
    }

    @VisibleForTesting
    protected static Collection<TriggeredCommandObject> buildViewerModel(Collection<TriggeredCommandObject> commandList) {
        HashMap<String, TriggeredCommandObject> commandMap = new HashMap<String, TriggeredCommandObject>();
        if (commandList != null) {
            for (TriggeredCommandObject command : commandList) {
                if (!commandMap.containsKey(command.commandID)) {
                    commandMap.put(command.commandID, command);
                }
                ((TriggeredCommandObject)commandMap.get(command.commandID)).incrementCounter();
            }
        }
        return commandMap.values();
    }
}

