/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitCommitData {
    private static final Logger LOG = LoggerFactory.getLogger(GitCommitData.class);
    private static final IEclipsePreferences PREFS = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
    private static final String PREFS_DIRECTORIES = "GitRepositoriesView.GitDirectories";
    private static final int COMMITER_COUNT = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readAllGitRepositories() {
        String dirs;
        IEclipsePreferences iEclipsePreferences = PREFS;
        synchronized (iEclipsePreferences) {
            dirs = PREFS.get(PREFS_DIRECTORIES, "");
        }
        return GitCommitData.getGitRepositories(dirs);
    }

    public static Map<String, Double> readAllCommits(String repoPath) {
        HashMap<String, AtomicInteger> committerData = new HashMap<String, AtomicInteger>();
        try {
            List<RevCommit> commits = GitCommitData.readCommits(repoPath);
            for (RevCommit commit : commits) {
                String author = commit.getAuthorIdent().getName();
                if (!committerData.containsKey(author)) {
                    committerData.put(author, new AtomicInteger(0));
                }
                ((AtomicInteger)committerData.get(author)).incrementAndGet();
            }
            LOG.debug("Repo: " + repoPath + " Commit Number: " + commits.size());
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (String key : committerData.keySet()) {
            result.put(key, ((AtomicInteger)committerData.get(key)).doubleValue());
        }
        return result;
    }

    public static String extractRepoName(String repoPath) {
        if (repoPath == null || repoPath.isEmpty()) {
            return "";
        }
        String repo = repoPath;
        if (repo.contains(".git")) {
            repo = repo.replace(".git", "");
        }
        if (repo.contains("\\")) {
            repo = repo.replace("\\", "/");
        }
        File dir = new File(repo);
        return dir.getName();
    }

    public static int getCommitNumber(Map<String, Double> commitMap) {
        int totalNumber = 0;
        for (String key : commitMap.keySet()) {
            totalNumber = (int)((double)totalNumber + commitMap.get(key));
        }
        return totalNumber;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        return GitCommitData.sortByValue(map, 6);
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, int committer) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o2.getValue()).compareTo(o1.getValue());
            }
        });
        int count = 0;
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            if (count >= committer) break;
            result.put(entry.getKey(), (Comparable)entry.getValue());
            ++count;
        }
        return result;
    }

    private static List<RevCommit> readCommits(String repoPath) throws IOException {
        ArrayList<RevCommit> commitList = new ArrayList<RevCommit>();
        Repository repository = GitCommitData.openRepository(repoPath);
        Ref head = repository.getRef("refs/heads/master");
        if (head != null) {
            LOG.debug("Read commit data from GIT repo: " + repoPath);
            RevWalk walk = new RevWalk(repository);
            RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
            walk.markStart(commit);
            for (RevCommit rev : walk) {
                commitList.add(rev);
            }
            walk.dispose();
        }
        repository.close();
        return commitList;
    }

    private static Repository openRepository(String repoPath) throws IOException {
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        repositoryBuilder.setMustExist(true);
        repositoryBuilder.setGitDir(new File(repoPath));
        return repositoryBuilder.build();
    }

    @VisibleForTesting
    protected static Set<String> getGitRepositories(String gitRepos) {
        if (gitRepos == null || gitRepos.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> repoURL = new HashSet<String>();
        Iterable split = Splitter.on((String)File.pathSeparator).split((CharSequence)gitRepos);
        for (String repo : split) {
            if (repo.isEmpty()) continue;
            repoURL.add(repo);
        }
        return repoURL;
    }
}

