/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Collection;
import org.eclipse.recommenders.stats.rcp.events.CompletionEvent;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;

public final class StatisticData {
    private Collection<CompletionEvent> okayEvents;
    private Collection<CompletionEvent> appliedEvents;
    private Collection<CompletionEvent> abortedEvents;
    private final IDataPersistenceService persistenceService;

    private StatisticData(IDataPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
        this.loadEventData();
    }

    public static StatisticData create(IDataPersistenceService persistenceService) {
        return new StatisticData(persistenceService);
    }

    private void loadEventData() {
        Collection<CompletionEvent> eventList = this.persistenceService.retrieve(CompletionEvent.class, "org.eclipse.recommenders.stats.rcp.channels.completionEvents");
        this.okayEvents = Collections2.filter(eventList, (Predicate)Predicates.not((Predicate)new BuggyEventsPredicate()));
        this.appliedEvents = Collections2.filter(this.okayEvents, (Predicate)new HasAppliedProposalPredicate());
        this.abortedEvents = Collections2.filter(this.okayEvents, (Predicate)Predicates.not((Predicate)new HasAppliedProposalPredicate()));
    }

    public Multiset<Object> getStatsData() {
        HashMultiset proposalKindBag = HashMultiset.create();
        CompletionEvent.ProposalKind[] proposalKindArray = CompletionEvent.ProposalKind.values();
        int n = proposalKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            final CompletionEvent.ProposalKind kind = proposalKindArray[n2];
            Collection byKind = Collections2.filter(this.okayEvents, (Predicate)new Predicate<CompletionEvent>(){

                public boolean apply(CompletionEvent input) {
                    return kind == input.applied;
                }
            });
            if (byKind.size() > 0) {
                proposalKindBag.add((Object)kind, byKind.size());
            }
            ++n2;
        }
        return proposalKindBag;
    }

    public Collection<CompletionEvent> getOkayEvents() {
        return this.okayEvents;
    }

    public Collection<CompletionEvent> getAppliedEvents() {
        return this.appliedEvents;
    }

    public Collection<CompletionEvent> getAbortedEvents() {
        return this.abortedEvents;
    }

    private static class BuggyEventsPredicate
    implements Predicate<CompletionEvent> {
        private BuggyEventsPredicate() {
        }

        public boolean apply(CompletionEvent input) {
            return input.numberOfProposals < 1 || input.sessionEnded < input.sessionStarted;
        }
    }

    private static class HasAppliedProposalPredicate
    implements Predicate<CompletionEvent> {
        private HasAppliedProposalPredicate() {
        }

        public boolean apply(CompletionEvent e) {
            return e.applied != null;
        }
    }
}

