/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

import java.io.File;
import java.util.List;

public class WorkspaceDataHelper {
    public static void collectAllFilesFor(File folder, List<File> collectedFiles) {
        if (folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File fileEntry = fileArray[n2];
                if (fileEntry.isDirectory() && WorkspaceDataHelper.isNotSettingsFolder(fileEntry)) {
                    WorkspaceDataHelper.collectAllFilesFor(fileEntry, collectedFiles);
                } else if (fileEntry.isFile() && WorkspaceDataHelper.isNotResourceFile(fileEntry)) {
                    collectedFiles.add(fileEntry);
                }
                ++n2;
            }
        }
    }

    public static long getSizeFor(List<File> list) {
        long size = 0L;
        for (File file : list) {
            size += file.length();
        }
        return size;
    }

    private static boolean isNotSettingsFolder(File fileEntry) {
        return !fileEntry.getName().equals(".settings");
    }

    private static boolean isNotResourceFile(File fileEntry) {
        return !fileEntry.getName().startsWith(".");
    }
}

