/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.recommenders.stats.rcp.model.WorkspaceProjectType;
import org.eclipse.recommenders.stats.rcp.ui.data.WorkspaceDataHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceProjectData {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceProjectData.class);
    private int totalProjects;
    private long totalSize;

    public List<WorkspaceProjectType> readAllProjects() {
        ArrayList<WorkspaceProjectType> modelList = new ArrayList<WorkspaceProjectType>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists()) {
                ArrayList<File> collectedFiles = new ArrayList<File>();
                IPath path = project.getLocation();
                WorkspaceDataHelper.collectAllFilesFor(path.toFile(), collectedFiles);
                try {
                    String name = project.getName();
                    int fileSize = collectedFiles.size();
                    long bytes = WorkspaceDataHelper.getSizeFor(collectedFiles);
                    List<String> labelType = this.getLabelType(workspaceRoot, project);
                    modelList.add(new WorkspaceProjectType(name, labelType, fileSize, bytes));
                }
                catch (CoreException e) {
                    LOG.debug(e.getMessage());
                }
            }
            ++n2;
        }
        this.totalProjects = modelList.size();
        this.totalSize = this.getSumOfAllProjects(modelList);
        return modelList;
    }

    protected List<String> getLabelType(IWorkspaceRoot workspaceRoot, IProject project) throws CoreException {
        String[] natureIds;
        ArrayList<String> labelList = new ArrayList<String>();
        if (project.getDescription() != null && (natureIds = project.getDescription().getNatureIds()) != null) {
            String[] stringArray = natureIds;
            int n = natureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String natureID = stringArray[n2];
                IProjectNatureDescriptor natureDescriptor = workspaceRoot.getWorkspace().getNatureDescriptor(natureID);
                if (natureDescriptor != null && natureDescriptor.getLabel() != null) {
                    labelList.add(natureDescriptor.getLabel());
                }
                ++n2;
            }
        }
        return labelList;
    }

    public int getTotalProjects() {
        return this.totalProjects;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    private long getSumOfAllProjects(List<WorkspaceProjectType> modelList) {
        long sumAllProjects = 0L;
        for (WorkspaceProjectType project : modelList) {
            sumAllProjects += project.getBytes();
        }
        return sumAllProjects;
    }
}

