/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.recommenders.stats.rcp.events.CompletionEvent;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class CommandsUtil {
    private static ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);

    public static String getCommandName(TriggeredCommandObject commandObj) {
        Command command = commandService.getCommand(commandObj.commandID);
        try {
            return command.getName();
        }
        catch (NotDefinedException notDefinedException) {
            return "No name found";
        }
    }

    public static String getCommandDescription(TriggeredCommandObject commandObj) {
        Command command = commandService.getCommand(commandObj.commandID);
        try {
            return command.getDescription() != null ? command.getDescription() : "";
        }
        catch (NotDefinedException notDefinedException) {
            return "No description found";
        }
    }

    public static String getDescriptionText(IDataPersistenceService persistenceService) {
        Collection<CompletionEvent> okayEvents = StatisticData.create(persistenceService).getOkayEvents();
        if (okayEvents.size() > 0) {
            Date start = new Date(((CompletionEvent)Iterables.getFirst(okayEvents, null)).sessionStarted);
            return String.format("%tF", start);
        }
        return "";
    }

    public static int getTriggeredCommandsSize(Collection<TriggeredCommandObject> model) {
        int counter = 0;
        if (model != null) {
            for (TriggeredCommandObject command : model) {
                counter += command.count;
            }
        }
        return counter;
    }
}

