/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;

public class EclipseCategoryData {
    public static double getTotalNumberHours(Map<Long, Long> rawData) {
        if (rawData == null || rawData.isEmpty()) {
            return 0.0;
        }
        long result = 0L;
        for (Long day : rawData.keySet()) {
            Long hours = rawData.get(day);
            result += hours.longValue();
        }
        return EclipseCategoryData.convertToHours(result);
    }

    public static double getMinHoursPerDay(Map<Long, Long> rawData) {
        if (rawData == null || rawData.isEmpty()) {
            return 0.0;
        }
        long minHours = Long.MAX_VALUE;
        for (Long day : rawData.keySet()) {
            Long hours = rawData.get(day);
            if (hours >= minHours) continue;
            minHours = hours;
        }
        return EclipseCategoryData.convertToHours(minHours);
    }

    public static double getMaxHoursPerDay(Map<Long, Long> rawData) {
        if (rawData == null || rawData.isEmpty()) {
            return 0.0;
        }
        long maxHours = Long.MIN_VALUE;
        for (Long day : rawData.keySet()) {
            Long hours = rawData.get(day);
            if (hours <= maxHours) continue;
            maxHours = hours;
        }
        return EclipseCategoryData.convertToHours(maxHours);
    }

    public static List<TriggeredCommandObject> getFavouriteCommands(Collection<TriggeredCommandObject> model) {
        ArrayList<TriggeredCommandObject> result = new ArrayList<TriggeredCommandObject>();
        TriggeredCommandObject first = new TriggeredCommandObject(null, 0L);
        TriggeredCommandObject second = new TriggeredCommandObject(null, 0L);
        TriggeredCommandObject third = new TriggeredCommandObject(null, 0L);
        result.add(first);
        result.add(second);
        result.add(third);
        if (model == null || model.isEmpty()) {
            return result;
        }
        for (TriggeredCommandObject commandObj : model) {
            if (commandObj.count > first.count) {
                third = second;
                second = first;
                first = commandObj;
                continue;
            }
            if (commandObj.count > second.count && commandObj.count <= first.count) {
                third = second;
                second = commandObj;
                continue;
            }
            if (commandObj.count <= third.count || commandObj.count > second.count) continue;
            third = commandObj;
        }
        result.set(0, first);
        result.set(1, second);
        result.set(2, third);
        return result;
    }

    public static Double convertToHours(long data) {
        double formatHours = (double)data / (double)TimeUnit.HOURS.toMillis(1L);
        return (double)Math.round(formatHours * 100.0) / 100.0;
    }
}

