/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Comparator;
import org.eclipse.recommenders.stats.rcp.events.CompletionEvent;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;
import org.eclipse.recommenders.stats.rcp.model.WorkspaceContentType;
import org.eclipse.recommenders.stats.rcp.model.WorkspaceProjectType;
import org.eclipse.recommenders.stats.rcp.ui.util.CommandsUtil;
import org.eclipse.recommenders.stats.rcp.ui.views.CompletionTypeView;
import org.eclipse.recommenders.stats.rcp.ui.views.TriggeredCommandsView;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;

public class TableSorters {
    private static int getInteger(String data) {
        try {
            return Integer.parseInt(data);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static Multiset.Entry<ITypeName> getTypeEntry(Object e) {
        return (Multiset.Entry)Checks.cast((Object)e);
    }

    private static Multiset.Entry<CompletionEvent.ProposalKind> getEntry(Object object) {
        return (Multiset.Entry)Checks.cast((Object)object);
    }

    private TableSorters() {
    }

    public static class Commands {
        public static final Comparator<Object> COUNT_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                TriggeredCommandObject command1 = (TriggeredCommandObject)o1;
                TriggeredCommandObject command2 = (TriggeredCommandObject)o2;
                return new Integer(command1.count).compareTo(command2.count);
            }
        };
        public static final Comparator<Object> ID_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                TriggeredCommandObject command1 = (TriggeredCommandObject)o1;
                TriggeredCommandObject command2 = (TriggeredCommandObject)o2;
                return command1.commandID.compareToIgnoreCase(command2.commandID);
            }
        };

        public static Comparator<Object> getNameComparator(TriggeredCommandsView.CommandsLabelProvider labelProvider) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    TriggeredCommandObject command1 = (TriggeredCommandObject)o1;
                    TriggeredCommandObject command2 = (TriggeredCommandObject)o2;
                    String name1 = CommandsUtil.getCommandName(command1);
                    String name2 = CommandsUtil.getCommandName(command2);
                    return name1.compareToIgnoreCase(name2);
                }
            };
        }
    }

    public static class Completion {
        public static final Comparator<Object> TYPE_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                CompletionEvent.ProposalKind proposal1 = (CompletionEvent.ProposalKind)((Object)TableSorters.getEntry(o1).getElement());
                CompletionEvent.ProposalKind proposal2 = (CompletionEvent.ProposalKind)((Object)TableSorters.getEntry(o2).getElement());
                return proposal1.toString().compareToIgnoreCase(proposal2.toString());
            }
        };
        public static final Comparator<Object> USED_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int listSize1 = TableSorters.getEntry(o1).getCount();
                int listSize2 = TableSorters.getEntry(o2).getCount();
                return new Integer(listSize1).compareTo(listSize2);
            }
        };

        public static Comparator<Object> getLastUsedComparator(final Multimap<CompletionEvent.ProposalKind, CompletionEvent> multiMap, final IDataPersistenceService persistenceService) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    CompletionTypeView completion;
                    CompletionTypeView completionTypeView = completion = new CompletionTypeView(persistenceService);
                    completionTypeView.getClass();
                    CompletionTypeView.ProposalLabelProvider proposalProvider = new CompletionTypeView.ProposalLabelProvider(completionTypeView, (Multimap<CompletionEvent.ProposalKind, CompletionEvent>)multiMap);
                    Long session1 = proposalProvider.getLastSessionStartedFor((CompletionEvent.ProposalKind)((Object)TableSorters.getEntry(o1).getElement()));
                    Long session2 = proposalProvider.getLastSessionStartedFor((CompletionEvent.ProposalKind)((Object)TableSorters.getEntry(o2).getElement()));
                    return session1.compareTo(session2);
                }
            };
        }
    }

    public static class ReceiverType {
        public static final Comparator<Object> TYPE_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String type1 = Names.vm2srcQualifiedType((ITypeName)((ITypeName)TableSorters.getTypeEntry(o1).getElement()));
                String type2 = Names.vm2srcQualifiedType((ITypeName)((ITypeName)TableSorters.getTypeEntry(o2).getElement()));
                return type1.compareToIgnoreCase(type2);
            }
        };
        public static final Comparator<Object> COUNT_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Integer count1 = TableSorters.getTypeEntry(o1).getCount();
                Integer count2 = TableSorters.getTypeEntry(o2).getCount();
                return count1.compareTo(count2);
            }
        };
    }

    public static class WorkspaceFiles {
        public static final Comparator<Object> TYPE_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String type1 = ((WorkspaceContentType)o1).getLabel();
                String type2 = ((WorkspaceContentType)o2).getLabel();
                return type1.compareToIgnoreCase(type2);
            }
        };
        public static final Comparator<Object> COUNT_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Integer count1 = TableSorters.getInteger(((WorkspaceContentType)o1).getCount());
                Integer count2 = TableSorters.getInteger(((WorkspaceContentType)o2).getCount());
                return count1.compareTo(count2);
            }
        };
        public static final Comparator<Object> SIZE_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Long count1 = ((WorkspaceContentType)o1).getBytes();
                Long count2 = ((WorkspaceContentType)o2).getBytes();
                return count1.compareTo(count2);
            }
        };
    }

    public static class WorkspaceProjects {
        public static final Comparator<Object> NAME_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String type1 = ((WorkspaceProjectType)o1).getName();
                String type2 = ((WorkspaceProjectType)o2).getName();
                return type1.compareToIgnoreCase(type2);
            }
        };
        public static final Comparator<Object> TYPE_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String type1 = ((WorkspaceProjectType)o1).getType();
                String type2 = ((WorkspaceProjectType)o2).getType();
                return type1.compareToIgnoreCase(type2);
            }
        };
        public static final Comparator<Object> COUNT_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Integer count1 = TableSorters.getInteger(((WorkspaceProjectType)o1).getFileCount());
                Integer count2 = TableSorters.getInteger(((WorkspaceProjectType)o2).getFileCount());
                return count1.compareTo(count2);
            }
        };
        public static final Comparator<Object> SIZE_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Long count1 = ((WorkspaceProjectType)o1).getBytes();
                Long count2 = ((WorkspaceProjectType)o2).getBytes();
                return count1.compareTo(count2);
            }
        };
    }
}

